/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.vector.expressions;

import org.apache.hadoop.hive.ql.exec.vector.VectorExpressionDescriptor;
import org.apache.hadoop.hive.ql.exec.vector.VectorizedRowBatch;
import org.apache.hadoop.hive.ql.exec.vector.expressions.VectorExpression;
import org.apache.hadoop.hive.ql.metadata.HiveException;

public class FilterColAndScalar
extends VectorExpression {
    private static final long serialVersionUID = 1L;
    private int colNum = -1;
    private long value = 0L;

    public FilterColAndScalar() {
    }

    public FilterColAndScalar(int colNum, long scalarVal) {
        this();
        this.colNum = colNum;
        this.value = scalarVal;
    }

    @Override
    public void evaluate(VectorizedRowBatch batch) throws HiveException {
        if (this.value == 0L) {
            batch.size = 0;
            return;
        }
        super.evaluateChildren(batch);
    }

    @Override
    public String vectorExpressionParameters() {
        return this.getColumnParamString(0, this.colNum) + ", val " + this.value;
    }

    @Override
    public VectorExpressionDescriptor.Descriptor getDescriptor() {
        return new VectorExpressionDescriptor.Builder().setMode(VectorExpressionDescriptor.Mode.FILTER).setNumArguments(2).setArgumentTypes(VectorExpressionDescriptor.ArgumentType.INT_FAMILY, VectorExpressionDescriptor.ArgumentType.INT_FAMILY).setInputExpressionTypes(VectorExpressionDescriptor.InputExpressionType.COLUMN, VectorExpressionDescriptor.InputExpressionType.SCALAR).build();
    }
}

