/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.common.type;

import io.trino.hive.$internal.org.apache.commons.lang.StringUtils;
import org.apache.hadoop.hive.common.type.HiveBaseChar;

public class HiveChar
extends HiveBaseChar
implements Comparable<HiveChar> {
    public static final int MAX_CHAR_LENGTH = 255;

    public HiveChar() {
    }

    public HiveChar(String val, int len) {
        this.setValue(val, len);
    }

    public HiveChar(HiveChar hc, int len) {
        this.setValue(hc.value, len);
    }

    @Override
    public void setValue(String val, int len) {
        super.setValue(HiveBaseChar.getPaddedValue(val, len), -1);
    }

    public void setValue(String val) {
        this.setValue(val, -1);
    }

    public String getStrippedValue() {
        return StringUtils.stripEnd(this.value, " ");
    }

    public String getPaddedValue() {
        return this.value;
    }

    @Override
    public int getCharacterLength() {
        String strippedValue = this.getStrippedValue();
        return strippedValue.codePointCount(0, strippedValue.length());
    }

    @Override
    public String toString() {
        return this.getPaddedValue();
    }

    @Override
    public int compareTo(HiveChar rhs) {
        if (rhs == this) {
            return 0;
        }
        return this.getStrippedValue().compareTo(rhs.getStrippedValue());
    }

    public boolean equals(Object rhs) {
        if (rhs == this) {
            return true;
        }
        if (rhs == null || rhs.getClass() != this.getClass()) {
            return false;
        }
        return this.getStrippedValue().equals(((HiveChar)rhs).getStrippedValue());
    }

    @Override
    public int hashCode() {
        return this.getStrippedValue().hashCode();
    }
}

