/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.jaxws.container;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.TraceeLogger;
import io.tracee.Utilities;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.jaxws.AbstractTraceeHandler;
import io.tracee.transport.SoapHeaderTransport;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;

public class TraceeServerHandler
extends AbstractTraceeHandler {
    private final TraceeLogger traceeLogger = this.getTraceeBackend().getLoggerFactory().getLogger(TraceeServerHandler.class);
    private final SoapHeaderTransport transportSerialization;

    public TraceeServerHandler() {
        this(Tracee.getBackend(), new SoapHeaderTransport());
    }

    TraceeServerHandler(TraceeBackend traceeBackend, SoapHeaderTransport soapHeaderTransport) {
        super(traceeBackend);
        this.transportSerialization = soapHeaderTransport;
    }

    @Override
    protected final void handleIncoming(SOAPMessageContext context) {
        SOAPPart soapPart = context.getMessage().getSOAPPart();
        try {
            TraceeBackend backend = this.getTraceeBackend();
            SOAPHeader header = soapPart.getEnvelope().getHeader();
            if (header != null && backend.getConfiguration().shouldProcessContext(TraceeFilterConfiguration.Channel.IncomingRequest)) {
                Map parsedContext = this.transportSerialization.parseSoapHeader((Element)header);
                Map filteredContext = backend.getConfiguration().filterDeniedParams(parsedContext, TraceeFilterConfiguration.Channel.IncomingRequest);
                this.getTraceeBackend().putAll(filteredContext);
            }
            Utilities.generateRequestIdIfNecessary((TraceeBackend)backend);
        }
        catch (SOAPException e) {
            this.traceeLogger.error((Object)"TraceeServerHandler - Error during precessing of inbound soap header");
            this.traceeLogger.debug((Object)"TraceeServerHandler - Error during precessing of inbound soap header", (Throwable)e);
        }
        catch (JAXBException e) {
            this.traceeLogger.error((Object)"TraceeServerHandler - Error during precessing of inbound soap header");
            this.traceeLogger.debug((Object)"TraceeServerHandler - Error during precessing of inbound soap header", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void handleOutgoing(SOAPMessageContext context) {
        TraceeBackend backend = this.getTraceeBackend();
        SOAPMessage msg = context.getMessage();
        try {
            if (msg != null && backend.getConfiguration().shouldProcessContext(TraceeFilterConfiguration.Channel.OutgoingResponse)) {
                SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
                SOAPHeader header = this.getOrCreateHeader(env);
                Map filteredContext = backend.getConfiguration().filterDeniedParams((Map)backend, TraceeFilterConfiguration.Channel.OutgoingResponse);
                this.transportSerialization.renderSoapHeader(filteredContext, header);
                msg.saveChanges();
                context.setMessage(msg);
            }
        }
        catch (SOAPException e) {
            this.traceeLogger.error((Object)"TraceeServerHandler : Exception occurred during processing of outbound message.");
            this.traceeLogger.debug((Object)"TraceeServerHandler : Exception occurred during processing of outbound message.", (Throwable)e);
        }
        catch (JAXBException e) {
            this.traceeLogger.error((Object)"TraceeServerHandler : Exception occurred during processing of outbound message.");
            this.traceeLogger.debug((Object)"TraceeServerHandler : Exception occurred during processing of outbound message.", (Throwable)e);
        }
        finally {
            backend.clear();
        }
    }

    SOAPHeader getOrCreateHeader(SOAPEnvelope soapEnvelope) throws SOAPException {
        SOAPHeader header = soapEnvelope.getHeader();
        if (header != null) {
            return header;
        }
        return soapEnvelope.addHeader();
    }

    public boolean handleFault(SOAPMessageContext context) {
        this.handleOutgoing(context);
        return true;
    }
}

