/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.jaxws.client;

import io.tracee.Tracee;
import io.tracee.TraceeBackend;
import io.tracee.TraceeLogger;
import io.tracee.configuration.TraceeFilterConfiguration;
import io.tracee.jaxws.AbstractTraceeHandler;
import io.tracee.transport.SoapHeaderTransport;
import java.util.Map;
import javax.xml.bind.JAXBException;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.SOAPMessage;
import javax.xml.ws.handler.soap.SOAPMessageContext;
import org.w3c.dom.Element;

public class TraceeClientHandler
extends AbstractTraceeHandler {
    private final TraceeLogger traceeLogger = this.getTraceeBackend().getLoggerFactory().getLogger(TraceeClientHandler.class);
    private final SoapHeaderTransport transportSerialization = new SoapHeaderTransport();

    public TraceeClientHandler() {
        this(Tracee.getBackend());
    }

    TraceeClientHandler(TraceeBackend traceeBackend) {
        super(traceeBackend);
    }

    public final boolean handleFault(SOAPMessageContext context) {
        return true;
    }

    @Override
    protected final void handleIncoming(SOAPMessageContext context) {
        SOAPMessage msg = context.getMessage();
        TraceeBackend backend = this.getTraceeBackend();
        if (msg != null && backend.getConfiguration().shouldProcessContext(TraceeFilterConfiguration.Channel.OutgoingRequest)) {
            try {
                SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
                SOAPHeader header = env.getHeader();
                if (header != null) {
                    Map parsedContext = this.transportSerialization.parseSoapHeader((Element)header);
                    Map filteredContext = this.getTraceeBackend().getConfiguration().filterDeniedParams(parsedContext, TraceeFilterConfiguration.Channel.OutgoingRequest);
                    this.getTraceeBackend().putAll(filteredContext);
                }
            }
            catch (SOAPException e) {
                this.traceeLogger.error((Object)"TraceeClientHandler : Exception occurred during processing of inbound message.", (Throwable)e);
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    protected final void handleOutgoing(SOAPMessageContext context) {
        SOAPMessage msg = context.getMessage();
        TraceeBackend backend = this.getTraceeBackend();
        if (msg != null && backend.getConfiguration().shouldProcessContext(TraceeFilterConfiguration.Channel.IncomingResponse)) {
            try {
                SOAPEnvelope env = msg.getSOAPPart().getEnvelope();
                SOAPHeader header = env.getHeader();
                if (header == null) {
                    header = env.addHeader();
                }
                Map filteredContext = backend.getConfiguration().filterDeniedParams((Map)backend, TraceeFilterConfiguration.Channel.IncomingResponse);
                this.transportSerialization.renderSoapHeader(filteredContext, header);
                msg.saveChanges();
            }
            catch (SOAPException e) {
                this.traceeLogger.error((Object)"TraceeClientHandler : Exception occurred during processing of outbound message.", (Throwable)e);
            }
            catch (JAXBException e) {
                this.traceeLogger.error((Object)"TraceeClientHandler : Exception occurred during processing of outbound message.", (Throwable)e);
            }
            context.setMessage(msg);
        }
    }
}

