/*
 * Decompiled with CFR 0.152.
 */
package io.tracee.jaxws;

import io.tracee.TraceeBackend;
import io.tracee.TraceeConstants;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;
import javax.xml.ws.handler.soap.SOAPMessageContext;

public abstract class AbstractTraceeHandler
implements SOAPHandler<SOAPMessageContext> {
    private final TraceeBackend traceeBackend;
    private static final Set<QName> HANDLED_HEADERS = Collections.unmodifiableSet(new HashSet<QName>(Collections.singleton(TraceeConstants.SOAP_HEADER_QNAME)));

    public AbstractTraceeHandler(TraceeBackend traceeBackend) {
        this.traceeBackend = traceeBackend;
    }

    public final boolean handleMessage(SOAPMessageContext context) {
        if (this.isOutgoing((MessageContext)context)) {
            this.handleOutgoing(context);
        } else {
            this.handleIncoming(context);
        }
        return true;
    }

    private boolean isOutgoing(MessageContext messageContext) {
        Object outboundBoolean = messageContext.get((Object)"javax.xml.ws.handler.message.outbound");
        return outboundBoolean != null && (Boolean)outboundBoolean != false;
    }

    public void close(MessageContext context) {
    }

    protected final TraceeBackend getTraceeBackend() {
        return this.traceeBackend;
    }

    protected abstract void handleIncoming(SOAPMessageContext var1);

    protected abstract void handleOutgoing(SOAPMessageContext var1);

    public Set<QName> getHeaders() {
        return HANDLED_HEADERS;
    }
}

