/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.history.v1.WorkflowExecutionStartedEventAttributes;
import io.temporal.internal.sync.SyncWorkflowContext;
import io.temporal.internal.sync.SyncWorkflowDefinition;
import java.util.Objects;
import java.util.Optional;

class WorkflowExecuteRunnable
implements Runnable {
    private final SyncWorkflowContext context;
    private final SyncWorkflowDefinition workflow;
    private final WorkflowExecutionStartedEventAttributes attributes;
    private Optional<Payloads> output = Optional.empty();
    private boolean done;

    public WorkflowExecuteRunnable(SyncWorkflowContext context, SyncWorkflowDefinition workflow, WorkflowExecutionStartedEventAttributes attributes) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(workflow);
        Objects.requireNonNull(attributes);
        this.context = context;
        this.workflow = workflow;
        this.attributes = attributes;
    }

    @Override
    public void run() {
        try {
            Optional<Payloads> input = this.attributes.hasInput() ? Optional.of(this.attributes.getInput()) : Optional.empty();
            this.output = this.workflow.execute(input);
        }
        finally {
            this.done = true;
        }
    }

    public void cancel(String reason) {
    }

    public boolean isDone() {
        return this.done;
    }

    public Optional<Payloads> getOutput() {
        return this.output;
    }

    public void close() {
    }

    public void processSignal(String signalName, Optional<Payloads> input, long eventId) {
        this.context.signal(signalName, input, eventId);
    }

    public Optional<Payloads> query(String type, Optional<Payloads> args) {
        return this.context.query(type, args);
    }
}

