/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.sync;

import io.temporal.api.common.v1.Payloads;
import io.temporal.api.common.v1.WorkflowExecution;
import io.temporal.api.workflowservice.v1.PollWorkflowTaskQueueResponse;
import io.temporal.common.converter.DataConverter;
import io.temporal.common.interceptors.ActivityInterceptor;
import io.temporal.common.interceptors.WorkflowInterceptor;
import io.temporal.internal.common.InternalUtils;
import io.temporal.internal.common.WorkflowExecutionHistory;
import io.temporal.internal.replay.ReplayWorkflowTaskHandler;
import io.temporal.internal.replay.WorkflowExecutorCache;
import io.temporal.internal.sync.POJOActivityTaskHandler;
import io.temporal.internal.sync.POJOWorkflowImplementationFactory;
import io.temporal.internal.worker.LocalActivityWorker;
import io.temporal.internal.worker.SingleWorkerOptions;
import io.temporal.internal.worker.SuspendableWorker;
import io.temporal.internal.worker.WorkflowWorker;
import io.temporal.serviceclient.WorkflowServiceStubs;
import io.temporal.worker.WorkflowImplementationOptions;
import io.temporal.workflow.Functions;
import java.lang.reflect.Type;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class SyncWorkflowWorker
implements SuspendableWorker,
Functions.Proc1<PollWorkflowTaskQueueResponse> {
    private final WorkflowWorker workflowWorker;
    private final LocalActivityWorker laWorker;
    private final POJOWorkflowImplementationFactory factory;
    private final DataConverter dataConverter;
    private final POJOActivityTaskHandler laTaskHandler;
    private final ScheduledExecutorService heartbeatExecutor = Executors.newScheduledThreadPool(4);

    public SyncWorkflowWorker(WorkflowServiceStubs service, String namespace, String taskQueue, WorkflowInterceptor[] workflowInterceptors, ActivityInterceptor[] activityInterceptors, SingleWorkerOptions workflowOptions, SingleWorkerOptions localActivityOptions, WorkflowExecutorCache cache, String stickyTaskQueueName, Duration stickyWorkflowTaskScheduleToStartTimeout, ThreadPoolExecutor workflowThreadPool) {
        Objects.requireNonNull(workflowThreadPool);
        this.dataConverter = workflowOptions.getDataConverter();
        this.factory = new POJOWorkflowImplementationFactory(workflowOptions.getDataConverter(), workflowThreadPool, workflowInterceptors, cache, workflowOptions.getContextPropagators());
        this.laTaskHandler = new POJOActivityTaskHandler(service, namespace, localActivityOptions.getDataConverter(), this.heartbeatExecutor, activityInterceptors);
        this.laWorker = new LocalActivityWorker(namespace, taskQueue, localActivityOptions, this.laTaskHandler);
        ReplayWorkflowTaskHandler taskHandler = new ReplayWorkflowTaskHandler(namespace, this.factory, cache, workflowOptions, stickyTaskQueueName, stickyWorkflowTaskScheduleToStartTimeout, service, this::isShutdown, this.laWorker.getLocalActivityTaskPoller());
        this.workflowWorker = new WorkflowWorker(service, namespace, taskQueue, workflowOptions, taskHandler, stickyTaskQueueName);
    }

    public void addWorkflowImplementationTypes(WorkflowImplementationOptions options, Class<?>[] workflowImplementationTypes) {
        this.factory.addWorkflowImplementationTypes(options, workflowImplementationTypes);
    }

    public <R> void addWorkflowImplementationFactory(WorkflowImplementationOptions options, Class<R> clazz, Functions.Func<R> factory) {
        this.factory.addWorkflowImplementationFactory(options, clazz, factory);
    }

    public <R> void addWorkflowImplementationFactory(Class<R> clazz, Functions.Func<R> factory) {
        this.factory.addWorkflowImplementationFactory(clazz, factory);
    }

    public void registerLocalActivityImplementations(Object ... activitiesImplementation) {
        this.laTaskHandler.registerLocalActivityImplementations(activitiesImplementation);
    }

    @Override
    public void start() {
        this.workflowWorker.start();
        if (this.workflowWorker.isStarted()) {
            this.laWorker.start();
        }
    }

    @Override
    public boolean isStarted() {
        return this.workflowWorker.isStarted() && (this.laWorker.isStarted() || !this.laWorker.isAnyTypeSupported());
    }

    @Override
    public boolean isShutdown() {
        return this.workflowWorker.isShutdown() && this.laWorker.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.workflowWorker.isTerminated() && this.laWorker.isTerminated();
    }

    @Override
    public void shutdown() {
        this.laWorker.shutdown();
        this.workflowWorker.shutdown();
    }

    @Override
    public void shutdownNow() {
        this.laWorker.shutdownNow();
        this.workflowWorker.shutdownNow();
    }

    @Override
    public void awaitTermination(long timeout, TimeUnit unit) {
        long timeoutMillis = InternalUtils.awaitTermination(this.laWorker, unit.toMillis(timeout));
        InternalUtils.awaitTermination(this.workflowWorker, timeoutMillis);
    }

    @Override
    public void suspendPolling() {
        this.workflowWorker.suspendPolling();
        this.laWorker.suspendPolling();
    }

    @Override
    public void resumePolling() {
        this.workflowWorker.resumePolling();
        this.laWorker.resumePolling();
    }

    @Override
    public boolean isSuspended() {
        return this.workflowWorker.isSuspended() && this.laWorker.isSuspended();
    }

    public <R> R queryWorkflowExecution(WorkflowExecution execution, String queryType, Class<R> resultClass, Type resultType, Object[] args) throws Exception {
        Optional<Payloads> serializedArgs = this.dataConverter.toPayloads(args);
        Optional<Payloads> result = this.workflowWorker.queryWorkflowExecution(execution, queryType, serializedArgs);
        return this.dataConverter.fromPayloads(0, result, resultClass, resultType);
    }

    public <R> R queryWorkflowExecution(WorkflowExecutionHistory history, String queryType, Class<R> resultClass, Type resultType, Object[] args) throws Exception {
        Optional<Payloads> serializedArgs = this.dataConverter.toPayloads(args);
        Optional<Payloads> result = this.workflowWorker.queryWorkflowExecution(history, queryType, serializedArgs);
        return this.dataConverter.fromPayloads(0, result, resultClass, resultType);
    }

    @Override
    public void apply(PollWorkflowTaskQueueResponse pollWorkflowTaskQueueResponse) {
        this.workflowWorker.apply(pollWorkflowTaskQueueResponse);
    }
}

