/*
 * Decompiled with CFR 0.152.
 */
package io.temporal.internal.statemachines;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import io.temporal.api.enums.v1.EventType;
import io.temporal.api.enums.v1.WorkflowTaskFailedCause;
import io.temporal.api.history.v1.WorkflowTaskFailedEventAttributes;
import io.temporal.internal.statemachines.EntityStateMachineInitialCommand;
import io.temporal.internal.statemachines.StateMachineDefinition;
import java.util.Objects;

final class WorkflowTaskStateMachine
extends EntityStateMachineInitialCommand<State, ExplicitEvent, WorkflowTaskStateMachine> {
    private final long workflowTaskStartedEventId;
    private final Listener listener;
    private long currentTimeMillis;
    private long startedEventId;
    public static final StateMachineDefinition<State, ExplicitEvent, WorkflowTaskStateMachine> STATE_MACHINE_DEFINITION = StateMachineDefinition.newInstance("WorkflowTask", State.CREATED, State.COMPLETED, State.TIMED_OUT, State.FAILED).add(State.CREATED, EventType.EVENT_TYPE_WORKFLOW_TASK_SCHEDULED, State.SCHEDULED).add(State.SCHEDULED, EventType.EVENT_TYPE_WORKFLOW_TASK_STARTED, State.STARTED, WorkflowTaskStateMachine::handleStarted).add(State.SCHEDULED, EventType.EVENT_TYPE_WORKFLOW_TASK_TIMED_OUT, State.TIMED_OUT).add(State.STARTED, EventType.EVENT_TYPE_WORKFLOW_TASK_COMPLETED, State.COMPLETED, WorkflowTaskStateMachine::handleCompleted).add(State.STARTED, EventType.EVENT_TYPE_WORKFLOW_TASK_FAILED, State.FAILED, WorkflowTaskStateMachine::handleFailed).add(State.STARTED, EventType.EVENT_TYPE_WORKFLOW_TASK_TIMED_OUT, State.TIMED_OUT);

    public static WorkflowTaskStateMachine newInstance(long workflowTaskStartedEventId, Listener listener) {
        return new WorkflowTaskStateMachine(workflowTaskStartedEventId, listener);
    }

    private WorkflowTaskStateMachine(long workflowTaskStartedEventId, Listener listener) {
        super(STATE_MACHINE_DEFINITION, c -> {
            throw new UnsupportedOperationException("doesn't generate commands");
        }, sm -> {});
        this.workflowTaskStartedEventId = workflowTaskStartedEventId;
        this.listener = Objects.requireNonNull(listener);
    }

    private void handleStarted() {
        this.currentTimeMillis = Timestamps.toMillis((Timestamp)this.currentEvent.getEventTime());
        this.startedEventId = this.currentEvent.getEventId();
        if (this.currentEvent.getEventId() >= this.workflowTaskStartedEventId && !this.hasNextEvent) {
            this.handleCompleted();
        }
    }

    private void handleCompleted() {
        boolean lastTaskInHistory = this.currentEvent.getEventId() >= this.workflowTaskStartedEventId && !this.hasNextEvent;
        this.listener.workflowTaskStarted(this.startedEventId, this.currentTimeMillis, lastTaskInHistory);
    }

    private void handleFailed() {
        WorkflowTaskFailedEventAttributes attr = this.currentEvent.getWorkflowTaskFailedEventAttributes();
        if (attr.getCause() == WorkflowTaskFailedCause.WORKFLOW_TASK_FAILED_CAUSE_RESET_WORKFLOW) {
            this.listener.updateRunId(attr.getNewRunId());
        }
    }

    static enum State {
        CREATED,
        SCHEDULED,
        STARTED,
        COMPLETED,
        TIMED_OUT,
        FAILED;

    }

    static enum ExplicitEvent {

    }

    public static interface Listener {
        public void workflowTaskStarted(long var1, long var3, boolean var5);

        public void updateRunId(String var1);
    }
}

