/*
 * Decompiled with CFR 0.152.
 */
package io.takari.resources.filtering;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheException;
import com.github.mustachejava.ObjectHandler;
import com.github.mustachejava.reflect.MissingWrapper;
import com.github.mustachejava.reflect.ReflectionObjectHandler;
import com.github.mustachejava.util.GuardException;
import com.github.mustachejava.util.Wrapper;
import io.takari.incrementalbuild.BuildContext;
import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.Output;
import io.takari.incrementalbuild.Resource;
import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.resources.filtering.AbstractResourceProcessor;
import io.takari.resources.filtering.MissingPropertyAction;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

class FilterResourcesProcessor
extends AbstractResourceProcessor {
    private static final String M_START = "${";
    private static final String M_END = "}";
    private final BuildContext buildContext;

    public FilterResourcesProcessor(BuildContext buildContext) {
        this.buildContext = buildContext;
    }

    public void process(File sourceDirectory, File targetDirectory, List<String> includes, List<String> excludes, Map<Object, Object> filterProperties, List<File> filters, String encoding, MissingPropertyAction mpa) throws IOException {
        HashMap<Object, Object> effectiveProperties = new HashMap<Object, Object>(filterProperties);
        for (File filter : filters) {
            FilterResourcesProcessor.readProperties(filter).forEach((key, value) -> {
                if (!effectiveProperties.containsKey(key)) {
                    effectiveProperties.put(key, value);
                }
            });
        }
        for (ResourceMetadata metadata : this.buildContext.registerInputs(sourceDirectory, includes, excludes)) {
            this.filterResource((Resource<File>)metadata.process(), sourceDirectory, targetDirectory, effectiveProperties, encoding, mpa);
        }
    }

    private static Map<String, String> readProperties(File file) {
        Properties properties = new Properties();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileInputStream is = new FileInputStream(file);){
                properties.load(is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {}
        return new HashMap<Object, Object>(properties);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void filterResource(Resource<File> input, File sourceDirectory, File targetDirectory, Map<Object, Object> filterProperties, String encoding, MissingPropertyAction mpa) throws IOException {
        File outputFile = FilterResourcesProcessor.relativize(sourceDirectory, targetDirectory, (File)input.getResource());
        Output output = input.associateOutput(outputFile);
        Throwable throwable = null;
        Object var10_11 = null;
        try {
            Reader reader = this.newReader(input, encoding);
            try {
                try (Writer writer = this.newWriter((Output<File>)output, encoding);){
                    this.filter(input, reader, writer, filterProperties, mpa);
                }
                if (reader == null) return;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                if (reader == null) throw throwable;
                reader.close();
                throw throwable;
            }
            reader.close();
            return;
        }
        catch (Throwable throwable3) {
            if (throwable == null) {
                throwable = throwable3;
                throw throwable;
            } else {
                if (throwable == throwable3) throw throwable;
                throwable.addSuppressed(throwable3);
            }
            throw throwable;
        }
    }

    public void filter(Resource resource, Reader reader, Writer writer, Map<Object, Object> properties, MissingPropertyAction mpa) throws IOException {
        NoEncodingMustacheFactory factory = new NoEncodingMustacheFactory();
        factory.setObjectHandler((ObjectHandler)new MapReflectionObjectHandler(resource, mpa));
        Mustache mustache = factory.compile(reader, "maven", M_START, M_END);
        mustache.execute(writer, properties).close();
    }

    private Reader newReader(Resource<File> resource, String encoding) throws IOException {
        if (encoding == null) {
            return new FileReader((File)resource.getResource());
        }
        return new InputStreamReader((InputStream)new FileInputStream((File)resource.getResource()), encoding);
    }

    private Writer newWriter(Output<File> output, String encoding) throws IOException {
        if (encoding == null) {
            return new OutputStreamWriter(output.newOutputStream());
        }
        return new OutputStreamWriter(output.newOutputStream(), encoding);
    }

    private static class MapReflectionObjectHandler
    extends ReflectionObjectHandler {
        private final Resource resource;
        private final MissingPropertyAction missingPropertyAction;

        public MapReflectionObjectHandler(Resource resource, MissingPropertyAction missingPropertyAction) {
            this.resource = resource;
            this.missingPropertyAction = missingPropertyAction;
        }

        public Wrapper find(final String name, List<Object> scopes) {
            Wrapper result = null;
            for (final Object scope : scopes) {
                if (!(scope instanceof Map) || !((Map)scope).containsKey(name)) continue;
                result = new Wrapper(){

                    public Object call(List<Object> scopes) throws GuardException {
                        return ((Map)scope).get(name);
                    }
                };
                break;
            }
            if (result == null) {
                result = super.find(name, scopes);
            }
            if (result instanceof MissingWrapper && this.missingPropertyAction != MissingPropertyAction.empty) {
                if (this.missingPropertyAction == MissingPropertyAction.fail) {
                    String message = "Filtering: property '" + name + "' not found";
                    if (this.resource == null) {
                        throw new MustacheException(message);
                    }
                    this.resource.addMessage(1, 1, message, MessageSeverity.ERROR, null);
                } else if (this.missingPropertyAction == MissingPropertyAction.leave) {
                    result = new Wrapper(){

                        public Object call(List<Object> scopes) throws GuardException {
                            return FilterResourcesProcessor.M_START + name + FilterResourcesProcessor.M_END;
                        }
                    };
                }
            }
            return result;
        }

        public String stringify(Object object) {
            if (object instanceof File) {
                return object.toString().replace('\\', '/');
            }
            return object.toString();
        }
    }

    private static class NoEncodingMustacheFactory
    extends DefaultMustacheFactory {
        private NoEncodingMustacheFactory() {
        }

        public void encode(String value, Writer writer) {
            try {
                writer.write(value);
            }
            catch (IOException e) {
                throw new MustacheException((Throwable)e);
            }
        }
    }
}

