/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin;

import io.takari.maven.plugins.plugin.Sorting;
import io.takari.maven.plugins.plugin.model.MojoDescriptor;
import io.takari.maven.plugins.plugin.model.MojoParameter;
import io.takari.maven.plugins.plugin.model.MojoRequirement;
import io.takari.maven.plugins.plugin.model.PluginDescriptor;
import io.takari.maven.plugins.plugin.model.io.xpp3.PluginDescriptorXpp3Writer;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.MirroredTypeException;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@SupportedSourceVersion(value=SourceVersion.RELEASE_7)
public class MojoDescriptorGleaner
extends AbstractProcessor {
    private final TreeMap<String, MojoDescriptor> descriptors = new TreeMap();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        for (TypeElement element : this.getAnnotatedTypes(roundEnv)) {
            MojoDescriptor descriptor = this.processType(element);
            this.descriptors.put(descriptor.getImplementation(), descriptor);
        }
        if (roundEnv.processingOver() && !this.descriptors.isEmpty()) {
            try {
                this.writeMojosXml(this.descriptors);
            }
            catch (IOException e) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "Could not create aggregate output " + e.getMessage());
            }
        }
        return false;
    }

    private Set<TypeElement> getAnnotatedTypes(RoundEnvironment roundEnv) {
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        roundEnv.getElementsAnnotatedWith(Mojo.class).forEach(type -> {
            boolean bl = types.add((TypeElement)type);
        });
        this.addAnnotatedMembers(types, roundEnv, Parameter.class);
        this.addAnnotatedMembers(types, roundEnv, Component.class);
        return types;
    }

    private void addAnnotatedMembers(Set<TypeElement> types, RoundEnvironment roundEnv, Class<? extends Annotation> annotation) {
        for (Element element : roundEnv.getElementsAnnotatedWith(annotation)) {
            Element type = element.getEnclosingElement();
            if (type.getEnclosingElement().getKind() == ElementKind.PACKAGE) {
                types.add((TypeElement)type);
                continue;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, annotation + " only applicable to top-level class members", element);
        }
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        HashSet<String> types = new HashSet<String>();
        types.add(Mojo.class.getName());
        types.add(Parameter.class.getName());
        types.add(Component.class.getName());
        return types;
    }

    MojoDescriptor processType(TypeElement type) {
        MojoDescriptor descriptor = new MojoDescriptor();
        descriptor.setImplementation(type.getQualifiedName().toString());
        descriptor.setSuperclasses(this.getSuperclasses(type, new ArrayList<String>()));
        Mojo mojo = type.getAnnotation(Mojo.class);
        if (mojo != null) {
            descriptor.setLanguage("java");
            descriptor.setGoal(mojo.name());
            descriptor.setExecutionStrategy(mojo.executionStrategy());
            descriptor.setRequiresProject(mojo.requiresProject());
            descriptor.setRequiresReports(mojo.requiresReports());
            descriptor.setAggregator(mojo.aggregator());
            descriptor.setRequiresDirectInvocation(mojo.requiresDirectInvocation());
            descriptor.setRequiresOnline(mojo.requiresOnline());
            descriptor.setInheritedByDefault(mojo.inheritByDefault());
            if (!MojoDescriptorGleaner.isEmpty(mojo.configurator())) {
                descriptor.setConfigurator(mojo.configurator());
            }
            descriptor.setThreadSafe(mojo.threadSafe());
            descriptor.setPhase(mojo.defaultPhase().id());
            descriptor.setRequiresDependencyResolution(mojo.requiresDependencyResolution().id());
            descriptor.setRequiresDependencyCollection(mojo.requiresDependencyCollection().id());
            descriptor.setInstantiationStrategy(mojo.instantiationStrategy().id());
            if (this.getElementUtils().isDeprecated(type)) {
                descriptor.setDeprecated("No reason given");
            }
            if (this.isTakariBuilderMojo(type)) {
                descriptor.setTakariBuilder(true);
            }
            descriptor.setDescription(this.getDescription(type));
        }
        this.processTypeFields(type, descriptor);
        Sorting.sortParameters(descriptor.getParameters());
        Sorting.sortRequirements(descriptor.getRequirements());
        return descriptor;
    }

    private boolean isTakariBuilderMojo(TypeElement type) {
        TypeElement abstractIncrementalMojoType = this.getElementUtils().getTypeElement("io.takari.builder.internal.maven.AbstractIncrementalMojo");
        return abstractIncrementalMojoType != null && this.getTypeUtils().isSubtype(type.asType(), abstractIncrementalMojoType.asType());
    }

    private void processTypeFields(TypeElement type, MojoDescriptor descriptor) {
        for (Element element : type.getEnclosedElements()) {
            if (!(element instanceof VariableElement)) continue;
            Parameter parameter = element.getAnnotation(Parameter.class);
            Component component = element.getAnnotation(Component.class);
            if (parameter != null) {
                // empty if block
            }
            if (parameter != null) {
                descriptor.addParameter(this.toParameterDescriptor((VariableElement)element, parameter));
                continue;
            }
            if (component == null) continue;
            descriptor.addRequirement(this.toComponentDescriptor((VariableElement)element, component));
        }
    }

    private MojoRequirement toComponentDescriptor(VariableElement field, Component component) {
        MojoRequirement result = new MojoRequirement();
        result.setFieldName(field.getSimpleName().toString());
        result.setRole(this.getComponentRole(field, component));
        result.setRoleHint(component.hint());
        return result;
    }

    private String getComponentRole(VariableElement field, Component component) {
        String role;
        try {
            role = component.role().getName();
        }
        catch (MirroredTypeException e) {
            role = e.getTypeMirror().toString();
        }
        if (!Object.class.getName().equals(role)) {
            return role;
        }
        return this.getTypeString(field.asType());
    }

    private String getTypeString(TypeMirror type) {
        TypeElement typeElement = (TypeElement)this.getTypeUtils().asElement(type);
        if (typeElement != null) {
            return typeElement.getQualifiedName().toString();
        }
        return type.toString();
    }

    private MojoParameter toParameterDescriptor(VariableElement field, Parameter parameter) {
        MojoParameter result = new MojoParameter();
        result.setName(field.getSimpleName().toString());
        if (!MojoDescriptorGleaner.isEmpty(parameter.alias())) {
            result.setAlias(parameter.alias());
        }
        if (!MojoDescriptorGleaner.isEmpty(parameter.defaultValue())) {
            result.setDefaultValue(parameter.defaultValue());
        }
        if (!MojoDescriptorGleaner.isEmpty(parameter.property())) {
            result.setExpression("${" + parameter.property() + "}");
        }
        result.setEditable(!parameter.readonly());
        result.setRequired(parameter.required());
        result.setType(this.getTypeString(field.asType()));
        result.setDescription(this.getDescription(field));
        return result;
    }

    private List<String> getSuperclasses(TypeElement type, List<String> superclasses) {
        TypeElement superclass = type;
        while ((superclass = (TypeElement)this.getTypeUtils().asElement(superclass.getSuperclass())) != null) {
            String qualifiedName = superclass.getQualifiedName().toString();
            if ("java.lang.Object".equals(qualifiedName)) break;
            superclasses.add(qualifiedName);
        }
        return superclasses;
    }

    private Types getTypeUtils() {
        return this.processingEnv.getTypeUtils();
    }

    private String getDescription(Element element) {
        String description = this.getElementUtils().getDocComment(element);
        if (description != null) {
            description = description.trim();
        }
        return !MojoDescriptorGleaner.isEmpty(description) ? description : null;
    }

    private Elements getElementUtils() {
        return this.processingEnv.getElementUtils();
    }

    private static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    void writeMojosXml(TreeMap<String, MojoDescriptor> descriptors) throws IOException {
        PluginDescriptor mojos = new PluginDescriptor();
        for (MojoDescriptor descriptor : descriptors.values()) {
            mojos.addMojo(descriptor);
        }
        FileObject output = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/takari/mojos.xml", new Element[0]);
        Object object = null;
        Object var5_6 = null;
        try (OutputStream out = output.openOutputStream();){
            new PluginDescriptorXpp3Writer().write(out, mojos);
        }
        catch (Throwable throwable) {
            if (object == null) {
                object = throwable;
            } else if (object != throwable) {
                ((Throwable)object).addSuppressed(throwable);
            }
            throw object;
        }
    }
}

