/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.plugin;

import io.takari.maven.plugins.TakariLifecycleMojo;
import io.takari.maven.plugins.plugin.GroupRepositoryMetadata;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadata;
import org.apache.maven.artifact.repository.metadata.ArtifactRepositoryMetadata;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="addPluginArtifactMetadata", defaultPhase=LifecyclePhase.PACKAGE, threadSafe=true)
public class AddPluginArtifactMetadataMojo
extends TakariLifecycleMojo {
    @Parameter
    private String goalPrefix;

    @Override
    protected void executeMojo() throws MojoExecutionException {
        Artifact projectArtifact = this.project.getArtifact();
        Versioning versioning = new Versioning();
        versioning.setLatest(projectArtifact.getVersion());
        versioning.updateTimestamp();
        ArtifactRepositoryMetadata metadata = new ArtifactRepositoryMetadata(projectArtifact, versioning);
        projectArtifact.addMetadata((ArtifactMetadata)metadata);
        GroupRepositoryMetadata groupMetadata = new GroupRepositoryMetadata(this.project.getGroupId());
        groupMetadata.addPluginMapping(this.getGoalPrefix(), this.project.getArtifactId(), this.project.getName());
        projectArtifact.addMetadata((ArtifactMetadata)groupMetadata);
    }

    private String getGoalPrefix() {
        if (this.goalPrefix == null) {
            this.goalPrefix = PluginDescriptor.getGoalPrefixFromArtifactId((String)this.project.getArtifactId());
        }
        return this.goalPrefix;
    }
}

