/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.ProviderNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.jdt.internal.compiler.util.Util;

public class JavaInstallation {
    private static final Predicate<Path> POTENTIAL_ZIP_FILTER = p -> Util.isPotentialZipArchive((String)p.getFileName().toString());
    private final List<Path> classpath;
    private static JavaInstallation instance;

    private JavaInstallation(List<Path> classpath) {
        this.classpath = Collections.unmodifiableList(new ArrayList<Path>(classpath));
    }

    public List<Path> getClasspath() {
        return this.classpath;
    }

    private static List<Path> getJava8() throws IOException {
        ArrayList<Path> classpath = new ArrayList<Path>();
        Path javaHome = Util.getJavaHome().toPath();
        JavaInstallation.scanForArchives(classpath, javaHome.resolve("lib"));
        JavaInstallation.scanForArchives(classpath, javaHome.resolve("lib/endorsed"));
        JavaInstallation.scanForArchives(classpath, javaHome.resolve("lib/ext"));
        return classpath;
    }

    private static void scanForArchives(List<Path> classPathList, Path dir) throws IOException {
        if (Files.isDirectory(dir, new LinkOption[0])) {
            Files.list(dir).filter(POTENTIAL_ZIP_FILTER).forEach(classPathList::add);
        }
    }

    private static List<Path> getJrtFs() throws IOException {
        FileSystem fs = FileSystems.getFileSystem(URI.create("jrt:/"));
        ArrayList<Path> classpath = new ArrayList<Path>();
        for (Path root : fs.getRootDirectories()) {
            Files.list(root.resolve("modules")).forEach(classpath::add);
        }
        return classpath;
    }

    public static synchronized JavaInstallation getDefault() throws IOException {
        if (instance == null) {
            List<Path> cp;
            try {
                cp = JavaInstallation.getJrtFs();
            }
            catch (ProviderNotFoundException providerNotFoundException) {
                cp = JavaInstallation.getJava8();
            }
            instance = new JavaInstallation(cp);
        }
        return instance;
    }
}

