/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt.classpath;

import io.takari.maven.plugins.compile.jdt.classpath.AbstractClasspathDirectory;
import io.takari.maven.plugins.compile.jdt.classpath.ClasspathEntry;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class ClasspathDirectory
extends AbstractClasspathDirectory
implements ClasspathEntry {
    private ClasspathDirectory(Path directory, Set<String> packages, Map<String, Path> files) {
        super(directory, packages, files);
    }

    @Override
    public NameEnvironmentAnswer findType(String packageName, String typeName, AccessRestriction accessRestriction) {
        try {
            Path classFile = this.getFile(packageName, typeName);
            if (classFile != null) {
                Throwable throwable = null;
                Object var6_7 = null;
                try (InputStream is = Files.newInputStream(classFile, new OpenOption[0]);){
                    return new NameEnvironmentAnswer((IBinaryType)ClassFileReader.read((InputStream)is, (String)classFile.getFileName().toString(), (boolean)false), accessRestriction);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
        }
        catch (IOException | ClassFormatException throwable) {}
        return null;
    }

    public String toString() {
        return "Classpath for directory " + this.file;
    }

    public static ClasspathDirectory create(Path directory) {
        HashSet<String> packages = new HashSet<String>();
        HashMap<String, Path> files = new HashMap<String, Path>();
        ClasspathDirectory.scanDirectory(directory, ".class", packages, files);
        return new ClasspathDirectory(directory, packages, files);
    }
}

