/*
 * Decompiled with CFR 0.152.
 */
package io.takari.maven.plugins.compile.jdt;

import io.takari.maven.plugins.compile.jdt.ClassfileDigester;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.scope.MojoExecutionScoped;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@MojoExecutionScoped
public class ClasspathDigester {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final Map<File, Map<String, byte[]>> CACHE = new ConcurrentHashMap<File, Map<String, byte[]>>();
    private final ClassfileDigester digester;

    @Inject
    public ClasspathDigester(MavenProject project, MavenSession session, ClassfileDigester digester) {
        this.digester = digester;
        CACHE.remove(new File(project.getBuild().getOutputDirectory()));
        CACHE.remove(new File(project.getBuild().getTestOutputDirectory()));
    }

    public HashMap<String, byte[]> digestDependencies(List<File> dependencies) throws IOException {
        long started = System.currentTimeMillis();
        HashMap<String, byte[]> digest = new HashMap<String, byte[]>();
        int i = dependencies.size() - 1;
        while (i >= 0) {
            File file = dependencies.get(i);
            if (file.isFile()) {
                digest.putAll(this.digestJar(file));
            } else if (file.isDirectory()) {
                digest.putAll(this.digestDirectory(file));
            }
            --i;
        }
        this.log.debug("Analyzed {} classpath dependencies ({} ms)", (Object)dependencies.size(), (Object)(System.currentTimeMillis() - started));
        return digest;
    }

    private Map<String, byte[]> digestJar(File file) throws IOException {
        Map<String, byte[]> digest = CACHE.get(file);
        if (digest == null) {
            digest = new HashMap<String, byte[]>();
            HashMap<String, byte[]> sourcesDigest = new HashMap<String, byte[]>();
            Throwable throwable = null;
            Object var5_6 = null;
            try (JarFile jar = new JarFile(file);){
                Enumeration<JarEntry> entries = jar.entries();
                while (entries.hasMoreElements()) {
                    String type;
                    JarEntry entry = entries.nextElement();
                    String path = entry.getName();
                    if (path.endsWith(".class")) {
                        type = ClasspathDigester.toJavaType(path, ".class");
                        try {
                            digest.put(type, this.digester.digest((IBinaryType)ClassFileReader.read((ZipFile)jar, (String)path)));
                        }
                        catch (ClassFormatException classFormatException) {}
                        continue;
                    }
                    if (!path.endsWith(".java")) continue;
                    type = ClasspathDigester.toJavaType(path, ".java");
                    Throwable throwable2 = null;
                    Object var12_15 = null;
                    try (InputStream in = jar.getInputStream(entry);){
                        sourcesDigest.put(type, ClasspathDigester.sha1bytes(in));
                    }
                    catch (Throwable throwable3) {
                        if (throwable2 == null) {
                            throwable2 = throwable3;
                        } else if (throwable2 != throwable3) {
                            throwable2.addSuppressed(throwable3);
                        }
                        throw throwable2;
                    }
                }
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                } else if (throwable != throwable4) {
                    throwable.addSuppressed(throwable4);
                }
                throw throwable;
            }
            this.mergeAll(digest, sourcesDigest);
            CACHE.put(file, digest);
        }
        return digest;
    }

    private Map<String, byte[]> digestDirectory(File directory) throws IOException {
        Map<String, byte[]> digest = CACHE.get(directory);
        if (digest == null) {
            digest = new HashMap<String, byte[]>();
            HashMap<String, byte[]> sourcesDigest = new HashMap<String, byte[]>();
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(directory);
            scanner.setIncludes(new String[]{"**/*.class", "**/*.java"});
            scanner.scan();
            String[] stringArray = scanner.getIncludedFiles();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String type;
                String path = stringArray[n2];
                if (path.endsWith(".class")) {
                    type = ClasspathDigester.toJavaType(path, ".class");
                    try {
                        digest.put(type, this.digester.digest((IBinaryType)ClassFileReader.read((File)new File(directory, path))));
                    }
                    catch (ClassFormatException classFormatException) {}
                } else {
                    type = ClasspathDigester.toJavaType(path, ".java");
                    Throwable throwable = null;
                    Object var11_12 = null;
                    try (InputStream inputStream = Files.newInputStream(directory.toPath().resolve(path), new OpenOption[0]);){
                        sourcesDigest.put(type, ClasspathDigester.sha1bytes(inputStream));
                    }
                    catch (Throwable throwable2) {
                        if (throwable == null) {
                            throwable = throwable2;
                        } else if (throwable != throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                        throw throwable;
                    }
                }
                ++n2;
            }
            this.mergeAll(digest, sourcesDigest);
            CACHE.put(directory, digest);
        }
        return digest;
    }

    private void mergeAll(Map<String, byte[]> target, Map<String, byte[]> source) {
        for (Map.Entry<String, byte[]> entry : source.entrySet()) {
            byte[] value = target.get(entry.getKey());
            if (value != null) {
                byte[] temp = new byte[value.length + entry.getValue().length];
                System.arraycopy(value, 0, temp, 0, value.length);
                System.arraycopy(entry.getValue(), 0, temp, value.length, entry.getValue().length);
                value = temp;
            } else {
                value = entry.getValue();
            }
            target.put(entry.getKey(), value);
        }
    }

    public static String toJavaType(String path, String suffix) {
        path = path.substring(0, path.length() - suffix.length());
        return path.replace('/', '.').replace('\\', '.');
    }

    public static void flush() {
        CACHE.clear();
    }

    private static byte[] sha1bytes(InputStream inputStream) throws IOException {
        try {
            int read;
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            byte[] buffer = new byte[8192];
            while ((read = inputStream.read(buffer)) != -1) {
                md.update(buffer, 0, read);
            }
            return md.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("Unsupported JVM: sha1 MessageDigest algorithm unsupported", e);
        }
    }
}

