/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.spi.Message;
import io.takari.incrementalbuild.spi.ResourceHolder;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultBuildContextState
implements Serializable {
    private static final transient Logger log = LoggerFactory.getLogger(DefaultBuildContextState.class);
    private static final long serialVersionUID = 6195150574931820441L;
    final Map<String, Serializable> configuration;
    private final Set<File> outputs;
    private final Map<Object, ResourceHolder<?>> resources;
    private final Map<Object, Collection<File>> resourceOutputs;
    private final Map<File, Collection<Object>> outputInputs;
    private final Map<Object, Map<String, Serializable>> resourceAttributes;
    private final Map<Object, Collection<Message>> resourceMessages;

    private DefaultBuildContextState(Map<String, Serializable> configuration, Map<Object, ResourceHolder<?>> inputs, Set<File> outputs, Map<Object, Collection<File>> resourceOutputs, Map<File, Collection<Object>> outputInputs, Map<Object, Map<String, Serializable>> resourceAttributes, Map<Object, Collection<Message>> resourceMessages) {
        this.configuration = configuration;
        this.resources = inputs;
        this.outputs = outputs;
        this.resourceOutputs = resourceOutputs;
        this.outputInputs = outputInputs;
        this.resourceAttributes = resourceAttributes;
        this.resourceMessages = resourceMessages;
    }

    public static DefaultBuildContextState withConfiguration(Map<String, Serializable> configuration) {
        HashMap<String, Serializable> copy = new HashMap<String, Serializable>(configuration);
        copy.put("incremental", Boolean.TRUE);
        return new DefaultBuildContextState(Collections.unmodifiableMap(copy), new HashMap(), new HashSet<File>(), new HashMap<Object, Collection<File>>(), new HashMap<File, Collection<Object>>(), new HashMap<Object, Map<String, Serializable>>(), new HashMap<Object, Collection<Message>>());
    }

    public static DefaultBuildContextState emptyState() {
        return new DefaultBuildContextState(Collections.emptyMap(), Collections.emptyMap(), Collections.emptySet(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    public String getStats() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.configuration.size()).append(' ');
        sb.append(this.resources.size()).append(' ');
        sb.append(this.outputs.size()).append(' ');
        sb.append(this.resourceOutputs.size()).append(' ');
        sb.append(this.outputInputs.size()).append(' ');
        sb.append(this.resourceAttributes.size()).append(' ');
        sb.append(this.resourceMessages.size()).append(' ');
        return sb.toString();
    }

    public void storeTo(OutputStream os) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(new BufferedOutputStream(os));
        try {
            DefaultBuildContextState.writeMap(oos, this.configuration);
            DefaultBuildContextState.writeCollection(oos, this.outputs);
            DefaultBuildContextState.writeMap(oos, this.resources);
            DefaultBuildContextState.writeMultimap(oos, this.resourceOutputs);
            DefaultBuildContextState.writeDoublemap(oos, this.resourceAttributes);
            DefaultBuildContextState.writeMultimap(oos, this.resourceMessages);
        }
        finally {
            oos.flush();
        }
    }

    private static void writeMap(ObjectOutputStream oos, Map<?, ?> map) throws IOException {
        oos.writeInt(map.size());
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            oos.writeObject(entry.getKey());
            oos.writeObject(entry.getValue());
        }
    }

    private static void writeMultimap(ObjectOutputStream oos, Map<?, ? extends Collection<?>> mmap) throws IOException {
        oos.writeInt(mmap.size());
        for (Map.Entry<?, Collection<?>> entry : mmap.entrySet()) {
            oos.writeObject(entry.getKey());
            DefaultBuildContextState.writeCollection(oos, entry.getValue());
        }
    }

    private static void writeCollection(ObjectOutputStream oos, Collection<?> collection) throws IOException {
        if (collection == null || collection.isEmpty()) {
            oos.writeInt(0);
        } else {
            oos.writeInt(collection.size());
            for (Object element : collection) {
                oos.writeObject(element);
            }
        }
    }

    private static void writeDoublemap(ObjectOutputStream oos, Map<?, ? extends Map<?, ?>> dmap) throws IOException {
        oos.writeInt(dmap.size());
        for (Map.Entry<?, Map<?, ?>> entry : dmap.entrySet()) {
            oos.writeObject(entry.getKey());
            DefaultBuildContextState.writeMap(oos, entry.getValue());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DefaultBuildContextState loadFrom(File stateFile) {
        if (stateFile == null) {
            return DefaultBuildContextState.emptyState();
        }
        try {
            DefaultBuildContextState defaultBuildContextState;
            ObjectInputStream is = new ObjectInputStream(new BufferedInputStream(new FileInputStream(stateFile))){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    try {
                        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                        Class<?> clazz = tccl.loadClass(desc.getName());
                        return clazz;
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        return super.resolveClass(desc);
                    }
                }
            };
            try {
                long start = System.currentTimeMillis();
                Map<String, Serializable> configuration = DefaultBuildContextState.readMap(is);
                Set<File> outputs = DefaultBuildContextState.readSet(is);
                Map<Object, ResourceHolder<?>> resources = DefaultBuildContextState.readMap(is);
                Map<Object, Collection<File>> resourceOutputs = DefaultBuildContextState.readMultimap(is);
                Map<File, Collection<Object>> outputInputs = DefaultBuildContextState.invertMultimap(resourceOutputs);
                Map<Object, Map<String, Serializable>> resourceAttributes = DefaultBuildContextState.readDoublemap(is);
                Map<Object, Collection<Message>> messages = DefaultBuildContextState.readMultimap(is);
                DefaultBuildContextState state = new DefaultBuildContextState(configuration, resources, outputs, resourceOutputs, outputInputs, resourceAttributes, messages);
                log.debug("Loaded incremental build state {} ({} ms)", (Object)stateFile, (Object)(System.currentTimeMillis() - start));
                defaultBuildContextState = state;
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            try {
                is.close();
                return defaultBuildContextState;
            }
            catch (IOException iOException) {}
            return defaultBuildContextState;
        }
        catch (FileNotFoundException fileNotFoundException) {
            return DefaultBuildContextState.emptyState();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            log.debug("Could not load incremental build state {}", (Object)stateFile, (Object)e);
        }
        return DefaultBuildContextState.emptyState();
    }

    private static <K, V> Map<K, V> readMap(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        int size = ois.readInt();
        int i = 0;
        while (i < size) {
            Object key = ois.readObject();
            Object value = ois.readObject();
            map.put(key, value);
            ++i;
        }
        return Collections.unmodifiableMap(map);
    }

    private static <K, V> Map<K, Collection<V>> readMultimap(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        HashMap<Object, Collection<V>> mmap = new HashMap<Object, Collection<V>>();
        int size = ois.readInt();
        int i = 0;
        while (i < size) {
            Object key = ois.readObject();
            Collection<V> value = DefaultBuildContextState.readCollection(ois);
            mmap.put(key, value);
            ++i;
        }
        return Collections.unmodifiableMap(mmap);
    }

    private static <V> Collection<V> readCollection(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        if (size == 0) {
            return null;
        }
        ArrayList<Object> collection = new ArrayList<Object>();
        int i = 0;
        while (i < size) {
            collection.add(ois.readObject());
            ++i;
        }
        return Collections.unmodifiableCollection(collection);
    }

    private static <V> Set<V> readSet(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Collection<V> collection = DefaultBuildContextState.readCollection(ois);
        return collection != null ? Collections.unmodifiableSet(new HashSet<V>(collection)) : Collections.emptySet();
    }

    private static <K, VK, VV> Map<K, Map<VK, VV>> readDoublemap(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        int size = ois.readInt();
        HashMap dmap = new HashMap();
        int i = 0;
        while (i < size) {
            Object key = ois.readObject();
            Map value = DefaultBuildContextState.readMap(ois);
            dmap.put(key, value);
            ++i;
        }
        return Collections.unmodifiableMap(dmap);
    }

    private static <K, V> Map<V, Collection<K>> invertMultimap(Map<K, Collection<V>> mmap) {
        HashMap<V, ArrayList<K>> inverted = new HashMap<V, ArrayList<K>>();
        for (Map.Entry<K, Collection<V>> entry : mmap.entrySet()) {
            for (V value : entry.getValue()) {
                ArrayList<K> keys = (ArrayList<K>)inverted.get(value);
                if (keys == null) {
                    keys = new ArrayList<K>();
                    inverted.put(value, keys);
                }
                keys.add(entry.getKey());
            }
        }
        return Collections.unmodifiableMap(inverted);
    }

    public void putResource(Object resource, ResourceHolder<?> holder) {
        this.resources.put(resource, holder);
    }

    public ResourceHolder<?> getResource(Object resource) {
        return this.resources.get(resource);
    }

    public boolean isResource(Object resource) {
        return this.resources.containsKey(resource);
    }

    public ResourceHolder<?> removeResource(Object resource) {
        return this.resources.remove(resource);
    }

    public Map<Object, ResourceHolder<?>> getResources() {
        return Collections.unmodifiableMap(this.resources);
    }

    public Collection<Object> getOutputInputs(File outputFile) {
        return this.outputInputs.get(outputFile);
    }

    public Collection<File> getOutputs() {
        return Collections.unmodifiableCollection(this.outputs);
    }

    public boolean isOutput(Object outputFile) {
        return this.outputs.contains(outputFile);
    }

    public boolean addOutput(File output) {
        return this.outputs.add(output);
    }

    public boolean removeOutput(File output) {
        return this.outputs.remove(output);
    }

    public boolean putResourceOutput(Object resource, File output) {
        DefaultBuildContextState.put(this.outputInputs, output, resource);
        return DefaultBuildContextState.put(this.resourceOutputs, resource, output);
    }

    public Collection<File> getResourceOutputs(Object resource) {
        return this.resourceOutputs.get(resource);
    }

    public Collection<File> setResourceOutputs(Object resource, Collection<File> outputs) {
        if (outputs == null || outputs.isEmpty()) {
            return this.resourceOutputs.remove(resource);
        }
        return this.resourceOutputs.put(resource, outputs);
    }

    public Collection<File> removeResourceOutputs(Object resource) {
        Collection<File> outputs = this.resourceOutputs.remove(resource);
        this.removeOutputInputs(outputs, resource);
        return outputs;
    }

    private void removeOutputInputs(Collection<File> outputs, Object resource) {
        if (outputs == null) {
            return;
        }
        for (File output : outputs) {
            Collection<Object> inputs = this.outputInputs.get(output);
            if (inputs == null || !inputs.remove(resource)) {
                throw new IllegalStateException();
            }
            if (inputs == null || !inputs.isEmpty()) continue;
            this.outputInputs.remove(output);
        }
    }

    public Map<String, Serializable> removeResourceAttributes(Object resource) {
        return this.resourceAttributes.remove(resource);
    }

    public Map<String, Serializable> getResourceAttributes(Object resource) {
        return this.resourceAttributes.get(resource);
    }

    public Serializable putResourceAttribute(Object resource, String key, Serializable value) {
        Map<String, Serializable> attributes = this.resourceAttributes.get(resource);
        if (attributes == null) {
            attributes = new LinkedHashMap<String, Serializable>();
            this.resourceAttributes.put(resource, attributes);
        }
        return attributes.put(key, value);
    }

    public Serializable getResourceAttribute(Object resource, String key) {
        Map<String, Serializable> attributes = this.resourceAttributes.get(resource);
        return attributes != null ? attributes.get(key) : null;
    }

    public Map<String, Serializable> setResourceAttributes(Object resource, Map<String, Serializable> attributes) {
        if (attributes == null || attributes.isEmpty()) {
            return this.resourceAttributes.remove(resource);
        }
        return this.resourceAttributes.put(resource, attributes);
    }

    public Collection<Message> removeResourceMessages(Object resource) {
        return this.resourceMessages.remove(resource);
    }

    public Collection<Message> getResourceMessages(Object resource) {
        return this.resourceMessages.get(resource);
    }

    public Collection<Message> setResourceMessages(Object resource, Collection<Message> messages) {
        if (messages == null || messages.isEmpty()) {
            return this.resourceMessages.remove(resource);
        }
        return this.resourceMessages.put(resource, messages);
    }

    public boolean addResourceMessage(Object resource, Message message) {
        return DefaultBuildContextState.put(this.resourceMessages, resource, message);
    }

    public Map<Object, Collection<Message>> getResourceMessages() {
        return Collections.unmodifiableMap(this.resourceMessages);
    }

    private static <K, V> boolean put(Map<K, Collection<V>> multimap, K key, V value) {
        Collection<V> values = multimap.get(key);
        if (values == null) {
            values = new LinkedHashSet<V>();
            multimap.put(key, values);
        }
        return values.add(value);
    }
}

