/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.incrementalbuild.BasicBuildContext;
import io.takari.incrementalbuild.ResourceStatus;
import io.takari.incrementalbuild.spi.AbstractBuildContext;
import io.takari.incrementalbuild.spi.BuildContextEnvironment;
import io.takari.incrementalbuild.spi.BuildContextFinalizer;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultResource;
import io.takari.incrementalbuild.spi.DefaultResourceMetadata;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.Map;

public class DefaultBasicBuildContext
extends AbstractBuildContext
implements BasicBuildContext {
    public DefaultBasicBuildContext(BuildContextEnvironment configuration) {
        super(configuration);
    }

    public DefaultBasicBuildContext(Workspace workspace, File stateFile, Map<String, Serializable> configuration, BuildContextFinalizer finalizer) {
        super(workspace, stateFile, configuration, finalizer);
    }

    @Override
    protected void finalizeContext() throws IOException {
        if (this.isProcessed()) {
            for (File oldOutput : this.oldState.getOutputs()) {
                if (this.state.isOutput(oldOutput)) continue;
                this.deleteOutput(oldOutput);
            }
        } else {
            for (Object resource : this.oldState.getResources().keySet()) {
                this.state.putResource(resource, this.oldState.getResource(resource));
                this.state.setResourceMessages(resource, this.oldState.getResourceMessages(resource));
                this.state.setResourceAttributes(resource, this.oldState.getResourceAttributes(resource));
                if (!this.oldState.isOutput(resource)) continue;
                this.state.addOutput((File)resource);
            }
        }
    }

    @Override
    public boolean isProcessingRequired() {
        if (this.isEscalated()) {
            return true;
        }
        for (Object resource : this.state.getResources().keySet()) {
            if (this.state.isOutput(resource) || this.getResourceStatus(resource) == ResourceStatus.UNMODIFIED) continue;
            return true;
        }
        for (Object oldResource : this.oldState.getResources().keySet()) {
            if (this.oldState.isOutput(oldResource) || this.state.isResource(oldResource)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DefaultOutput processOutput(File outputFile) {
        return super.processOutput(outputFile);
    }

    @Override
    public DefaultResourceMetadata<File> registerInput(File inputFile) {
        return super.registerInput(inputFile);
    }

    @Override
    protected <T> DefaultResource<T> processResource(DefaultResourceMetadata<T> metadata) {
        throw new UnsupportedOperationException("BasicBuildContext does not support input processing");
    }

    @Override
    protected void assertAssociation(DefaultResource<?> resource, DefaultOutput output) {
        throw new UnsupportedOperationException();
    }
}

