/*
 * Decompiled with CFR 0.152.
 */
package io.takari.incrementalbuild.spi;

import io.takari.builder.internal.pathmatcher.FileMatcher;
import io.takari.incrementalbuild.MessageSeverity;
import io.takari.incrementalbuild.ResourceMetadata;
import io.takari.incrementalbuild.ResourceStatus;
import io.takari.incrementalbuild.spi.BuildContextEnvironment;
import io.takari.incrementalbuild.spi.BuildContextFinalizer;
import io.takari.incrementalbuild.spi.DefaultBuildContextState;
import io.takari.incrementalbuild.spi.DefaultOutput;
import io.takari.incrementalbuild.spi.DefaultResource;
import io.takari.incrementalbuild.spi.DefaultResourceMetadata;
import io.takari.incrementalbuild.spi.FileState;
import io.takari.incrementalbuild.spi.Message;
import io.takari.incrementalbuild.spi.MessageSinkAdaptor;
import io.takari.incrementalbuild.spi.ResourceHolder;
import io.takari.incrementalbuild.workspace.Workspace;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBuildContext {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected final Workspace workspace;
    private final File stateFile;
    protected final DefaultBuildContextState state;
    protected final DefaultBuildContextState oldState;
    private final boolean escalated;
    private boolean closed;
    private final Set<File> deletedResources = new HashSet<File>();
    private final Set<Object> processedResources = new HashSet<Object>();
    private boolean failOnError = true;

    protected AbstractBuildContext(BuildContextEnvironment env) {
        this(env.getWorkspace(), env.getStateFile(), env.getParameters(), env.getFinalizer());
    }

    protected AbstractBuildContext(Workspace workspace, File stateFile, Map<String, Serializable> configuration, BuildContextFinalizer finalizer) {
        if (workspace == null) {
            throw new NullPointerException();
        }
        if (configuration == null) {
            throw new NullPointerException();
        }
        this.stateFile = stateFile;
        this.state = DefaultBuildContextState.withConfiguration(configuration);
        this.oldState = DefaultBuildContextState.loadFrom(stateFile);
        boolean configurationChanged = this.getConfigurationChanged();
        if (workspace.getMode() == Workspace.Mode.ESCALATED) {
            this.escalated = true;
            this.workspace = workspace;
        } else if (workspace.getMode() == Workspace.Mode.SUPPRESSED) {
            this.escalated = false;
            this.workspace = workspace;
        } else if (configurationChanged || !this.isPresent(this.oldState.getOutputs())) {
            this.escalated = true;
            this.workspace = workspace.escalate();
        } else {
            this.escalated = false;
            this.workspace = workspace;
        }
        if (this.escalated && stateFile != null) {
            if (!stateFile.canRead()) {
                this.log.info("Previous incremental build state does not exist, performing full build");
            } else {
                this.log.info("Incremental build configuration change detected, performing full build");
            }
        } else {
            this.log.info("Performing incremental build");
        }
        if (finalizer != null) {
            finalizer.registerContext(this);
        }
    }

    private boolean isPresent(Collection<File> outputs) {
        for (File output : outputs) {
            if (output.exists() && output.isFile()) continue;
            return false;
        }
        return true;
    }

    private boolean getConfigurationChanged() {
        Map<String, Serializable> configuration = this.state.configuration;
        Map<String, Serializable> oldConfiguration = this.oldState.configuration;
        if (oldConfiguration.isEmpty()) {
            return true;
        }
        TreeSet<String> keys = new TreeSet<String>();
        keys.addAll(configuration.keySet());
        keys.addAll(oldConfiguration.keySet());
        boolean result = false;
        StringBuilder msg = new StringBuilder();
        for (String key : keys) {
            Serializable value = configuration.get(key);
            Serializable oldValue = oldConfiguration.get(key);
            if (Objects.equals(oldValue, value)) continue;
            result = true;
            msg.append("\n   ");
            if (value == null) {
                msg.append("REMOVED");
            } else if (oldValue == null) {
                msg.append("ADDED");
            } else {
                msg.append("CHANGED");
            }
            msg.append(' ').append(key);
        }
        if (result) {
            this.log.debug("Incremental build configuration key changes:{}", (Object)msg.toString());
        }
        return result;
    }

    protected boolean isEscalated() {
        return this.escalated;
    }

    protected Collection<DefaultResourceMetadata<File>> registerInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        basedir = AbstractBuildContext.normalize(basedir);
        final ArrayList<DefaultResourceMetadata<File>> result = new ArrayList<DefaultResourceMetadata<File>>();
        for (final Map.Entry subdir : FileMatcher.createMatchers((Path)basedir.toPath(), includes, excludes).entrySet()) {
            this.workspace.walk(((Path)subdir.getKey()).toFile(), new Workspace.FileVisitor(){

                public void visit(File file, long lastModified, long length, Workspace.ResourceStatus status) {
                    if (((FileMatcher)subdir.getValue()).matches(file)) {
                        switch (status) {
                            case NEW: 
                            case MODIFIED: {
                                result.add(AbstractBuildContext.this.registerNormalizedInput(file, lastModified, length));
                                break;
                            }
                            case REMOVED: {
                                AbstractBuildContext.this.deletedResources.add(file);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
            });
        }
        if (this.workspace.getMode() == Workspace.Mode.DELTA) {
            FileMatcher absoluteMatcher = FileMatcher.createMatcher((Path)basedir.toPath(), includes, excludes);
            for (ResourceHolder<?> holder : this.oldState.getResources().values()) {
                if (!(holder instanceof FileState)) continue;
                FileState fileState = (FileState)holder;
                if (this.state.isResource(fileState.file) || this.deletedResources.contains(fileState.file) || !absoluteMatcher.matches(fileState.file)) continue;
                result.add(this.registerNormalizedInput(fileState.file, fileState.lastModified, fileState.length));
            }
        }
        return result;
    }

    protected Collection<DefaultResource<File>> registerAndProcessInputs(File basedir, Collection<String> includes, Collection<String> excludes) throws IOException {
        basedir = AbstractBuildContext.normalize(basedir);
        final ArrayList<DefaultResource<File>> result = new ArrayList<DefaultResource<File>>();
        for (final Map.Entry subdir : FileMatcher.createMatchers((Path)basedir.toPath(), includes, excludes).entrySet()) {
            this.workspace.walk(((Path)subdir.getKey()).toFile(), new Workspace.FileVisitor(){

                public void visit(File file, long lastModified, long length, Workspace.ResourceStatus status) {
                    if (((FileMatcher)subdir.getValue()).matches(file)) {
                        switch (status) {
                            case NEW: 
                            case MODIFIED: {
                                DefaultResourceMetadata<File> metadata = AbstractBuildContext.this.registerNormalizedInput(file, lastModified, length);
                                if (AbstractBuildContext.this.workspace.getMode() != Workspace.Mode.DELTA && AbstractBuildContext.this.getResourceStatus(file) == ResourceStatus.UNMODIFIED) break;
                                result.add(AbstractBuildContext.this.processResource(metadata));
                                break;
                            }
                            case REMOVED: {
                                AbstractBuildContext.this.deletedResources.add(file);
                                break;
                            }
                            default: {
                                throw new IllegalArgumentException();
                            }
                        }
                    }
                }
            });
        }
        if (this.workspace.getMode() == Workspace.Mode.DELTA) {
            FileMatcher absoluteMatcher = FileMatcher.createMatcher((Path)basedir.toPath(), includes, excludes);
            for (ResourceHolder<?> holder : this.oldState.getResources().values()) {
                if (!(holder instanceof FileState)) continue;
                FileState fileState = (FileState)holder;
                if (this.state.isResource(fileState.file) || this.deletedResources.contains(fileState.file) || !absoluteMatcher.matches(fileState.file)) continue;
                this.registerNormalizedInput(fileState.file, fileState.lastModified, fileState.length);
            }
        }
        return result;
    }

    protected static File normalize(File file) {
        if (file == null) {
            throw new IllegalArgumentException();
        }
        try {
            return file.getCanonicalFile();
        }
        catch (IOException iOException) {
            return file.getAbsoluteFile();
        }
    }

    protected DefaultResourceMetadata<File> registerNormalizedInput(File resourceFile, long lastModified, long length) {
        this.assertOpen();
        if (!this.state.isResource(resourceFile)) {
            this.registerInput(this.newFileState(resourceFile, lastModified, length));
        }
        return new DefaultResourceMetadata<File>(this, this.oldState, resourceFile);
    }

    protected DefaultResourceMetadata<File> registerNormalizedOutput(File outputFile) {
        this.assertOpen();
        if (!this.state.isResource(outputFile)) {
            this.state.putResource(outputFile, null);
            this.state.addOutput(outputFile);
        } else if (!this.state.isOutput(outputFile)) {
            throw new IllegalStateException("Already registered as input " + outputFile);
        }
        return new DefaultResourceMetadata<File>(this, this.oldState, outputFile);
    }

    private FileState newFileState(File file, long lastModified, long length) {
        if (!this.workspace.isPresent(file)) {
            throw new IllegalArgumentException("File does not exist or cannot be read " + file);
        }
        return new FileState(file, lastModified, length);
    }

    protected DefaultResourceMetadata<File> registerInput(File inputFile) {
        inputFile = AbstractBuildContext.normalize(inputFile);
        return this.registerNormalizedInput(inputFile, inputFile.lastModified(), inputFile.length());
    }

    protected <T extends Serializable> T registerInput(ResourceHolder<T> holder) {
        T resource = holder.getResource();
        ResourceHolder<?> other = this.state.getResource(resource);
        if (other == null) {
            if (this.getResourceStatus(holder) == ResourceStatus.REMOVED) {
                throw new IllegalArgumentException("Resource does not exist " + resource);
            }
            this.state.putResource(resource, holder);
        } else {
            if (this.state.isOutput(resource)) {
                throw new IllegalStateException("Already registered as output " + resource);
            }
            if (!holder.equals(other)) {
                throw new IllegalArgumentException("Inconsistent resource state " + resource);
            }
            this.state.putResource(resource, holder);
        }
        return resource;
    }

    protected ResourceStatus getResourceStatus(Object resource) {
        if (this.deletedResources.contains(resource)) {
            return ResourceStatus.REMOVED;
        }
        ResourceHolder<?> oldResourceState = this.oldState.getResource(resource);
        if (oldResourceState == null) {
            return ResourceStatus.NEW;
        }
        ResourceStatus status = this.getResourceStatus(oldResourceState);
        if (status == ResourceStatus.UNMODIFIED && this.escalated) {
            status = ResourceStatus.MODIFIED;
        }
        return status;
    }

    private ResourceStatus getResourceStatus(ResourceHolder<?> holder) {
        if (holder instanceof FileState) {
            FileState fileState = (FileState)holder;
            switch (this.workspace.getResourceStatus(fileState.file, fileState.lastModified, fileState.length)) {
                case NEW: {
                    return ResourceStatus.NEW;
                }
                case MODIFIED: {
                    return ResourceStatus.MODIFIED;
                }
                case REMOVED: {
                    return ResourceStatus.REMOVED;
                }
                case UNMODIFIED: {
                    return ResourceStatus.UNMODIFIED;
                }
            }
            throw new IllegalArgumentException();
        }
        return holder.getStatus();
    }

    protected <T> DefaultResource<T> processResource(DefaultResourceMetadata<T> metadata) {
        T resource = metadata.getResource();
        if (metadata.context != this || !this.state.isResource(resource)) {
            throw new IllegalArgumentException();
        }
        if (metadata instanceof DefaultResource) {
            return (DefaultResource)metadata;
        }
        this.processResource(resource);
        return new DefaultResource<T>(this, this.state, resource);
    }

    protected void processResource(Object resource) {
        this.processedResources.add(resource);
        this.state.removeResourceAttributes(resource);
        this.state.removeResourceMessages(resource);
        this.state.removeResourceOutputs(resource);
    }

    protected void markProcessedResource(Object resource) {
        this.processedResources.add(resource);
    }

    protected <T extends Serializable> Serializable setResourceAttribute(Object resource, String key, T value) {
        this.state.putResourceAttribute(resource, key, value);
        return this.oldState.getResourceAttribute(resource, key);
    }

    protected <T extends Serializable> T getResourceAttribute(DefaultBuildContextState state, Object resource, String key, Class<T> clazz) {
        Map<String, Serializable> attributes = state.getResourceAttributes(resource);
        return (T)(attributes != null ? (Serializable)clazz.cast(attributes.get(key)) : null);
    }

    protected void addMessage(Object resource, int line, int column, String message, MessageSeverity severity, Throwable cause) {
        if (resource == null) {
            throw new IllegalArgumentException(cause);
        }
        if (severity == null) {
            throw new IllegalArgumentException(cause);
        }
        this.state.addResourceMessage(resource, new Message(line, column, message, severity, cause));
        this.log(resource, line, column, message, severity, cause);
    }

    protected DefaultOutput processOutput(File outputFile) {
        outputFile = AbstractBuildContext.normalize(outputFile);
        this.registerNormalizedOutput(outputFile);
        this.processResource(outputFile);
        this.workspace.processOutput(outputFile);
        return this.newOutput(outputFile);
    }

    protected OutputStream newOutputStream(DefaultOutput output) throws IOException {
        return this.workspace.newOutputStream((File)output.getResource());
    }

    protected <T> DefaultOutput associate(DefaultResource<T> resource, DefaultOutput output) {
        if (resource.context != this) {
            throw new IllegalArgumentException();
        }
        if (output.context != this) {
            throw new IllegalArgumentException();
        }
        this.assertAssociation(resource, output);
        this.state.putResourceOutput(resource.getResource(), (File)output.getResource());
        return output;
    }

    protected abstract void assertAssociation(DefaultResource<?> var1, DefaultOutput var2);

    protected <T> DefaultOutput associate(DefaultResource<T> resource, File outputFile) {
        return this.associate(resource, this.processOutput(outputFile));
    }

    protected Collection<? extends ResourceMetadata<File>> getAssociatedOutputs(DefaultBuildContextState state, Object resource) {
        Collection<File> outputFiles = state.getResourceOutputs(resource);
        if (outputFiles == null || outputFiles.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<DefaultResourceMetadata<File>> outputs = new ArrayList<DefaultResourceMetadata<File>>();
        for (File outputFile : outputFiles) {
            outputs.add(new DefaultResourceMetadata<File>(this, state, outputFile));
        }
        return outputs;
    }

    public void commit(MessageSinkAdaptor messager) throws IOException {
        HashMap<Object, Collection<Message>> allMessages;
        ResourceHolder<?> holder22;
        if (this.closed) {
            return;
        }
        this.closed = true;
        HashMap<Object, Collection<Message>> newMessages = new HashMap<Object, Collection<Message>>(this.state.getResourceMessages());
        this.finalizeContext();
        for (Map.Entry<Object, ResourceHolder<?>> entry : this.state.getResources().entrySet()) {
            Object resource = entry.getKey();
            holder22 = entry.getValue();
            if (this.state.isOutput(resource) || holder22.getStatus() == ResourceStatus.UNMODIFIED) continue;
            throw new IllegalStateException("Unexpected input change " + resource);
        }
        for (File outputFile : this.state.getOutputs()) {
            if (this.state.getResource(outputFile) != null) continue;
            this.state.putResource(outputFile, this.newFileState(outputFile, outputFile.lastModified(), outputFile.length()));
        }
        if (this.stateFile != null) {
            long start = System.currentTimeMillis();
            Iterator<Object> iterator = null;
            holder22 = null;
            try (OutputStream os = this.workspace.newOutputStream(this.stateFile);){
                this.state.storeTo(os);
            }
            catch (Throwable holder22) {
                if (iterator == null) {
                    iterator = holder22;
                } else if (iterator != holder22) {
                    ((Throwable)((Object)iterator)).addSuppressed(holder22);
                }
                throw iterator;
            }
            this.log.debug("Stored incremental build state {} ({} ms)", (Object)this.stateFile, (Object)(System.currentTimeMillis() - start));
        }
        if (!(allMessages = new HashMap<Object, Collection<Message>>(this.state.getResourceMessages())).keySet().equals(newMessages.keySet())) {
            this.log.info("Replaying recorded messages...");
            for (Map.Entry entry : allMessages.entrySet()) {
                Object resource = entry.getKey();
                if (newMessages.containsKey(resource)) continue;
                for (Message message : (Collection)entry.getValue()) {
                    this.log(resource, message.line, message.column, message.message, message.severity, message.cause);
                }
            }
        }
        if (messager != null) {
            for (Object resource : this.processedResources) {
                messager.clear(resource);
            }
            for (Object resource : this.oldState.getResources().keySet()) {
                if (this.state.isResource(resource)) continue;
                messager.clear(resource);
            }
            messager.record(allMessages, newMessages);
        }
    }

    protected abstract void finalizeContext() throws IOException;

    protected void log(Object resource, int line, int column, String message, MessageSeverity severity, Throwable cause) {
        switch (severity) {
            case ERROR: {
                this.log.error("{}:[{},{}] {}", new Object[]{resource.toString(), line, column, message, cause});
                break;
            }
            case WARNING: {
                this.log.warn("{}:[{},{}] {}", new Object[]{resource.toString(), line, column, message, cause});
                break;
            }
            default: {
                this.log.info("{}:[{},{}] {}", new Object[]{resource.toString(), line, column, message, cause});
            }
        }
    }

    protected void deleteOutput(File resource) throws IOException {
        if (!this.oldState.isOutput(resource) && !this.state.isOutput(resource)) {
            throw new IllegalArgumentException();
        }
        this.workspace.deleteFile(resource);
        this.deletedResources.add(resource);
        this.processedResources.add(resource);
        this.state.removeResource(resource);
        this.state.removeOutput(resource);
        this.state.removeResourceAttributes(resource);
        this.state.removeResourceMessages(resource);
        this.state.removeResourceOutputs(resource);
    }

    protected void assertOpen() {
        if (this.closed) {
            throw new IllegalStateException();
        }
    }

    protected void markSkipExecution() {
        if (!this.processedResources.isEmpty()) {
            throw new IllegalStateException();
        }
        this.closed = true;
    }

    protected boolean isProcessedResource(Object resource) {
        return this.processedResources.contains(resource);
    }

    protected boolean isProcessed() {
        return !this.processedResources.isEmpty();
    }

    protected boolean isRegisteredResource(Object resource) {
        return this.state.isResource(resource);
    }

    protected boolean isDeletedResource(Object resource) {
        return this.deletedResources.contains(resource);
    }

    protected <T> DefaultResourceMetadata<T> newResourceMetadata(DefaultBuildContextState state, T resource) {
        return new DefaultResourceMetadata<T>(this, state, resource);
    }

    protected <T> DefaultResource<T> newResource(T resource) {
        return new DefaultResource<T>(this, this.state, resource);
    }

    protected DefaultOutput newOutput(File resource) {
        return new DefaultOutput(this, this.state, resource);
    }

    protected void markUptodateOutput(File outputFile) {
        if (!this.oldState.isOutput(outputFile)) {
            throw new IllegalArgumentException();
        }
        this.state.putResource(outputFile, this.oldState.getResource(outputFile));
        this.state.addOutput(outputFile);
    }

    public DefaultBuildContextState getOldState() {
        return this.oldState;
    }

    public DefaultBuildContextState getState() {
        return this.state;
    }

    protected DefaultBuildContextState getState(Object source) {
        return this.isProcessedResource(source) ? this.state : this.oldState;
    }

    protected <V extends Serializable> V getAttribute(Object resource, String key, Class<V> clazz) {
        return this.getResourceAttribute(this.getState(resource), resource, key, clazz);
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean getFailOnError() {
        return this.failOnError;
    }
}

