/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.util.RefUtils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ExternalRefProcessor {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExternalRefProcessor.class);
    private final ResolverCache cache;
    private final Swagger swagger;

    public ExternalRefProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
    }

    public String processRefToExternalDefinition(String $ref, RefFormat refFormat) {
        String possiblyConflictingDefinitionName;
        Model existingModel;
        Model model = this.cache.loadRef($ref, refFormat, Model.class);
        HashMap definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            definitions = new HashMap();
        }
        if ((existingModel = (Model)definitions.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            LOGGER.debug("A model for " + existingModel + " already exists");
        }
        String newRef = possiblyConflictingDefinitionName;
        this.cache.putRenamedRef($ref, newRef);
        Map subProps = model.getProperties();
        if (subProps != null) {
            for (Map.Entry prop : subProps.entrySet()) {
                RefProperty subRef;
                if (!(prop.getValue() instanceof RefProperty) || !RefUtils.isAnExternalRefFormat((subRef = (RefProperty)prop.getValue()).getRefFormat())) continue;
                subRef.set$ref(this.processRefToExternalDefinition(subRef.get$ref(), subRef.getRefFormat()));
            }
        }
        if (existingModel == null) {
            this.swagger.addDefinition(newRef, model);
        }
        return newRef;
    }
}

