/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.util.ClasspathHelper;
import io.swagger.parser.util.RemoteUrl;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.parser.util.SwaggerDeserializer;
import io.swagger.util.Json;
import io.swagger.util.Yaml;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.Validate;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Swagger20Parser
implements SwaggerParserExtension {
    private static final Logger LOGGER = LoggerFactory.getLogger(Swagger20Parser.class);

    @Override
    public SwaggerDeserializationResult readWithInfo(JsonNode node) {
        SwaggerDeserializer ser = new SwaggerDeserializer();
        return ser.deserialize(node);
    }

    @Override
    public SwaggerDeserializationResult readWithInfo(String location, List<AuthorizationValue> auths) {
        try {
            Path path;
            String data = location.toLowerCase().startsWith("http") ? RemoteUrl.urlToString(location, auths) : (Files.exists(path = Paths.get(location, new String[0]), new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)"UTF-8") : ClasspathHelper.loadFileFromClasspath(location));
            ObjectMapper mapper = data.trim().startsWith("{") ? Json.mapper() : Yaml.mapper();
            JsonNode rootNode = mapper.readTree(data);
            return this.readWithInfo(rootNode);
        }
        catch (Exception e) {
            SwaggerDeserializationResult output = new SwaggerDeserializationResult();
            output.message("unable to read location `" + location + "`");
            return output;
        }
    }

    @Override
    public Swagger read(String location, List<AuthorizationValue> auths) throws IOException {
        System.out.println("reading from " + location);
        try {
            String data;
            if (location.toLowerCase().startsWith("http")) {
                data = RemoteUrl.urlToString(location, auths);
            } else {
                Path path;
                if (location.toLowerCase().startsWith("file://")) {
                    location = location.substring("file://".length());
                }
                data = Files.exists(path = Paths.get(location, new String[0]), new LinkOption[0]) ? FileUtils.readFileToString((File)path.toFile(), (String)"UTF-8") : ClasspathHelper.loadFileFromClasspath(location);
            }
            return this.convertToSwagger(data);
        }
        catch (Exception e) {
            if (System.getProperty("debugParser") != null) {
                e.printStackTrace();
            }
            return null;
        }
    }

    private Swagger convertToSwagger(String data) throws IOException {
        if (data != null) {
            ObjectMapper mapper = data.trim().startsWith("{") ? Json.mapper() : Yaml.mapper();
            JsonNode rootNode = mapper.readTree(data);
            if (System.getProperty("debugParser") != null) {
                LOGGER.info("\n\nSwagger Tree: \n" + ReflectionToStringBuilder.toString((Object)rootNode, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE) + "\n\n");
            }
            if (rootNode == null) {
                return null;
            }
            JsonNode swaggerNode = rootNode.get("swagger");
            if (swaggerNode == null) {
                return null;
            }
            SwaggerDeserializationResult result = new SwaggerDeserializer().deserialize(rootNode);
            Swagger convertValue = result.getSwagger();
            if (System.getProperty("debugParser") != null) {
                LOGGER.info("\n\nSwagger Tree convertValue : \n" + ReflectionToStringBuilder.toString((Object)convertValue, (ToStringStyle)ToStringStyle.MULTI_LINE_STYLE) + "\n\n");
            }
            return convertValue;
        }
        return null;
    }

    public Swagger parse(String data) throws IOException {
        Validate.notEmpty((CharSequence)data, (String)"data must not be null!", (Object[])new Object[0]);
        return this.convertToSwagger(data);
    }

    @Override
    public Swagger read(JsonNode node) throws IOException {
        if (node == null) {
            return null;
        }
        return (Swagger)Json.mapper().convertValue((Object)node, Swagger.class);
    }
}

