/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import io.swagger.models.Swagger;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.processors.DefinitionsProcessor;
import io.swagger.parser.processors.PathsProcessor;
import java.util.List;

public class SwaggerResolver {
    private final Swagger swagger;
    private final ResolverCache cache;
    private final PathsProcessor pathProcessor;
    private final DefinitionsProcessor definitionsProcessor;

    public SwaggerResolver(Swagger swagger, List<AuthorizationValue> auths, String parentFileLocation) {
        this.swagger = swagger;
        this.cache = new ResolverCache(swagger, auths, parentFileLocation);
        this.definitionsProcessor = new DefinitionsProcessor(this.cache, swagger);
        this.pathProcessor = new PathsProcessor(this.cache, swagger);
    }

    public SwaggerResolver(Swagger swagger, List<AuthorizationValue> auths) {
        this(swagger, auths, null);
    }

    public Swagger resolve() {
        if (this.swagger == null) {
            return null;
        }
        this.pathProcessor.processPaths();
        this.definitionsProcessor.processDefinitions();
        return this.swagger;
    }
}

