/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.util;

import io.swagger.models.Model;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.util.RemoteUrl;
import java.io.FileInputStream;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public class RefUtils {
    public static String computeDefinitionName(String ref) {
        String plausibleName;
        String definitionPath;
        String[] refParts = ref.split("#/");
        if (refParts.length > 2) {
            throw new RuntimeException("Invalid ref format: " + ref);
        }
        String file = refParts[0];
        String string = definitionPath = refParts.length == 2 ? refParts[1] : null;
        if (definitionPath != null) {
            String[] jsonPathElements = definitionPath.split("/");
            plausibleName = jsonPathElements[jsonPathElements.length - 1];
        } else {
            String[] filePathElements = file.split("/");
            plausibleName = filePathElements[filePathElements.length - 1];
            String[] split = plausibleName.split("\\.");
            plausibleName = split[0];
        }
        return plausibleName;
    }

    public static String deconflictName(String possiblyConflictingDefinitionName, Map<String, Model> definitions) {
        String result = possiblyConflictingDefinitionName;
        int count = 1;
        while (definitions.containsKey(result)) {
            result = possiblyConflictingDefinitionName + count;
            ++count;
        }
        return result;
    }

    public static boolean isAnExternalRefFormat(RefFormat refFormat) {
        return refFormat == RefFormat.URL || refFormat == RefFormat.RELATIVE;
    }

    public static String readExternalRef(String file, RefFormat refFormat, List<AuthorizationValue> auths, Path parentDirectory) {
        String result;
        if (!RefUtils.isAnExternalRefFormat(refFormat)) {
            throw new RuntimeException("Ref is not external");
        }
        try {
            if (refFormat == RefFormat.URL) {
                result = RemoteUrl.urlToString(file, auths);
            } else {
                Path pathToUse = parentDirectory.resolve(file).normalize();
                result = IOUtils.toString((InputStream)new FileInputStream(pathToUse.toString()));
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to load " + refFormat + " ref: " + file, e);
        }
        return result;
    }
}

