/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser.processors;

import io.swagger.models.Model;
import io.swagger.models.Swagger;
import io.swagger.models.refs.RefFormat;
import io.swagger.parser.ResolverCache;
import io.swagger.parser.util.RefUtils;
import java.util.HashMap;

public final class ExternalRefProcessor {
    private final ResolverCache cache;
    private final Swagger swagger;

    public ExternalRefProcessor(ResolverCache cache, Swagger swagger) {
        this.cache = cache;
        this.swagger = swagger;
    }

    public String processRefToExternalDefinition(String $ref, RefFormat refFormat) {
        String newRef;
        String possiblyConflictingDefinitionName;
        Model existingModel;
        Model model = this.cache.loadRef($ref, refFormat, Model.class);
        HashMap<String, Model> definitions = this.swagger.getDefinitions();
        if (definitions == null) {
            definitions = new HashMap<String, Model>();
        }
        if ((existingModel = (Model)definitions.get(possiblyConflictingDefinitionName = RefUtils.computeDefinitionName($ref))) != null) {
            String previouslyRenamedRef = this.cache.getRenamedRef($ref);
            if (previouslyRenamedRef != null) {
                newRef = previouslyRenamedRef;
            } else {
                String deconflictedName = RefUtils.deconflictName(possiblyConflictingDefinitionName, definitions);
                this.cache.putRenamedRef($ref, deconflictedName);
                newRef = deconflictedName;
                this.swagger.addDefinition(deconflictedName, model);
            }
        } else {
            newRef = possiblyConflictingDefinitionName;
            this.cache.putRenamedRef($ref, newRef);
            this.swagger.addDefinition(newRef, model);
        }
        return newRef;
    }
}

