/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.auth.AuthorizationValue;
import com.wordnik.swagger.util.Json;
import com.wordnik.swagger.util.Yaml;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.util.RemoteUrl;
import java.io.File;
import java.io.IOException;
import java.util.List;

public class Swagger20Parser
implements SwaggerParserExtension {
    @Override
    public Swagger read(String location, List<AuthorizationValue> auths) throws IOException {
        System.out.println("reading from " + location);
        try {
            ObjectMapper mapper = location.toLowerCase().endsWith(".yaml") ? Yaml.mapper() : Json.mapper();
            JsonNode rootNode = null;
            if (location.toLowerCase().startsWith("http")) {
                String json = RemoteUrl.urlToString(location, auths);
                rootNode = mapper.readTree(json);
            } else {
                rootNode = mapper.readTree(new File(location));
            }
            JsonNode swaggerNode = rootNode.get("swagger");
            if (swaggerNode == null) {
                return null;
            }
            return (Swagger)mapper.convertValue((Object)rootNode, Swagger.class);
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            if (System.getProperty("debugParser") != null) {
                e.printStackTrace();
            }
            return null;
        }
    }

    @Override
    public Swagger read(JsonNode node) throws IOException {
        if (node == null) {
            return null;
        }
        return (Swagger)Json.mapper().convertValue((Object)node, Swagger.class);
    }
}

