/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.transform.migrate;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.fge.jackson.JacksonUtils;
import com.github.fge.jackson.jsonpointer.JsonPointer;
import com.github.fge.jsonpatch.JsonPatch;
import io.swagger.transform.migrate.SwaggerMigrator;
import io.swagger.transform.util.SwaggerMigrationException;
import io.swagger.transform.util.SwaggerMigrators;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nonnull;

public final class V11AllowableValuesMigrator
implements SwaggerMigrator {
    private static final ObjectMapper MAPPER = JacksonUtils.newMapper();
    private static final JsonPatch PATCH;

    @Override
    @Nonnull
    public JsonNode migrate(@Nonnull JsonNode input) throws SwaggerMigrationException {
        Objects.requireNonNull(input);
        if (!input.has("allowableValues")) {
            return input;
        }
        String valueType = ((JsonNode)JsonPointer.of((Object)"allowableValues", (Object[])new Object[]{"valueType"}).get((TreeNode)input)).textValue();
        if (!"LIST".equals(valueType)) {
            throw new SwaggerMigrationException();
        }
        return SwaggerMigrators.fromPatch(PATCH).migrate(input);
    }

    static {
        String op = "[{\"op\":\"move\",\"from\":\"/allowableValues/values\",\"path\":\"/enum\"},{\"op\": \"remove\", \"path\": \"/allowableValues\"}]";
        try {
            PATCH = (JsonPatch)MAPPER.readValue("[{\"op\":\"move\",\"from\":\"/allowableValues/values\",\"path\":\"/enum\"},{\"op\": \"remove\", \"path\": \"/allowableValues\"}]", JsonPatch.class);
        }
        catch (IOException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

