/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.parser;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.wordnik.swagger.models.ArrayModel;
import com.wordnik.swagger.models.Contact;
import com.wordnik.swagger.models.Info;
import com.wordnik.swagger.models.License;
import com.wordnik.swagger.models.ModelImpl;
import com.wordnik.swagger.models.Path;
import com.wordnik.swagger.models.RefModel;
import com.wordnik.swagger.models.Response;
import com.wordnik.swagger.models.Scheme;
import com.wordnik.swagger.models.Swagger;
import com.wordnik.swagger.models.auth.ApiKeyAuthDefinition;
import com.wordnik.swagger.models.auth.AuthorizationValue;
import com.wordnik.swagger.models.auth.In;
import com.wordnik.swagger.models.auth.OAuth2Definition;
import com.wordnik.swagger.models.auth.SecuritySchemeDefinition;
import com.wordnik.swagger.models.parameters.BodyParameter;
import com.wordnik.swagger.models.parameters.FormParameter;
import com.wordnik.swagger.models.parameters.HeaderParameter;
import com.wordnik.swagger.models.parameters.PathParameter;
import com.wordnik.swagger.models.parameters.QueryParameter;
import com.wordnik.swagger.models.parameters.SerializableParameter;
import com.wordnik.swagger.models.properties.ArrayProperty;
import com.wordnik.swagger.models.properties.Property;
import com.wordnik.swagger.models.properties.PropertyBuilder;
import com.wordnik.swagger.models.properties.RefProperty;
import com.wordnik.swagger.util.Json;
import io.swagger.models.AuthorizationScope;
import io.swagger.models.ParamType;
import io.swagger.models.PassAs;
import io.swagger.models.apideclaration.Api;
import io.swagger.models.apideclaration.ApiDeclaration;
import io.swagger.models.apideclaration.ExtendedTypedObject;
import io.swagger.models.apideclaration.Items;
import io.swagger.models.apideclaration.Model;
import io.swagger.models.apideclaration.ModelProperty;
import io.swagger.models.apideclaration.Operation;
import io.swagger.models.apideclaration.Parameter;
import io.swagger.models.apideclaration.ResponseMessage;
import io.swagger.models.resourcelisting.ApiInfo;
import io.swagger.models.resourcelisting.ApiKeyAuthorization;
import io.swagger.models.resourcelisting.ApiListingReference;
import io.swagger.models.resourcelisting.Authorization;
import io.swagger.models.resourcelisting.AuthorizationCodeGrant;
import io.swagger.models.resourcelisting.ImplicitGrant;
import io.swagger.models.resourcelisting.OAuth2Authorization;
import io.swagger.models.resourcelisting.ResourceListing;
import io.swagger.parser.SwaggerLegacyParser;
import io.swagger.parser.SwaggerParserExtension;
import io.swagger.parser.util.RemoteUrl;
import io.swagger.report.MessageBuilder;
import io.swagger.transform.migrate.ApiDeclarationMigrator;
import io.swagger.transform.migrate.ResourceListingMigrator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwaggerCompatConverter
implements SwaggerParserExtension {
    public Swagger read(JsonNode node) throws IOException {
        return null;
    }

    public Swagger read(String input) throws IOException {
        return this.read(input, null);
    }

    public Swagger read(String input, List<AuthorizationValue> auths) throws IOException {
        Swagger output = null;
        MessageBuilder migrationMessages = new MessageBuilder();
        SwaggerLegacyParser swaggerParser = new SwaggerLegacyParser();
        ResourceListing resourceListing = null;
        resourceListing = this.readResourceListing(input, migrationMessages, auths);
        ArrayList<ApiDeclaration> apis = new ArrayList<ApiDeclaration>();
        if (resourceListing != null) {
            List<ApiListingReference> refs = resourceListing.getApis();
            boolean readAsSingleFile = false;
            if (refs != null) {
                for (ApiListingReference ref : refs) {
                    ApiDeclaration apiDeclaration = null;
                    ObjectNode node = ref.getExtraFields();
                    JsonNode operations = node.get("operations");
                    if (operations != null) {
                        if (!readAsSingleFile) {
                            apiDeclaration = this.readDeclaration(input, migrationMessages, auths);
                            readAsSingleFile = true;
                        }
                    } else {
                        String location = null;
                        if (input.startsWith("http")) {
                            String pathLocation = ref.getPath();
                            location = pathLocation.startsWith("http") ? pathLocation : (pathLocation.startsWith("/") ? input + pathLocation : input + "/" + pathLocation);
                        } else {
                            File fileLocation = new File(input);
                            location = ref.getPath().startsWith("/") ? fileLocation.getParent() + ref.getPath() : fileLocation.getParent() + File.separator + ref.getPath();
                        }
                        if (location.indexOf(".{format}") != -1) {
                            location = location.replaceAll("\\.\\{format\\}", ".json");
                        }
                        apiDeclaration = this.readDeclaration(location, migrationMessages, auths);
                    }
                    if (apiDeclaration == null) continue;
                    apis.add(apiDeclaration);
                }
            }
            output = this.convert(resourceListing, apis);
        }
        return output;
    }

    public ResourceListing readResourceListing(String input, MessageBuilder messages, List<AuthorizationValue> auths) {
        ResourceListing output = null;
        JsonNode jsonNode = null;
        try {
            if (input.startsWith("http")) {
                String json = RemoteUrl.urlToString((String)input, auths);
                jsonNode = Json.mapper().readTree(json);
            } else {
                jsonNode = Json.mapper().readTree(new File(input));
            }
            ResourceListingMigrator migrator = new ResourceListingMigrator();
            JsonNode transformed = migrator.migrate(messages, jsonNode);
            output = (ResourceListing)Json.mapper().convertValue((Object)transformed, ResourceListing.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public com.wordnik.swagger.models.Model convertModel(Model model) {
        ModelImpl output = new ModelImpl();
        output.setName(model.getId());
        output.setDescription(model.getDescription());
        output.setDiscriminator(model.getDiscriminator());
        if (model.getRequired() != null) {
            output.setRequired(model.getRequired());
        }
        for (String key : model.getProperties().keySet()) {
            Property prop = this.convertProperty(model.getProperties().get(key));
            if (prop == null) continue;
            output.addProperty(key, prop);
        }
        return output;
    }

    public Property convertProperty(ModelProperty property) {
        Property output = null;
        output = this.propertyFromTypedObject(property);
        output.setDescription(property.getDescription());
        return output;
    }

    public com.wordnik.swagger.models.parameters.Parameter convertParameter(Parameter param) {
        String format;
        PathParameter output = null;
        if (ParamType.PATH.equals((Object)param.getParamType())) {
            output = new PathParameter();
        } else if (ParamType.QUERY.equals((Object)param.getParamType())) {
            output = new QueryParameter();
        } else if (ParamType.HEADER.equals((Object)param.getParamType())) {
            output = new HeaderParameter();
        } else if (ParamType.BODY.equals((Object)param.getParamType())) {
            output = new BodyParameter();
        } else if (ParamType.FORM.equals((Object)param.getParamType())) {
            output = new FormParameter();
        }
        output.setName(param.getName());
        output.setDescription(param.getDescription());
        if (param.getRequired() != null) {
            output.setRequired(param.getRequired().booleanValue());
        }
        Object property = null;
        String type = param.getType() == null ? null : param.getType().toString();
        String string = format = param.getFormat() == null ? null : param.getFormat().toString();
        if (output instanceof BodyParameter) {
            BodyParameter bp = (BodyParameter)output;
            bp.setSchema(this.modelFromExtendedTypedObject(param));
        } else if (output instanceof SerializableParameter) {
            SerializableParameter sp = (SerializableParameter)output;
            Property p = null;
            if (param.getAllowMultiple() != null && param.getAllowMultiple().booleanValue()) {
                ArrayProperty arrayProperty = new ArrayProperty();
                Property innerType = PropertyBuilder.build((String)type, (String)format, null);
                arrayProperty.setItems(innerType);
                p = arrayProperty;
            } else {
                p = this.propertyFromTypedObject(param);
            }
            if (p instanceof ArrayProperty) {
                ArrayProperty ap = (ArrayProperty)p;
                sp.setType("array");
                sp.setCollectionFormat("csv");
                sp.setItems(ap.getItems());
            } else {
                sp.setType(p.getType());
                sp.setFormat(p.getFormat());
            }
        }
        if (output instanceof PathParameter) {
            output.setRequired(true);
        }
        return output;
    }

    public com.wordnik.swagger.models.Model modelFromExtendedTypedObject(ExtendedTypedObject obj) {
        String type = obj.getType() == null ? null : obj.getType().toString();
        String format = obj.getFormat() == null ? null : obj.getFormat().toString();
        RefModel output = null;
        if (obj.getRef() != null) {
            output = new RefModel().asDefault(obj.getRef());
        } else if ("array".equals(type)) {
            ArrayModel am = new ArrayModel();
            Items items = obj.getItems();
            type = items.getType() == null ? null : items.getType().toString();
            Property innerType = PropertyBuilder.build((String)type, (String)(format = items.getFormat() == null ? null : items.getFormat().toString()), null);
            if (innerType != null) {
                am.setItems(innerType);
            } else if (items.getRef() != null) {
                am.setItems((Property)new RefProperty(items.getRef()));
            } else {
                am.setItems((Property)new RefProperty(type));
            }
            output = am;
        } else {
            Property input = PropertyBuilder.build((String)type, (String)format, null);
            if (input == null && !"void".equals(type)) {
                output = new RefModel().asDefault(type);
            }
        }
        return output;
    }

    public Property propertyFromTypedObject(ExtendedTypedObject obj) {
        String type = obj.getType() == null ? null : obj.getType().toString();
        String format = obj.getFormat() == null ? null : obj.getFormat().toString();
        Object output = null;
        if ("array".equals(type)) {
            Property innerType;
            ArrayProperty am = new ArrayProperty();
            Items items = obj.getItems();
            if (items == null) {
                System.out.println("Error! Missing array type for property!  Assuming `object` -- please fix your spec");
                Json.prettyPrint((Object)obj);
                items = new Items();
                items.setType("object");
            }
            if ((innerType = PropertyBuilder.build((String)(type = items.getType() == null ? null : items.getType().toString()), (String)(format = items.getFormat() == null ? null : items.getFormat().toString()), null)) != null) {
                am.setItems(innerType);
            } else if (items.getRef() != null) {
                am.setItems((Property)new RefProperty(items.getRef()));
            } else {
                am.setItems((Property)new RefProperty(type));
            }
            output = am;
        } else {
            Property i;
            HashMap<String, Object> args = new HashMap<String, Object>();
            if (obj.getEnumValues() != null && obj.getEnumValues().size() > 0) {
                args.put("enum", obj.getEnumValues());
            }
            if (obj.getMinimum() != null) {
                args.put("minimum", Double.parseDouble(obj.getMinimum()));
            }
            if (obj.getMaximum() != null) {
                args.put("maximum", Double.parseDouble(obj.getMaximum()));
            }
            output = (i = PropertyBuilder.build((String)type, (String)format, args)) != null ? i : (obj.getRef() != null ? new RefProperty(obj.getRef()) : new RefProperty(type));
        }
        return output;
    }

    public com.wordnik.swagger.models.Operation convertOperation(String tag, Operation operation) {
        com.wordnik.swagger.models.Operation output = new com.wordnik.swagger.models.Operation().summary(operation.getSummary()).description(operation.getNotes()).operationId(operation.getNickname());
        if (tag != null) {
            output.tag(tag);
        }
        for (Parameter parameter : operation.getParameters()) {
            output.parameter(this.convertParameter(parameter));
        }
        if (operation.getConsumes() != null) {
            for (String consumes : operation.getConsumes()) {
                output.consumes(consumes);
            }
        }
        if (operation.getProduces() != null) {
            for (String produces : operation.getProduces()) {
                output.produces(produces);
            }
        }
        for (ResponseMessage message : operation.getResponseMessages()) {
            Response response = new Response().description(message.getMessage());
            Object responseModel = null;
            if (message.getResponseModel() != null) {
                response.schema((Property)new RefProperty(message.getResponseModel()));
            }
            output.response(message.getCode().intValue(), response);
        }
        Property responseProperty = this.propertyFromTypedObject(operation);
        if (responseProperty != null) {
            Response response = new Response().description("success").schema(responseProperty);
            if (output.getResponses() == null) {
                output.defaultResponse(response);
            } else {
                output.response(200, response);
            }
        }
        Map<String, List<AuthorizationScope>> auths = operation.getAuthorizations();
        for (String securityName : auths.keySet()) {
            List<AuthorizationScope> scopes = auths.get(securityName);
            ArrayList<String> updatedScopes = new ArrayList<String>();
            for (AuthorizationScope s : scopes) {
                updatedScopes.add(s.getScope());
            }
            output.addSecurity(securityName, updatedScopes);
        }
        return output;
    }

    public ApiDeclaration readDeclaration(String input, MessageBuilder messages, List<AuthorizationValue> auths) {
        ApiDeclaration output = null;
        try {
            JsonNode jsonNode = null;
            if (input.startsWith("http")) {
                String json = RemoteUrl.urlToString((String)input, auths);
                jsonNode = Json.mapper().readTree(json);
            } else {
                jsonNode = Json.mapper().readTree(new File(input));
            }
            if (jsonNode.isObject()) {
                ((ObjectNode)jsonNode).remove("authorizations");
            }
            ApiDeclarationMigrator migrator = new ApiDeclarationMigrator();
            JsonNode transformed = migrator.migrate(messages, jsonNode);
            output = (ApiDeclaration)Json.mapper().convertValue((Object)transformed, ApiDeclaration.class);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return output;
    }

    public Swagger convert(ResourceListing resourceListing, List<ApiDeclaration> apiDeclarations) {
        Info info = new Info();
        if (resourceListing.getInfo() != null) {
            ApiInfo apiInfo = resourceListing.getInfo();
            Contact contact = null;
            if (apiInfo.getContact() != null) {
                contact = new Contact().url(apiInfo.getContact());
            }
            License license = null;
            if (apiInfo.getLicense() != null) {
                license = new License().name(apiInfo.getLicense()).url(apiInfo.getLicenseUrl());
            }
            info = new Info().description(apiInfo.getDescription()).version(resourceListing.getApiVersion()).title(apiInfo.getTitle()).termsOfService(apiInfo.getTermsOfServiceUrl()).contact(contact).license(license);
        } else if (resourceListing.getApiVersion() != null) {
            info = new Info().version(resourceListing.getApiVersion());
        }
        HashMap<String, Path> paths = new HashMap<String, Path>();
        HashMap<String, com.wordnik.swagger.models.Model> definitions = new HashMap<String, com.wordnik.swagger.models.Model>();
        String basePath = null;
        for (ApiDeclaration apiDeclaration : apiDeclarations) {
            String tag;
            if (apiDeclaration.getApiListingRef() != null) {
                String refPath = apiDeclaration.getApiListingRef().getPath();
                tag = refPath.substring(refPath.lastIndexOf("/") + 1);
            } else {
                tag = apiDeclaration.getResourcePath();
            }
            if (tag != null) {
                tag = tag.replaceAll("/", "");
            }
            if (basePath != null) {
                if (!basePath.equals(apiDeclaration.getBasePath()) && apiDeclaration.getBasePath() != null) {
                    System.out.println("warning!  multiple basePath values not supported!");
                }
            } else {
                basePath = apiDeclaration.getBasePath();
            }
            List<Api> apis = apiDeclaration.getApis();
            for (Api api : apis) {
                String apiPath = api.getPath();
                String description = api.getDescription();
                List<Operation> ops = api.getOperations();
                Path path = (Path)paths.get(apiPath);
                if (path == null) {
                    path = new Path();
                    paths.put(apiPath, path);
                }
                for (Operation op : ops) {
                    com.wordnik.swagger.models.Operation operation = this.convertOperation(tag, op);
                    path.set(op.getMethod().toString().toLowerCase(), operation);
                }
            }
            Map<String, Model> apiModels = apiDeclaration.getModels();
            for (String key : apiModels.keySet()) {
                com.wordnik.swagger.models.Model model = this.convertModel(apiModels.get(key));
                definitions.put(key, model);
            }
        }
        String host = null;
        String scheme = "http";
        if (basePath != null) {
            String[] parts = basePath.split("://");
            if (parts.length == 2) {
                scheme = parts[0];
                int pos = parts[1].indexOf("/");
                if (pos != -1) {
                    host = parts[1].substring(0, pos);
                    basePath = parts[1].substring(pos);
                } else {
                    host = parts[1];
                    basePath = "/";
                }
            }
            if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
        }
        Swagger swagger = new Swagger().host(host).scheme(Scheme.forValue((String)scheme)).basePath(basePath).info(info).paths(paths).basePath(basePath);
        swagger.setDefinitions(definitions);
        Map<String, Authorization> authorizations = resourceListing.getAuthorizations();
        if (authorizations != null) {
            for (String authNickname : authorizations.keySet()) {
                Authorization o2;
                Authorization auth = authorizations.get(authNickname);
                if (auth instanceof OAuth2Authorization) {
                    OAuth2Definition oauth2;
                    o2 = (OAuth2Authorization)auth;
                    List<AuthorizationScope> scopes = ((OAuth2Authorization)o2).getScopes();
                    if (((OAuth2Authorization)o2).getGrantTypes().getImplicit() != null) {
                        ImplicitGrant ig = ((OAuth2Authorization)o2).getGrantTypes().getImplicit();
                        oauth2 = new OAuth2Definition().implicit(ig.getLoginEndpoint().getUrl());
                        if (swagger.getSecurityDefinitions() != null && swagger.getSecurityDefinitions().keySet().contains(authNickname)) {
                            System.err.println("Warning!  Authorization nickname already in use!");
                        } else {
                            swagger.securityDefinition(authNickname, (SecuritySchemeDefinition)oauth2);
                        }
                        for (AuthorizationScope scope : scopes) {
                            oauth2.scope(scope.getScope(), scope.getDescription());
                        }
                        continue;
                    }
                    if (((OAuth2Authorization)o2).getGrantTypes().getAuthorization_code() == null) continue;
                    AuthorizationCodeGrant ac = ((OAuth2Authorization)o2).getGrantTypes().getAuthorization_code();
                    oauth2 = new OAuth2Definition().accessCode(ac.getTokenRequestEndpoint().getUrl(), ac.getTokenEndpoint().getUrl());
                    if (swagger.getSecurityDefinitions() != null && swagger.getSecurityDefinitions().keySet().contains(authNickname)) {
                        System.err.println("Warning!  Authorization nickname already in use!");
                    } else {
                        swagger.securityDefinition(authNickname, (SecuritySchemeDefinition)oauth2);
                    }
                    for (AuthorizationScope scope : scopes) {
                        oauth2.scope(scope.getScope(), scope.getDescription());
                    }
                    continue;
                }
                if (!(auth instanceof ApiKeyAuthorization)) continue;
                o2 = (ApiKeyAuthorization)auth;
                ApiKeyAuthDefinition def = new ApiKeyAuthDefinition();
                PassAs passAs = ((ApiKeyAuthorization)o2).getPassAs();
                if (PassAs.HEADER.equals((Object)passAs)) {
                    def.in(In.HEADER);
                } else {
                    def.in(In.QUERY);
                }
                def.setName(((ApiKeyAuthorization)o2).getKeyname());
                swagger.securityDefinition(authNickname, (SecuritySchemeDefinition)def);
            }
        }
        return swagger;
    }
}

