/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.util;

import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.callbacks.Callback;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.parser.util.SchemaTypeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResolverFully {
    private static final Logger LOGGER = LoggerFactory.getLogger(ResolverFully.class);
    private boolean aggregateCombinators;
    private Map<String, Schema> schemas;
    private Map<String, Schema> resolvedModels = new HashMap<String, Schema>();
    private Map<String, Example> examples;

    public ResolverFully() {
        this(true);
    }

    public ResolverFully(boolean aggregateCombinators) {
        this.aggregateCombinators = aggregateCombinators;
    }

    public void resolveFully(OpenAPI openAPI) {
        if (openAPI.getComponents() != null && openAPI.getComponents().getSchemas() != null) {
            this.schemas = openAPI.getComponents().getSchemas();
            if (this.schemas == null) {
                this.schemas = new HashMap<String, Schema>();
            }
        }
        if (openAPI.getComponents() != null && openAPI.getComponents().getExamples() != null) {
            this.examples = openAPI.getComponents().getExamples();
            if (this.examples == null) {
                this.examples = new HashMap<String, Example>();
            }
        }
        if (openAPI.getPaths() != null) {
            for (String pathname : openAPI.getPaths().keySet()) {
                PathItem pathItem = (PathItem)openAPI.getPaths().get((Object)pathname);
                this.resolvePath(pathItem);
            }
        }
    }

    public void resolvePath(PathItem pathItem) {
        for (Operation op : pathItem.readOperations()) {
            Object parameter2;
            if (op.getParameters() != null) {
                for (Object parameter2 : op.getParameters()) {
                    Schema resolved;
                    if (parameter2.getSchema() != null && (resolved = this.resolveSchema(parameter2.getSchema())) != null) {
                        parameter2.setSchema(resolved);
                    }
                    if (parameter2.getContent() == null) continue;
                    Content content = parameter2.getContent();
                    for (String key : content.keySet()) {
                        Schema resolvedSchema;
                        if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolvedSchema = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                        ((MediaType)content.get(key)).setSchema(resolvedSchema);
                    }
                }
            }
            if (op.getCallbacks() != null) {
                Map callbacks = op.getCallbacks();
                parameter2 = callbacks.keySet().iterator();
                while (parameter2.hasNext()) {
                    String name = (String)parameter2.next();
                    Callback callback = (Callback)callbacks.get(name);
                    if (callback == null) continue;
                    for (String callbackName : callback.keySet()) {
                        PathItem path = (PathItem)callback.get((Object)callbackName);
                        if (path == null) continue;
                        this.resolvePath(path);
                    }
                }
            }
            if (op.getRequestBody() != null && op.getRequestBody().getContent() != null) {
                Content content = op.getRequestBody().getContent();
                parameter2 = content.keySet().iterator();
                while (parameter2.hasNext()) {
                    Schema resolved;
                    String key = (String)parameter2.next();
                    if (content.get(key) == null || ((MediaType)content.get(key)).getSchema() == null || (resolved = this.resolveSchema(((MediaType)content.get(key)).getSchema())) == null) continue;
                    ((MediaType)content.get(key)).setSchema(resolved);
                }
            }
            if (op.getResponses() == null) continue;
            for (String code : op.getResponses().keySet()) {
                ApiResponse response = (ApiResponse)op.getResponses().get((Object)code);
                if (response.getContent() == null) continue;
                Content content = response.getContent();
                for (String mediaType : content.keySet()) {
                    Object resolved;
                    if (((MediaType)content.get(mediaType)).getSchema() != null) {
                        resolved = this.resolveSchema(((MediaType)content.get(mediaType)).getSchema());
                        ((MediaType)response.getContent().get((Object)mediaType)).setSchema(resolved);
                    }
                    if (((MediaType)content.get(mediaType)).getExamples() == null) continue;
                    resolved = this.resolveExample(((MediaType)content.get(mediaType)).getExamples());
                    ((MediaType)response.getContent().get((Object)mediaType)).setExamples((Map)resolved);
                }
            }
        }
    }

    public Schema resolveSchema(Schema schema) {
        if (schema.get$ref() != null) {
            String ref = schema.get$ref();
            Schema resolved = this.schemas.get(ref = ref.substring(ref.lastIndexOf("/") + 1));
            if (resolved == null) {
                LOGGER.error("unresolved model " + ref);
                return schema;
            }
            if (this.resolvedModels.containsKey(ref)) {
                LOGGER.debug("avoiding infinite loop");
                return this.resolvedModels.get(ref);
            }
            this.resolvedModels.put(ref, schema);
            Schema model = this.resolveSchema(resolved);
            this.resolvedModels.put(ref, model);
            return model;
        }
        if (schema instanceof ArraySchema) {
            ArraySchema arrayModel = (ArraySchema)schema;
            if (arrayModel.getItems().get$ref() != null) {
                arrayModel.setItems(this.resolveSchema(arrayModel.getItems()));
            } else {
                arrayModel.setItems(arrayModel.getItems());
            }
            return arrayModel;
        }
        if (schema instanceof ObjectSchema) {
            ObjectSchema obj = (ObjectSchema)schema;
            if (obj.getProperties() != null) {
                LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
                for (String propertyName : obj.getProperties().keySet()) {
                    Schema innerProperty = (Schema)obj.getProperties().get(propertyName);
                    if (schema == innerProperty) continue;
                    Schema resolved = this.resolveSchema(innerProperty);
                    updated.put(propertyName, resolved);
                }
                obj.setProperties(updated);
            }
            return obj;
        }
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            if (this.aggregateCombinators) {
                Schema model = SchemaTypeUtil.createSchema(composedSchema.getType(), composedSchema.getFormat());
                HashSet<String> requiredProperties = new HashSet<String>();
                if (composedSchema.getAllOf() != null) {
                    for (Schema innerModel : composedSchema.getAllOf()) {
                        Schema resolved = this.resolveSchema(innerModel);
                        Map properties = resolved.getProperties();
                        if (resolved.getProperties() != null) {
                            for (String key : properties.keySet()) {
                                Schema prop = (Schema)resolved.getProperties().get(key);
                                model.addProperties(key, this.resolveSchema(prop));
                            }
                            if (resolved.getRequired() != null) {
                                for (int i = 0; i < resolved.getRequired().size(); ++i) {
                                    if (resolved.getRequired().get(i) == null) continue;
                                    requiredProperties.add(resolved.getRequired().get(i).toString());
                                }
                            }
                        }
                        if (requiredProperties.size() > 0) {
                            model.setRequired(new ArrayList(requiredProperties));
                        }
                        if (composedSchema.getExtensions() == null) continue;
                        Map extensions = composedSchema.getExtensions();
                        for (String key : extensions.keySet()) {
                            model.addExtension(key, composedSchema.getExtensions().get(key));
                        }
                    }
                    return model;
                }
                if (composedSchema.getOneOf() != null) {
                    ArrayList<Schema> list = new ArrayList<Schema>();
                    for (Schema innerModel : composedSchema.getOneOf()) {
                        Schema resolved = this.resolveSchema(innerModel);
                        list.add(resolved);
                    }
                    composedSchema.setOneOf(list);
                } else if (composedSchema.getAnyOf() != null) {
                    ArrayList<Schema> list = new ArrayList<Schema>();
                    for (Schema innerModel : composedSchema.getAnyOf()) {
                        Schema resolved = this.resolveSchema(innerModel);
                        list.add(resolved);
                    }
                    composedSchema.setAnyOf(list);
                }
                return composedSchema;
            }
            if (composedSchema.getAllOf() != null) {
                composedSchema.allOf(composedSchema.getAllOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            } else if (composedSchema.getOneOf() != null) {
                composedSchema.oneOf(composedSchema.getOneOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            } else if (composedSchema.getAnyOf() != null) {
                composedSchema.anyOf(composedSchema.getAnyOf().stream().map(this::resolveSchema).collect(Collectors.toList()));
            }
            return composedSchema;
        }
        if (schema.getProperties() != null) {
            Schema property;
            Schema model = schema;
            LinkedHashMap<String, Schema> updated = new LinkedHashMap<String, Schema>();
            Map properties = model.getProperties();
            for (String propertyName : properties.keySet()) {
                property = (Schema)model.getProperties().get(propertyName);
                Schema resolved = this.resolveSchema(property);
                updated.put(propertyName, resolved);
            }
            for (String key : updated.keySet()) {
                property = (Schema)updated.get(key);
                if (!(property instanceof ObjectSchema)) continue;
                ObjectSchema op = (ObjectSchema)property;
                if (op.getProperties() != model.getProperties()) {
                    if (property.getType() == null) {
                        property.setType("object");
                    }
                    model.addProperties(key, property);
                    continue;
                }
                LOGGER.debug("not adding recursive properties, using generic object");
                ObjectSchema newSchema = new ObjectSchema();
                model.addProperties(key, (Schema)newSchema);
            }
            return model;
        }
        return schema;
    }

    public Map<String, Example> resolveExample(Map<String, Example> examples) {
        Map<String, Example> resolveExamples = examples;
        if (examples != null) {
            for (String name : examples.keySet()) {
                if (examples.get(name).get$ref() == null) continue;
                String ref = examples.get(name).get$ref();
                ref = ref.substring(ref.lastIndexOf("/") + 1);
                Example sample = this.examples.get(ref);
                resolveExamples.replace(name, sample);
            }
        }
        return resolveExamples;
    }
}

