/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.v3.parser.converter;

import io.swagger.models.ArrayModel;
import io.swagger.models.ComposedModel;
import io.swagger.models.Contact;
import io.swagger.models.ExternalDocs;
import io.swagger.models.Info;
import io.swagger.models.License;
import io.swagger.models.Model;
import io.swagger.models.ModelImpl;
import io.swagger.models.Path;
import io.swagger.models.RefModel;
import io.swagger.models.RefPath;
import io.swagger.models.RefResponse;
import io.swagger.models.Response;
import io.swagger.models.Scheme;
import io.swagger.models.Swagger;
import io.swagger.models.auth.ApiKeyAuthDefinition;
import io.swagger.models.auth.AuthorizationValue;
import io.swagger.models.auth.OAuth2Definition;
import io.swagger.models.auth.SecuritySchemeDefinition;
import io.swagger.models.parameters.AbstractSerializableParameter;
import io.swagger.models.parameters.BodyParameter;
import io.swagger.models.parameters.Parameter;
import io.swagger.models.parameters.RefParameter;
import io.swagger.models.parameters.SerializableParameter;
import io.swagger.models.properties.AbstractNumericProperty;
import io.swagger.models.properties.ArrayProperty;
import io.swagger.models.properties.FileProperty;
import io.swagger.models.properties.MapProperty;
import io.swagger.models.properties.ObjectProperty;
import io.swagger.models.properties.Property;
import io.swagger.models.properties.RefProperty;
import io.swagger.models.properties.StringProperty;
import io.swagger.parser.SwaggerParser;
import io.swagger.parser.SwaggerResolver;
import io.swagger.parser.util.SwaggerDeserializationResult;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.ExternalDocumentation;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Discriminator;
import io.swagger.v3.oas.models.media.FileSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.OAuthFlow;
import io.swagger.v3.oas.models.security.OAuthFlows;
import io.swagger.v3.oas.models.security.Scopes;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.tags.Tag;
import io.swagger.v3.parser.converter.SwaggerInventory;
import io.swagger.v3.parser.core.extensions.SwaggerParserExtension;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SwaggerConverter
implements SwaggerParserExtension {
    private List<String> globalConsumes = new ArrayList<String>();
    private List<String> globalProduces = new ArrayList<String>();
    private Components components = new Components();
    private Map<String, Parameter> globalV2Parameters = new HashMap<String, Parameter>();

    public SwaggerParseResult readLocation(String url, List<io.swagger.v3.parser.core.models.AuthorizationValue> auths, ParseOptions options) {
        boolean resolve = false;
        if (options != null) {
            resolve = options.isResolve();
        }
        SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(url, this.convert(auths), resolve);
        return this.convert(result);
    }

    public SwaggerParseResult readContents(String swaggerAsString, List<io.swagger.v3.parser.core.models.AuthorizationValue> auth, ParseOptions options) {
        SwaggerDeserializationResult result = new SwaggerParser().readWithInfo(swaggerAsString, options == null ? true : options.isResolve());
        if (options != null && options.isResolve()) {
            Swagger resolved = new SwaggerResolver(result.getSwagger(), this.convert(auth)).resolve();
            result.setSwagger(resolved);
        }
        return this.convert(result);
    }

    public List<AuthorizationValue> convert(List<io.swagger.v3.parser.core.models.AuthorizationValue> auths) {
        ArrayList<AuthorizationValue> convertedAuth = new ArrayList<AuthorizationValue>();
        if (auths != null) {
            for (io.swagger.v3.parser.core.models.AuthorizationValue auth : auths) {
                AuthorizationValue v = new AuthorizationValue();
                v.setType(auth.getType());
                v.setValue(auth.getValue());
                v.setKeyName(auth.getKeyName());
                convertedAuth.add(v);
            }
        }
        return convertedAuth;
    }

    public SwaggerParseResult convert(SwaggerDeserializationResult parse) {
        String updatedRef;
        RefModel ref;
        if (parse == null) {
            return null;
        }
        SwaggerParseResult output = new SwaggerParseResult().messages(parse.getMessages());
        if (parse.getSwagger() == null) {
            return output;
        }
        OpenAPI openAPI = new OpenAPI();
        SwaggerInventory inventory = new SwaggerInventory().process(parse.getSwagger());
        Swagger swagger = parse.getSwagger();
        if (swagger.getExternalDocs() != null) {
            openAPI.setExternalDocs(this.convert(swagger.getExternalDocs()));
        }
        if (swagger.getInfo() != null) {
            openAPI.setInfo(this.convert(swagger.getInfo()));
        }
        openAPI.setServers(this.convert(swagger.getSchemes(), swagger.getHost(), swagger.getBasePath()));
        if (swagger.getTags() != null) {
            openAPI.setTags(this.convertTags(swagger.getTags()));
        }
        if (swagger.getConsumes() != null) {
            this.globalConsumes.addAll(swagger.getConsumes());
        }
        if (swagger.getProduces() != null) {
            this.globalProduces.addAll(swagger.getProduces());
        }
        if (swagger.getSecurity() != null && swagger.getSecurity().size() > 0) {
            openAPI.setSecurity(this.convertSecurityRequirements(swagger.getSecurity()));
        }
        List<Model> models = inventory.getModels();
        for (Model model : models) {
            if (!(model instanceof RefModel) || (ref = (RefModel)model).get$ref().indexOf("#/definitions") != 0) continue;
            updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
            ref.set$ref(updatedRef);
        }
        for (Property property : inventory.getProperties()) {
            if (!(property instanceof RefProperty) || (ref = (RefProperty)property).get$ref().indexOf("#/definitions") != 0) continue;
            updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
            ref.set$ref(updatedRef);
        }
        if (swagger.getParameters() != null) {
            this.globalV2Parameters.putAll(swagger.getParameters());
            swagger.getParameters().forEach((k, v) -> {
                if ("body".equals(v.getIn())) {
                    this.components.addRequestBodies(k, this.convertParameterToRequestBody((Parameter)v));
                } else if ("formData".equals(v.getIn())) {
                    this.components.addRequestBodies(k, this.convertFormDataToRequestBody((Parameter)v));
                } else {
                    this.components.addParameters(k, this.convert((Parameter)v));
                }
            });
        }
        Paths v3Paths = new Paths();
        Map pathMap = Optional.ofNullable(swagger.getPaths()).orElse(new HashMap());
        for (String pathname : pathMap.keySet()) {
            Path v2Path = swagger.getPath(pathname);
            PathItem v3Path = this.convert(v2Path);
            v3Paths.put((Object)pathname, (Object)v3Path);
        }
        openAPI.setPaths(v3Paths);
        if (swagger.getResponses() != null) {
            swagger.getResponses().forEach((k, v) -> this.components.addResponses(k, this.convert((Response)v)));
        }
        if (swagger.getDefinitions() != null) {
            for (String key : swagger.getDefinitions().keySet()) {
                Model model = (Model)swagger.getDefinitions().get(key);
                Schema schema = this.convert(model);
                this.components.addSchemas(key, schema);
            }
        }
        if (swagger.getSecurityDefinitions() != null) {
            swagger.getSecurityDefinitions().forEach((k, v) -> this.components.addSecuritySchemes(k, this.convert((SecuritySchemeDefinition)v)));
        }
        openAPI.setComponents(this.components);
        output.setOpenAPI(openAPI);
        return output;
    }

    private List<SecurityRequirement> convertSecurityRequirements(List<io.swagger.models.SecurityRequirement> security) {
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (io.swagger.models.SecurityRequirement requirement : security) {
            SecurityRequirement securityRequirement = new SecurityRequirement();
            requirement.getRequirements().forEach((k, v) -> securityRequirement.addList(k, v));
            securityRequirements.add(securityRequirement);
        }
        return securityRequirements;
    }

    private List<SecurityRequirement> convertSecurityRequirementsMap(List<Map<String, List<String>>> security) {
        ArrayList<SecurityRequirement> securityRequirements = new ArrayList<SecurityRequirement>();
        for (Map<String, List<String>> map : security) {
            SecurityRequirement securityRequirement = new SecurityRequirement();
            map.forEach((k, v) -> securityRequirement.addList(k, v));
            securityRequirements.add(securityRequirement);
        }
        return securityRequirements;
    }

    private SecurityScheme convert(SecuritySchemeDefinition definition) {
        SecurityScheme securityScheme;
        switch (definition.getType()) {
            case "basic": {
                securityScheme = this.createBasicSecurityScheme();
                break;
            }
            case "apiKey": {
                securityScheme = this.convertApiKeySecurityScheme(definition);
                break;
            }
            case "oauth2": {
                securityScheme = this.convertOauth2SecurityScheme(definition);
                break;
            }
            default: {
                securityScheme = new SecurityScheme();
            }
        }
        securityScheme.setDescription(definition.getDescription());
        securityScheme.setExtensions(this.convert(definition.getVendorExtensions()));
        return securityScheme;
    }

    private SecurityScheme convertOauth2SecurityScheme(SecuritySchemeDefinition definition) {
        SecurityScheme securityScheme = new SecurityScheme();
        OAuth2Definition oAuth2Definition = (OAuth2Definition)definition;
        OAuthFlows oAuthFlows = new OAuthFlows();
        OAuthFlow oAuthFlow = new OAuthFlow();
        securityScheme.setType(SecurityScheme.Type.OAUTH2);
        String flow = oAuth2Definition.getFlow();
        if (flow != null) {
            switch (flow) {
                case "implicit": {
                    oAuthFlow.setAuthorizationUrl(oAuth2Definition.getAuthorizationUrl());
                    oAuthFlows.setImplicit(oAuthFlow);
                    break;
                }
                case "password": {
                    oAuthFlow.setTokenUrl(oAuth2Definition.getTokenUrl());
                    oAuthFlows.setPassword(oAuthFlow);
                    break;
                }
                case "application": {
                    oAuthFlow.setTokenUrl(oAuth2Definition.getTokenUrl());
                    oAuthFlows.setClientCredentials(oAuthFlow);
                    break;
                }
                case "accessCode": {
                    oAuthFlow.setAuthorizationUrl(oAuth2Definition.getAuthorizationUrl());
                    oAuthFlow.setTokenUrl(oAuth2Definition.getTokenUrl());
                    oAuthFlows.setAuthorizationCode(oAuthFlow);
                }
            }
        }
        Scopes scopes = new Scopes();
        Map oAuth2Scopes = oAuth2Definition.getScopes();
        if (oAuth2Scopes != null) {
            oAuth2Scopes.forEach((k, v) -> scopes.addString(k, v));
        }
        oAuthFlow.setScopes(scopes);
        securityScheme.setFlows(oAuthFlows);
        return securityScheme;
    }

    private SecurityScheme convertApiKeySecurityScheme(SecuritySchemeDefinition definition) {
        SecurityScheme securityScheme = new SecurityScheme();
        ApiKeyAuthDefinition apiKeyAuthDefinition = (ApiKeyAuthDefinition)definition;
        securityScheme.setType(SecurityScheme.Type.APIKEY);
        securityScheme.setName(apiKeyAuthDefinition.getName());
        securityScheme.setIn(SecurityScheme.In.valueOf((String)apiKeyAuthDefinition.getIn().toString()));
        return securityScheme;
    }

    private SecurityScheme createBasicSecurityScheme() {
        SecurityScheme securityScheme = new SecurityScheme();
        securityScheme.setType(SecurityScheme.Type.HTTP);
        securityScheme.setScheme("basic");
        return securityScheme;
    }

    private List<Tag> convertTags(List<io.swagger.models.Tag> v2tags) {
        ArrayList<Tag> v3tags = new ArrayList<Tag>();
        for (io.swagger.models.Tag v2tag : v2tags) {
            Map<String, Object> extensions;
            Tag v3tag = new Tag();
            v3tag.setDescription(v2tag.getDescription());
            v3tag.setName(v2tag.getName());
            if (v2tag.getExternalDocs() != null) {
                v3tag.setExternalDocs(this.convert(v2tag.getExternalDocs()));
            }
            if ((extensions = this.convert(v2tag.getVendorExtensions())) != null) {
                v3tag.setExtensions(extensions);
            }
            v3tags.add(v3tag);
        }
        return v3tags;
    }

    private ExternalDocumentation convert(ExternalDocs externalDocs) {
        ExternalDocumentation externalDocumentation = new ExternalDocumentation();
        externalDocumentation.setUrl(externalDocs.getUrl());
        externalDocumentation.setDescription(externalDocs.getDescription());
        Map<String, Object> extensions = this.convert(externalDocs.getVendorExtensions());
        if (extensions != null && extensions.size() > 0) {
            externalDocumentation.setExtensions(extensions);
        }
        return externalDocumentation;
    }

    private List<Server> convert(List<Scheme> schemes, String host, String basePath) {
        ArrayList<Server> servers = new ArrayList<Server>();
        String baseUrl = StringUtils.isNotEmpty((CharSequence)basePath) ? basePath : "/";
        if (StringUtils.isNotEmpty((CharSequence)host)) {
            baseUrl = host + baseUrl;
        }
        if (!StringUtils.startsWith((CharSequence)baseUrl, (CharSequence)"/") && schemes != null && !schemes.isEmpty()) {
            for (Scheme scheme : schemes) {
                Server server = new Server();
                server.setUrl(scheme.toValue() + "://" + baseUrl);
                servers.add(server);
            }
        } else {
            if (!"/".equals(baseUrl)) {
                baseUrl = "//" + baseUrl;
            }
            Server server = new Server();
            server.setUrl(baseUrl);
            servers.add(server);
        }
        return servers;
    }

    public io.swagger.v3.oas.models.info.Info convert(Info v2Info) {
        io.swagger.v3.oas.models.info.Info info = new io.swagger.v3.oas.models.info.Info();
        info.setContact(this.convert(v2Info.getContact()));
        info.setDescription(v2Info.getDescription());
        info.setLicense(this.convert(v2Info.getLicense()));
        info.setTermsOfService(v2Info.getTermsOfService());
        info.setTitle(v2Info.getTitle());
        info.setVersion(v2Info.getVersion());
        info.setExtensions(this.convert(v2Info.getVendorExtensions()));
        return info;
    }

    private io.swagger.v3.oas.models.info.License convert(License v2License) {
        if (v2License == null) {
            return null;
        }
        io.swagger.v3.oas.models.info.License license = new io.swagger.v3.oas.models.info.License();
        license.setExtensions(this.convert(v2License.getVendorExtensions()));
        license.setName(v2License.getName());
        license.setUrl(v2License.getUrl());
        return license;
    }

    public io.swagger.v3.oas.models.info.Contact convert(Contact v2Contact) {
        if (v2Contact == null) {
            return null;
        }
        io.swagger.v3.oas.models.info.Contact contact = new io.swagger.v3.oas.models.info.Contact();
        contact.setUrl(v2Contact.getUrl());
        contact.setName(v2Contact.getName());
        contact.setEmail(v2Contact.getEmail());
        return contact;
    }

    public PathItem convert(Path v2Path) {
        PathItem v3Path = new PathItem();
        if (v2Path instanceof RefPath) {
            v3Path.set$ref(((RefPath)v2Path).get$ref());
        } else {
            io.swagger.models.Operation v2Operation;
            if (v2Path.getParameters() != null) {
                for (Parameter param : v2Path.getParameters()) {
                    v3Path.addParametersItem(this.convert(param));
                }
            }
            if ((v2Operation = v2Path.getGet()) != null) {
                v3Path.setGet(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getPut()) != null) {
                v3Path.setPut(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getPost()) != null) {
                v3Path.setPost(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getPatch()) != null) {
                v3Path.setPatch(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getDelete()) != null) {
                v3Path.setDelete(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getHead()) != null) {
                v3Path.setHead(this.convert(v2Operation));
            }
            if ((v2Operation = v2Path.getOptions()) != null) {
                v3Path.setOptions(this.convert(v2Operation));
            }
            v3Path.setExtensions(this.convert(v2Path.getVendorExtensions()));
        }
        return v3Path;
    }

    private boolean isRefABodyParam(Parameter param) {
        if (param instanceof RefParameter) {
            RefParameter refParameter = (RefParameter)param;
            String simpleRef = refParameter.getSimpleRef();
            Parameter parameter = this.globalV2Parameters.get(simpleRef);
            return "body".equals(parameter.getIn());
        }
        return false;
    }

    public Operation convert(io.swagger.models.Operation v2Operation) {
        Operation operation = new Operation();
        if (StringUtils.isNotBlank((CharSequence)v2Operation.getDescription())) {
            operation.setDescription(v2Operation.getDescription());
        }
        if (StringUtils.isNotBlank((CharSequence)v2Operation.getSummary())) {
            operation.setSummary(v2Operation.getSummary());
        }
        operation.setDeprecated(v2Operation.isDeprecated());
        operation.setOperationId(v2Operation.getOperationId());
        operation.setTags(v2Operation.getTags());
        if (v2Operation.getParameters() != null) {
            ArrayList<Parameter> formParams = new ArrayList<Parameter>();
            for (Parameter param : v2Operation.getParameters()) {
                if ("formData".equals(param.getIn())) {
                    formParams.add(param);
                    continue;
                }
                if ("body".equals(param.getIn())) {
                    operation.setRequestBody(this.convertParameterToRequestBody(param, v2Operation.getConsumes()));
                    continue;
                }
                io.swagger.v3.oas.models.parameters.Parameter convert = this.convert(param);
                String $ref = convert.get$ref();
                if ($ref != null && $ref.startsWith("#/components/requestBodies/") && this.isRefABodyParam(param)) {
                    operation.setRequestBody(new RequestBody().$ref($ref));
                    continue;
                }
                operation.addParametersItem(convert);
            }
            if (formParams.size() > 0) {
                RequestBody body = this.convertFormDataToRequestBody(formParams, v2Operation.getConsumes());
                body.getContent().forEach((key, content) -> {
                    Schema schema = content.getSchema();
                    if (schema != null && schema.getRequired() != null && schema.getRequired().size() > 0) {
                        body.setRequired(Boolean.TRUE);
                    }
                });
                operation.requestBody(body);
            }
        }
        if (v2Operation.getResponses() != null) {
            for (String responseCode : v2Operation.getResponses().keySet()) {
                Response v2Response = (Response)v2Operation.getResponses().get(responseCode);
                ApiResponse response = this.convert(v2Response, v2Operation.getProduces());
                ApiResponses responses = operation.getResponses();
                if (responses == null) {
                    responses = new ApiResponses();
                }
                operation.responses(responses.addApiResponse(responseCode, response));
            }
        }
        if (v2Operation.getExternalDocs() != null) {
            operation.setExternalDocs(this.convert(v2Operation.getExternalDocs()));
        }
        if (v2Operation.getSecurity() != null && v2Operation.getSecurity().size() > 0) {
            operation.setSecurity(this.convertSecurityRequirementsMap(v2Operation.getSecurity()));
        }
        operation.setExtensions(this.convert(v2Operation.getVendorExtensions()));
        return operation;
    }

    private Map<String, Object> convert(Map<String, Object> vendorExtensions) {
        if (vendorExtensions != null && vendorExtensions.size() > 0) {
            vendorExtensions.entrySet().removeIf(extension -> ((String)extension.getKey()).equals("x-example") || ((String)extension.getKey()).equals("x-examples") || ((String)extension.getKey()).equals("x-nullable"));
        }
        return vendorExtensions;
    }

    private RequestBody convertFormDataToRequestBody(Parameter formParam) {
        return this.convertFormDataToRequestBody(Arrays.asList(formParam), null);
    }

    private RequestBody convertFormDataToRequestBody(List<Parameter> formParams, List<String> consumes) {
        RequestBody body = new RequestBody();
        Schema formSchema = new Schema();
        for (Parameter param : formParams) {
            FileSchema schema;
            SerializableParameter sp = (SerializableParameter)param;
            if ("file".equals(sp.getType())) {
                schema = new FileSchema();
            } else if ("array".equals(sp.getType())) {
                ArraySchema as = new ArraySchema();
                if (sp.getItems() != null) {
                    as.setItems(this.convert(sp.getItems()));
                }
                schema = as;
            } else {
                schema = new Schema();
                schema.setType(sp.getType());
                schema.setFormat(sp.getFormat());
            }
            schema.setDescription(sp.getDescription());
            schema.setReadOnly(sp.isReadOnly());
            schema.setEnum(sp.getEnum());
            if (sp.getMaxItems() != null) {
                schema.setMaxItems(sp.getMaxItems());
            }
            if (sp.getMinItems() != null) {
                schema.setMinItems(sp.getMinItems());
            }
            if (sp.isUniqueItems() != null) {
                schema.setUniqueItems(sp.isUniqueItems());
            }
            schema.setMaximum(sp.getMaximum());
            schema.setExclusiveMaximum(sp.isExclusiveMaximum());
            schema.setMinimum(sp.getMinimum());
            schema.setExclusiveMinimum(sp.isExclusiveMinimum());
            schema.setMinLength(sp.getMinLength());
            schema.setMaxLength(sp.getMaxLength());
            if (sp.getVendorExtensions() != null) {
                Object nullableExtension;
                Object exampleExtension = sp.getVendorExtensions().get("x-example");
                if (exampleExtension != null) {
                    schema.setExample(exampleExtension);
                }
                if ((nullableExtension = sp.getVendorExtensions().get("x-nullable")) != null) {
                    schema.setNullable((Boolean)nullableExtension);
                }
                schema.setExtensions(this.convert(sp.getVendorExtensions()));
            }
            if (sp.getMultipleOf() != null) {
                schema.setMultipleOf(new BigDecimal(sp.getMultipleOf().toString()));
            }
            schema.setPattern(sp.getPattern());
            schema.setExtensions(this.convert(sp.getVendorExtensions()));
            if (sp instanceof AbstractSerializableParameter) {
                AbstractSerializableParameter ap = (AbstractSerializableParameter)sp;
                schema.setDefault(ap.getDefault());
            }
            if (sp.getRequired()) {
                formSchema.addRequiredItem(sp.getName());
            }
            formSchema.addProperties(param.getName(), (Schema)schema);
        }
        ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
        if (consumes != null && consumes.size() > 0) {
            mediaTypes.clear();
            mediaTypes.addAll(consumes);
        }
        if (mediaTypes.size() == 0) {
            mediaTypes.add("multipart/form-data");
        }
        Content content = new Content();
        for (String type : mediaTypes) {
            content.addMediaType(type, new MediaType().schema(formSchema));
        }
        body.content(content);
        return body;
    }

    private RequestBody convertParameterToRequestBody(Parameter param) {
        return this.convertParameterToRequestBody(param, null);
    }

    private RequestBody convertParameterToRequestBody(Parameter param, List<String> consumes) {
        RequestBody body = new RequestBody();
        BodyParameter bp = (BodyParameter)param;
        ArrayList<String> mediaTypes = new ArrayList<String>(this.globalConsumes);
        if (consumes != null && consumes.size() > 0) {
            mediaTypes.clear();
            mediaTypes.addAll(consumes);
        }
        if (mediaTypes.size() == 0) {
            mediaTypes.add("*/*");
        }
        if (StringUtils.isNotBlank((CharSequence)param.getDescription())) {
            body.description(param.getDescription());
        }
        body.required(Boolean.valueOf(param.getRequired()));
        Content content = new Content();
        for (String type : mediaTypes) {
            content.addMediaType(type, new MediaType().schema(this.convert(bp.getSchema())));
            if (!StringUtils.isNotBlank((CharSequence)bp.getDescription())) continue;
            body.setDescription(bp.getDescription());
        }
        this.convertExamples(((BodyParameter)param).getExamples(), content);
        body.content(content);
        return body;
    }

    public ApiResponse convert(Response response) {
        return this.convert(response, null);
    }

    public ApiResponse convert(Response v2Response, List<String> produces) {
        ApiResponse response = new ApiResponse();
        Content content = new Content();
        if (v2Response instanceof RefResponse) {
            RefResponse ref = (RefResponse)v2Response;
            if (ref.get$ref().indexOf("#/responses") == 0) {
                String updatedRef = "#/components/responses" + ref.get$ref().substring("#/responses".length());
                ref.set$ref(updatedRef);
            }
            response.set$ref(ref.get$ref());
        } else {
            ArrayList<String> mediaTypes = new ArrayList<String>(this.globalProduces);
            if (produces != null) {
                mediaTypes.clear();
                mediaTypes.addAll(produces);
            }
            if (mediaTypes.size() == 0) {
                mediaTypes.add("*/*");
            }
            response.setDescription(v2Response.getDescription());
            if (v2Response.getSchema() != null) {
                Schema schema = this.convertFileSchema(this.convert(v2Response.getSchema()));
                for (String type : mediaTypes) {
                    MediaType mediaType = new MediaType();
                    content.addMediaType(type, mediaType.schema(schema));
                }
                response.content(content);
            }
            response.content(this.convertExamples(v2Response.getExamples(), content));
            response.setExtensions(this.convert(v2Response.getVendorExtensions()));
            if (v2Response.getHeaders() != null && v2Response.getHeaders().size() > 0) {
                response.setHeaders(this.convertHeaders(v2Response.getHeaders()));
            }
        }
        return response;
    }

    private Content convertExamples(Map examples, Content content) {
        if (examples != null) {
            examples.forEach((k, v) -> {
                MediaType mT = (MediaType)content.get(k);
                if (mT == null) {
                    mT = new MediaType();
                    content.addMediaType(k.toString(), mT);
                }
                mT.setExample(v);
            });
        }
        return content;
    }

    private Schema convertFileSchema(Schema schema) {
        if ("file".equals(schema.getType())) {
            schema.setType("string");
            schema.setFormat("binary");
        }
        return schema;
    }

    private Map<String, Header> convertHeaders(Map<String, Property> headers) {
        HashMap<String, Header> result = new HashMap<String, Header>();
        headers.forEach((k, v) -> result.put((String)k, this.convertHeader((Property)v)));
        return result;
    }

    private Header convertHeader(Property property) {
        Schema schema = this.convert(property);
        schema.setDescription(null);
        Header header = new Header();
        header.setDescription(property.getDescription());
        header.setSchema(schema);
        return header;
    }

    private Schema convert(Property schema) {
        Schema result;
        if (schema == null) {
            return null;
        }
        if (schema instanceof RefProperty) {
            RefProperty ref = (RefProperty)schema;
            if (ref.get$ref().indexOf("#/definitions") == 0) {
                String updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
                ref.set$ref(updatedRef);
            }
            result = new Schema();
            result.set$ref(ref.get$ref());
        } else if (schema instanceof ArrayProperty) {
            ArraySchema arraySchema = (ArraySchema)Json.mapper().convertValue((Object)schema, ArraySchema.class);
            Property items = ((ArrayProperty)schema).getItems();
            Schema itemsSchema = this.convert(items);
            arraySchema.setItems(itemsSchema);
            if (((ArrayProperty)schema).getMaxItems() != null) {
                arraySchema.setMaxItems(((ArrayProperty)schema).getMaxItems());
            }
            if (((ArrayProperty)schema).getMinItems() != null) {
                arraySchema.setMinItems(((ArrayProperty)schema).getMinItems());
            }
            if (((ArrayProperty)schema).getUniqueItems() != null && ((ArrayProperty)schema).getUniqueItems().booleanValue()) {
                arraySchema.setUniqueItems(((ArrayProperty)schema).getUniqueItems());
            }
            result = arraySchema;
        } else if (schema instanceof FileProperty) {
            FileSchema fileSchema = (FileSchema)Json.mapper().convertValue((Object)schema, FileSchema.class);
            result = fileSchema;
        } else {
            result = (Schema)Json.mapper().convertValue((Object)schema, Schema.class);
            result.setExample(schema.getExample());
            if ("object".equals(schema.getType()) && result.getProperties() != null && result.getProperties().size() > 0) {
                HashMap properties = new HashMap();
                ((ObjectProperty)schema).getProperties().forEach((k, v) -> properties.put(k, this.convert((Property)v)));
                result.setProperties(properties);
            }
            if (schema instanceof MapProperty) {
                MapProperty map = (MapProperty)schema;
                result.setAdditionalProperties((Object)this.convert(map.getAdditionalProperties()));
                result.setMinProperties(map.getMinProperties());
                result.setMaxProperties(map.getMaxProperties());
            }
            if (schema instanceof AbstractNumericProperty) {
                AbstractNumericProperty np = (AbstractNumericProperty)schema;
                result.setExclusiveMaximum(np.getExclusiveMaximum());
                result.setExclusiveMinimum(np.getExclusiveMinimum());
            }
            if (schema instanceof StringProperty) {
                StringProperty sp = (StringProperty)schema;
                result.setMinLength(sp.getMinLength());
                result.setMaxLength(sp.getMaxLength());
                result.setPattern(sp.getPattern());
            }
        }
        if (schema.getVendorExtensions() != null) {
            Object nullableExtension = schema.getVendorExtensions().get("x-nullable");
            if (nullableExtension != null) {
                result.setNullable((Boolean)nullableExtension);
            }
            result.setExtensions(this.convert(schema.getVendorExtensions()));
        }
        return result;
    }

    public io.swagger.v3.oas.models.parameters.Parameter convert(Parameter v2Parameter) {
        io.swagger.v3.oas.models.parameters.Parameter v3Parameter = new io.swagger.v3.oas.models.parameters.Parameter();
        if (StringUtils.isNotBlank((CharSequence)v2Parameter.getDescription())) {
            v3Parameter.setDescription(v2Parameter.getDescription());
        }
        if (v2Parameter instanceof SerializableParameter) {
            v3Parameter.setAllowEmptyValue(((SerializableParameter)v2Parameter).getAllowEmptyValue());
        }
        v3Parameter.setIn(v2Parameter.getIn());
        v3Parameter.setName(v2Parameter.getName());
        Object exampleExtension = v2Parameter.getVendorExtensions().get("x-example");
        if (exampleExtension != null) {
            v3Parameter.setExample(exampleExtension);
        }
        Schema schema = null;
        if (v2Parameter instanceof RefParameter) {
            RefParameter ref = (RefParameter)v2Parameter;
            if (ref.get$ref().indexOf("#/parameters") == 0) {
                String updatedRef = "#/components/";
                updatedRef = this.components.getRequestBodies() != null && this.components.getRequestBodies().get(ref.getSimpleRef()) != null ? updatedRef + "requestBodies" : updatedRef + "parameters";
                updatedRef = updatedRef + ref.get$ref().substring("#/parameters".length());
                ref.set$ref(updatedRef);
            }
            v3Parameter.set$ref(ref.get$ref());
        } else if (v2Parameter instanceof SerializableParameter) {
            Object nullableExtension;
            SerializableParameter sp = (SerializableParameter)v2Parameter;
            if ("array".equals(sp.getType())) {
                ArraySchema a = new ArraySchema();
                String cf = sp.getCollectionFormat();
                if (StringUtils.isEmpty((CharSequence)cf)) {
                    cf = "csv";
                }
                switch (cf) {
                    case "ssv": {
                        if (!"query".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.SPACEDELIMITED);
                        break;
                    }
                    case "pipes": {
                        if (!"query".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.PIPEDELIMITED);
                        break;
                    }
                    case "tsv": {
                        break;
                    }
                    case "multi": {
                        if (!"query".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.FORM);
                        v3Parameter.setExplode(Boolean.valueOf(true));
                        break;
                    }
                    default: {
                        if ("query".equals(v2Parameter.getIn())) {
                            v3Parameter.setStyle(Parameter.StyleEnum.FORM);
                            v3Parameter.setExplode(Boolean.valueOf(false));
                            break;
                        }
                        if (!"header".equals(v2Parameter.getIn()) && !"path".equals(v2Parameter.getIn())) break;
                        v3Parameter.setStyle(Parameter.StyleEnum.SIMPLE);
                        v3Parameter.setExplode(Boolean.valueOf(false));
                    }
                }
                Property items = sp.getItems();
                Schema itemsSchema = this.convert(items);
                a.setItems(itemsSchema);
                if (sp.getMaxItems() != null) {
                    a.setMaxItems(sp.getMaxItems());
                }
                if (sp.getMinItems() != null) {
                    a.setMinItems(sp.getMinItems());
                }
                if (sp.isUniqueItems() != null) {
                    a.setUniqueItems(sp.isUniqueItems());
                }
                schema = a;
            } else {
                schema = new Schema();
                schema.setType(sp.getType());
                schema.setFormat(sp.getFormat());
                schema.setMaximum(sp.getMaximum());
                schema.setExclusiveMaximum(sp.isExclusiveMaximum());
                schema.setMinimum(sp.getMinimum());
                schema.setExclusiveMinimum(sp.isExclusiveMinimum());
                schema.setMinLength(sp.getMinLength());
                schema.setMaxLength(sp.getMaxLength());
                if (sp.getMultipleOf() != null) {
                    schema.setMultipleOf(new BigDecimal(sp.getMultipleOf().toString()));
                }
                schema.setPattern(sp.getPattern());
            }
            if (sp.getEnum() != null) {
                block23: for (String e : sp.getEnum()) {
                    switch (sp.getType() == null ? "object" : sp.getType()) {
                        case "integer": {
                            schema.addEnumItemObject((Object)Integer.parseInt(e));
                            continue block23;
                        }
                        case "number": {
                            schema.addEnumItemObject((Object)new BigDecimal(e));
                            continue block23;
                        }
                        case "boolean": {
                            schema.addEnumItemObject((Object)Boolean.valueOf(e));
                            continue block23;
                        }
                    }
                    schema.addEnumItemObject((Object)e);
                }
            }
            if (sp.getVendorExtensions() != null && (nullableExtension = sp.getVendorExtensions().get("x-nullable")) != null) {
                schema.setNullable((Boolean)nullableExtension);
            }
            schema.setExtensions(this.convert(sp.getVendorExtensions()));
            if (sp instanceof AbstractSerializableParameter) {
                AbstractSerializableParameter ap = (AbstractSerializableParameter)sp;
                schema.setDefault(ap.getDefault());
            }
        }
        if (v2Parameter.getRequired()) {
            v3Parameter.setRequired(Boolean.valueOf(v2Parameter.getRequired()));
        }
        v3Parameter.setSchema(schema);
        v3Parameter.setExtensions(this.convert(v2Parameter.getVendorExtensions()));
        return v3Parameter;
    }

    public Schema convert(Model v2Model) {
        Object nullableExtension;
        Schema result;
        if (v2Model == null) {
            return null;
        }
        if (v2Model instanceof ArrayModel) {
            ArraySchema arraySchema = (ArraySchema)Json.mapper().convertValue((Object)v2Model, ArraySchema.class);
            arraySchema.setItems(this.convert(((ArrayModel)v2Model).getItems()));
            result = arraySchema;
        } else if (v2Model instanceof ComposedModel) {
            ComposedModel composedModel = (ComposedModel)v2Model;
            ComposedSchema composed = new ComposedSchema();
            composed.setDescription(composedModel.getDescription());
            composed.setExample(composedModel.getExample());
            if (composedModel.getExternalDocs() != null) {
                composed.setExternalDocs(this.convert(composedModel.getExternalDocs()));
            }
            composed.setTitle(composedModel.getTitle());
            composed.setExtensions(this.convert(composedModel.getVendorExtensions()));
            composed.setAllOf(composedModel.getAllOf().stream().map(this::convert).collect(Collectors.toList()));
            result = composed;
        } else {
            RefModel ref;
            ModelImpl model;
            String v2discriminator = null;
            if (v2Model instanceof ModelImpl) {
                model = (ModelImpl)v2Model;
                v2discriminator = model.getDiscriminator();
                model.setDiscriminator(null);
            }
            result = (Schema)Json.mapper().convertValue((Object)v2Model, Schema.class);
            if (v2Model.getProperties() != null && v2Model.getProperties().size() > 0) {
                Map properties = v2Model.getProperties();
                properties.forEach((k, v) -> result.addProperties(k, this.convert((Property)v)));
            }
            if (v2Model instanceof ModelImpl) {
                model = (ModelImpl)v2Model;
                if (model.getAdditionalProperties() != null) {
                    result.setAdditionalProperties((Object)this.convert(model.getAdditionalProperties()));
                }
            } else if (v2Model instanceof RefModel && (ref = (RefModel)v2Model).get$ref().indexOf("#/definitions") == 0) {
                String updatedRef = "#/components/schemas" + ref.get$ref().substring("#/definitions".length());
                result.set$ref(updatedRef);
            }
            if (v2discriminator != null) {
                Discriminator discriminator = new Discriminator();
                discriminator.setPropertyName(v2discriminator);
                result.setDiscriminator(discriminator);
            }
        }
        if (v2Model.getVendorExtensions() != null && (nullableExtension = v2Model.getVendorExtensions().get("x-nullable")) != null) {
            result.setNullable((Boolean)nullableExtension);
        }
        return result;
    }
}

