/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.ignore.rules;

import io.swagger.codegen.v3.ignore.rules.DirectoryRule;
import io.swagger.codegen.v3.ignore.rules.FileRule;
import io.swagger.codegen.v3.ignore.rules.IgnoreLineParser;
import io.swagger.codegen.v3.ignore.rules.InvalidRule;
import io.swagger.codegen.v3.ignore.rules.ParserException;
import io.swagger.codegen.v3.ignore.rules.Part;
import io.swagger.codegen.v3.ignore.rules.RootedFileRule;
import java.util.List;

public abstract class Rule {
    private final String definition;
    private final List<Part> syntax;

    Rule(List<Part> syntax, String definition) {
        this.syntax = syntax;
        this.definition = definition;
    }

    public abstract Boolean matches(String var1);

    public String getDefinition() {
        return this.definition;
    }

    protected String getPattern() {
        if (this.syntax == null) {
            return this.definition;
        }
        StringBuilder sb = new StringBuilder();
        for (Part current : this.syntax) {
            switch (current.getToken()) {
                case MATCH_ALL: 
                case MATCH_ANY: 
                case ESCAPED_EXCLAMATION: 
                case ESCAPED_SPACE: 
                case PATH_DELIM: 
                case TEXT: 
                case DIRECTORY_MARKER: {
                    sb.append(current.getValue());
                    break;
                }
            }
        }
        return sb.toString();
    }

    public Boolean getNegated() {
        return this.syntax != null && this.syntax.size() > 0 && this.syntax.get(0).getToken() == IgnoreLineParser.Token.NEGATE;
    }

    public Operation evaluate(String relativePath) {
        if (Boolean.TRUE.equals(this.matches(relativePath))) {
            if (Boolean.TRUE.equals(this.getNegated())) {
                return this.getIncludeOperation();
            }
            return this.getExcludeOperation();
        }
        return Operation.NOOP;
    }

    protected Operation getIncludeOperation() {
        return Operation.INCLUDE;
    }

    protected Operation getExcludeOperation() {
        return Operation.EXCLUDE;
    }

    public static Rule create(String definition) {
        Rule rule = null;
        if (definition.equals(".")) {
            return new InvalidRule(null, definition, "Pattern '.' is invalid.");
        }
        if (definition.equals("!.")) {
            return new InvalidRule(null, definition, "Pattern '!.' is invalid.");
        }
        if (definition.startsWith("..")) {
            return new InvalidRule(null, definition, "Pattern '..' is invalid.");
        }
        try {
            List<Part> result = IgnoreLineParser.parse(definition);
            Boolean directoryOnly = null;
            if (result.size() == 0) {
                return rule;
            }
            if (result.size() == 1) {
                Part part = result.get(0);
                rule = IgnoreLineParser.Token.MATCH_ANY.equals((Object)part.getToken()) ? new RootedFileRule(result, definition) : new FileRule(result, definition);
            } else {
                IgnoreLineParser.Token head = result.get(0).getToken();
                directoryOnly = IgnoreLineParser.Token.DIRECTORY_MARKER.equals((Object)result.get(result.size() - 1).getToken());
                rule = directoryOnly.booleanValue() ? new DirectoryRule(result, definition) : (IgnoreLineParser.Token.PATH_DELIM.equals((Object)head) ? new RootedFileRule(result, definition) : new FileRule(result, definition));
            }
        }
        catch (ParserException e) {
            e.printStackTrace();
            return new InvalidRule(null, definition, e.getMessage());
        }
        return rule;
    }

    public static enum Operation {
        EXCLUDE,
        INCLUDE,
        NOOP,
        EXCLUDE_AND_TERMINATE;

    }
}

