/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.templates;

import com.github.jknack.handlebars.io.FileTemplateLoader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang3.StringUtils;

public class CodegenTemplateLoader
extends FileTemplateLoader {
    private String templateDir;
    private String customTemplateDir;

    public CodegenTemplateLoader(String templateDir, String suffix) {
        super(templateDir, suffix);
        this.templateDir = templateDir;
    }

    public URL getResource(String location) throws IOException {
        if (this.customTemplateDir == null) {
            return ((Object)((Object)this)).getClass().getResource(location);
        }
        String templateFile = this.resolveTemplateFile(this.templateDir, location);
        File file = new File(this.customTemplateDir, templateFile = this.resolveTemplateFile(this.customTemplateDir, templateFile));
        if (file.exists()) {
            return file.toURI().toURL();
        }
        return ((Object)((Object)this)).getClass().getResource(location);
    }

    private String resolveTemplateFile(String templateDir, String templateFile) {
        if (templateFile.startsWith(templateDir)) {
            templateFile = StringUtils.replaceOnce((String)templateFile, (String)templateDir, (String)"");
        }
        return templateFile;
    }

    public String getCustomTemplateDir() {
        return this.customTemplateDir;
    }

    public void setCustomTemplateDir(String customTemplateDir) {
        this.customTemplateDir = customTemplateDir;
    }

    public CodegenTemplateLoader customTemplateDir(String customTemplateDir) {
        this.customTemplateDir = customTemplateDir;
        return this;
    }
}

