/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators;

import io.swagger.codegen.v3.CodegenModel;
import io.swagger.codegen.v3.CodegenModelFactory;
import io.swagger.codegen.v3.CodegenModelType;
import io.swagger.codegen.v3.CodegenProperty;
import io.swagger.codegen.v3.generators.DefaultCodegenConfig;
import io.swagger.codegen.v3.generators.util.OpenAPIUtil;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.List;

public class SchemaHandler {
    private DefaultCodegenConfig codegenConfig;

    public SchemaHandler(DefaultCodegenConfig codegenConfig) {
        this.codegenConfig = codegenConfig;
    }

    public void createCodegenModel(ComposedSchema composedProperty, CodegenProperty codegenProperty) {
        List oneOf = composedProperty.getOneOf();
        List anyOf = composedProperty.getAnyOf();
        if (oneOf != null && !oneOf.isEmpty()) {
            CodegenModel oneOfModel = this.createFromOneOfSchemas(oneOf);
            codegenProperty.vendorExtensions.put("oneOf-model", oneOfModel);
        }
        if (anyOf != null && !anyOf.isEmpty()) {
            CodegenModel anyOfModel = this.createFromOneOfSchemas(anyOf);
            codegenProperty.vendorExtensions.put("anyOf-model", anyOfModel);
        }
    }

    public void configureOneOfModel(CodegenModel codegenModel, List<Schema> oneOf) {
        String oneOfModelName = "OneOf" + codegenModel.name;
        CodegenModel oneOfModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        oneOfModel.name = oneOfModelName;
        oneOfModel.classname = this.codegenConfig.toModelName(oneOfModelName);
        oneOfModel.classVarName = this.codegenConfig.toVarName(oneOfModelName);
        oneOfModel.classFilename = this.codegenConfig.toModelFilename(oneOfModelName);
        oneOfModel.vendorExtensions.put("x-is-composed-model", Boolean.TRUE);
        ArrayList<String> modelNames = new ArrayList<String>();
        for (Schema interfaceSchema : oneOf) {
            String schemaName = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
            modelNames.add(this.codegenConfig.toModelName(schemaName));
        }
        oneOfModel.vendorExtensions.put("x-model-names", modelNames);
        codegenModel.vendorExtensions.put("oneOf-model", oneOfModel);
        if (codegenModel.interfaceModels == null) {
            codegenModel.interfaceModels = new ArrayList();
        }
        codegenModel.interfaceModels.add(oneOfModel);
    }

    public void configureAnyOfModel(CodegenModel codegenModel, List<Schema> oneOf) {
        String oneOfModelName = "AnyOf" + codegenModel.name;
        CodegenModel oneOfModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        oneOfModel.name = oneOfModelName;
        oneOfModel.classname = this.codegenConfig.toModelName(oneOfModelName);
        oneOfModel.classVarName = this.codegenConfig.toVarName(oneOfModelName);
        oneOfModel.classFilename = this.codegenConfig.toModelFilename(oneOfModelName);
        oneOfModel.vendorExtensions.put("x-is-composed-model", Boolean.TRUE);
        ArrayList<String> modelNames = new ArrayList<String>();
        for (Schema interfaceSchema : oneOf) {
            String schemaName = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
            modelNames.add(this.codegenConfig.toModelName(schemaName));
        }
        oneOfModel.vendorExtensions.put("x-model-names", modelNames);
        codegenModel.vendorExtensions.put("anyOf-model", oneOfModel);
        if (codegenModel.interfaceModels == null) {
            codegenModel.interfaceModels = new ArrayList();
        }
        codegenModel.interfaceModels.add(oneOfModel);
    }

    public void configureOneOfModelFromProperty(CodegenProperty codegenProperty, CodegenModel codegenModel) {
        String name = "OneOf" + this.codegenConfig.toModelName(codegenModel.name);
        name = name + this.codegenConfig.toModelName(codegenProperty.name);
        CodegenModel oneOfModel = (CodegenModel)codegenProperty.vendorExtensions.get("oneOf-model");
        oneOfModel.name = name;
        oneOfModel.classname = this.codegenConfig.toModelName(name);
        oneOfModel.classVarName = this.codegenConfig.toVarName(name);
        oneOfModel.classFilename = this.codegenConfig.toModelFilename(name);
        oneOfModel.vendorExtensions.put("x-is-composed-model", Boolean.TRUE);
        codegenProperty.vendorExtensions.remove("oneOf-model");
        codegenProperty.datatype = name;
        codegenProperty.datatypeWithEnum = name;
        codegenProperty.baseType = name;
        codegenModel.vendorExtensions.put("oneOf-model", oneOfModel);
    }

    public void configureAnyOfModelFromProperty(CodegenProperty codegenProperty, CodegenModel codegenModel) {
        String name = "AnyOf" + this.codegenConfig.toModelName(codegenModel.name);
        name = name + this.codegenConfig.toModelName(codegenProperty.name);
        CodegenModel anyOfModel = (CodegenModel)codegenProperty.vendorExtensions.get("anyOf-model");
        anyOfModel.name = name;
        anyOfModel.classname = this.codegenConfig.toModelName(name);
        anyOfModel.classVarName = this.codegenConfig.toVarName(name);
        anyOfModel.classFilename = this.codegenConfig.toModelFilename(name);
        anyOfModel.vendorExtensions.put("x-is-composed-model", Boolean.TRUE);
        codegenProperty.vendorExtensions.remove("anyOf-model");
        codegenProperty.datatype = name;
        codegenProperty.datatypeWithEnum = name;
        codegenProperty.baseType = name;
        codegenModel.vendorExtensions.put("anyOf-model", anyOfModel);
    }

    public void configureAnyOfModelFromProperty() {
    }

    private CodegenModel createFromOneOfSchemas(List<Schema> schemas) {
        CodegenModel codegenModel = (CodegenModel)CodegenModelFactory.newInstance((CodegenModelType)CodegenModelType.MODEL);
        ArrayList<String> modelNames = new ArrayList<String>();
        for (Schema interfaceSchema : schemas) {
            String schemaName = OpenAPIUtil.getSimpleRef(interfaceSchema.get$ref());
            modelNames.add(this.codegenConfig.toModelName(schemaName));
        }
        codegenModel.vendorExtensions.put("x-model-names", modelNames);
        return codegenModel;
    }
}

