/*
 * Decompiled with CFR 0.152.
 */
package io.swagger.codegen.v3.generators.dotnet;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.samskivert.mustache.Mustache;
import io.swagger.codegen.v3.CodegenOperation;
import io.swagger.codegen.v3.CodegenSecurity;
import io.swagger.codegen.v3.CodegenType;
import io.swagger.codegen.v3.SupportingFile;
import io.swagger.codegen.v3.VendorExtendable;
import io.swagger.codegen.v3.generators.dotnet.AbstractCSharpCodegen;
import io.swagger.codegen.v3.generators.handlebars.ExtensionHelper;
import io.swagger.codegen.v3.utils.SemVer;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.security.SecurityScheme;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspNetCoreServerCodegen
extends AbstractCSharpCodegen {
    private String packageGuid = "{" + UUID.randomUUID().toString().toUpperCase() + "}";
    private static final String ASP_NET_CORE_VERSION_OPTION = "--aspnet-core-version";
    private static final String INTERFACE_ONLY_OPTION = "--interface-only";
    private static final String INTERFACE_CONTROLLER_OPTION = "--interface-controller";
    private static final String SWASH_BUCKLE_VERSION_OPTION = "swashBuckleVersion";
    private static final String TARGET_FRAMEWORK = "targetFramework";
    private final String DEFAULT_ASP_NET_CORE_VERSION = "7.0";
    private String aspNetCoreVersion;
    protected Logger LOGGER = LoggerFactory.getLogger(AspNetCoreServerCodegen.class);

    public AspNetCoreServerCodegen() {
        this.setSourceFolder("src");
        this.outputFolder = "generated-code" + File.separator + this.getName();
        this.reservedWords.addAll(Arrays.asList("var", "async", "await", "dynamic", "yield"));
        this.cliOptions.clear();
        this.addOption("packageName", "C# package name (convention: Title.Case).", this.packageName);
        this.addOption("packageVersion", "C# package version.", this.packageVersion);
        this.addOption("packageGuid", "The GUID that will be associated with the C# project", null);
        this.addOption("sourceFolder", "source folder for generated code", this.sourceFolder);
        this.addOption("preserveNewlinesInComments", "Preserve newlines in comments", String.valueOf(this.preserveNewLines));
        this.addSwitch("sortParamsByRequiredFlag", "Sort method arguments to place required parameters before optional parameters.", this.sortParamsByRequiredFlag);
        this.addSwitch("useDateTimeOffset", "Use DateTimeOffset to model date-time properties", this.useDateTimeOffsetFlag);
        this.addSwitch("useCollection", "Deserialize array types to Collection<T> instead of List<T>.", this.useCollection);
        this.addSwitch("returnICollection", "Return ICollection<T> instead of the concrete type.", this.returnICollection);
        this.aspNetCoreVersion = "7.0";
        this.addSwitch(INTERFACE_ONLY_OPTION.substring(2), "Only generate interfaces for controllers", false);
        this.addSwitch(INTERFACE_CONTROLLER_OPTION.substring(2), "Generate interfaces for controllers, implemented by a default controller implementation", false);
        this.addOption(ASP_NET_CORE_VERSION_OPTION.substring(2), "ASP.NET Core version", "7.0");
    }

    public CodegenType getTag() {
        return CodegenType.SERVER;
    }

    public String getName() {
        return "aspnetcore";
    }

    public String getHelp() {
        return "Generates an ASP.NET Core Web API server.";
    }

    @Override
    public void processOpts() {
        super.processOpts();
        this.setAspNetCoreVersion();
        this.modelTemplateFiles.put("model.mustache", ".cs");
        if (this.additionalProperties.containsKey("packageGuid")) {
            this.setPackageGuid((String)this.additionalProperties.get("packageGuid"));
        }
        this.additionalProperties.put("packageGuid", this.packageGuid);
        this.additionalProperties.put("dockerTag", this.packageName.toLowerCase());
        this.additionalProperties.put("aspNetCoreVersion", this.aspNetCoreVersion);
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        boolean isThreeDotOneVersion = this.aspNetCoreVersion.equals("3.1");
        if (this.aspNetCoreVersion.equals("2.0")) {
            this.apiTemplateFiles.put("controller.mustache", ".cs");
            this.addInterfaceControllerTemplate();
            this.supportingFiles.add(new SupportingFile("Program.mustache", packageFolder, "Program.cs"));
            this.supportingFiles.add(new SupportingFile("Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
            this.supportingFiles.add(new SupportingFile("Dockerfile.mustache", packageFolder, "Dockerfile"));
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "BasePathFilter.mustache", packageFolder + File.separator + "Filters", "BasePathFilter.cs"));
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "GeneratePathParamsValidationFilter.mustache", packageFolder + File.separator + "Filters", "GeneratePathParamsValidationFilter.cs"));
            this.supportingFiles.add(new SupportingFile("Startup.mustache", packageFolder, "Startup.cs"));
        } else if (this.aspNetCoreVersion.equals("2.1") || this.aspNetCoreVersion.equals("2.2")) {
            this.apiTemplateFiles.put("2.1/controller.mustache", ".cs");
            this.addInterfaceControllerTemplate();
            this.supportingFiles.add(new SupportingFile("2.1/Program.mustache", packageFolder, "Program.cs"));
            this.supportingFiles.add(new SupportingFile("2.1/Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
            this.supportingFiles.add(new SupportingFile("2.1/Dockerfile.mustache", packageFolder, "Dockerfile"));
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "BasePathFilter.mustache", packageFolder + File.separator + "Filters", "BasePathFilter.cs"));
            this.supportingFiles.add(new SupportingFile("Filters" + File.separator + "GeneratePathParamsValidationFilter.mustache", packageFolder + File.separator + "Filters", "GeneratePathParamsValidationFilter.cs"));
            this.supportingFiles.add(new SupportingFile("Startup.mustache", packageFolder, "Startup.cs"));
        } else {
            SemVer semVer = new SemVer(this.aspNetCoreVersion);
            this.apiTemplateFiles.put("3.0/controller.mustache", ".cs");
            this.addInterfaceControllerTemplate();
            this.supportingFiles.add(new SupportingFile("3.0" + File.separator + "Filters" + File.separator + "BasePathFilter.mustache", packageFolder + File.separator + "Filters", "BasePathFilter.cs"));
            this.supportingFiles.add(new SupportingFile("3.0" + File.separator + "Filters" + File.separator + "GeneratePathParamsValidationFilter.mustache", packageFolder + File.separator + "Filters", "GeneratePathParamsValidationFilter.cs"));
            this.supportingFiles.add(new SupportingFile("3.0/Startup.mustache", packageFolder, "Startup.cs"));
            this.supportingFiles.add(new SupportingFile("3.0/Program.mustache", packageFolder, "Program.cs"));
            if (semVer.atLeast("5.0")) {
                this.additionalProperties.put(SWASH_BUCKLE_VERSION_OPTION, "6.4.0");
                this.supportingFiles.add(new SupportingFile("3.1/Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
            }
            if (semVer.atLeast("7.0")) {
                this.additionalProperties.put(TARGET_FRAMEWORK, "net7.0");
            } else if (semVer.atLeast("6.0")) {
                this.additionalProperties.put(TARGET_FRAMEWORK, "net6.0");
            } else if (semVer.atLeast("5.0")) {
                this.additionalProperties.put(TARGET_FRAMEWORK, "net5.0");
            } else if (semVer.atLeast("3.1")) {
                this.additionalProperties.put(SWASH_BUCKLE_VERSION_OPTION, "5.5.1");
                this.additionalProperties.put(TARGET_FRAMEWORK, "netcoreapp3.1");
                this.supportingFiles.add(new SupportingFile("3.1/Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
            } else {
                this.supportingFiles.add(new SupportingFile("3.0/Project.csproj.mustache", packageFolder, this.packageName + ".csproj"));
            }
            this.supportingFiles.add(new SupportingFile("3.0/Dockerfile.mustache", packageFolder, "Dockerfile"));
        }
        if (!this.additionalProperties.containsKey("apiPackage")) {
            this.apiPackage = this.packageName + ".Controllers";
            this.additionalProperties.put("apiPackage", this.apiPackage);
        }
        if (!this.additionalProperties.containsKey("modelPackage")) {
            this.modelPackage = this.packageName + ".Models";
            this.additionalProperties.put("modelPackage", this.modelPackage);
        }
        this.supportingFiles.add(new SupportingFile("NuGet.Config", "", "NuGet.Config"));
        this.supportingFiles.add(new SupportingFile("build.sh.mustache", "", "build.sh"));
        this.supportingFiles.add(new SupportingFile("build.bat.mustache", "", "build.bat"));
        this.supportingFiles.add(new SupportingFile("README.mustache", "", "README.md"));
        this.supportingFiles.add(new SupportingFile("Solution.mustache", "", this.packageName + ".sln"));
        this.supportingFiles.add(new SupportingFile("gitignore", packageFolder, ".gitignore"));
        this.supportingFiles.add(new SupportingFile("appsettings.json", packageFolder, "appsettings.json"));
        this.supportingFiles.add(new SupportingFile("validateModel.mustache", packageFolder + File.separator + "Attributes", "ValidateModelStateAttribute.cs"));
        this.supportingFiles.add(new SupportingFile("web.config", packageFolder, "web.config"));
        if (isThreeDotOneVersion) {
            this.supportingFiles.add(new SupportingFile("3.1/Properties" + File.separator + "launchSettings.json", packageFolder + File.separator + "Properties", "launchSettings.json"));
        } else {
            this.supportingFiles.add(new SupportingFile("Properties" + File.separator + "launchSettings.json", packageFolder + File.separator + "Properties", "launchSettings.json"));
        }
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "README.md", packageFolder + File.separator + "wwwroot", "README.md"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "index.html", packageFolder + File.separator + "wwwroot", "index.html"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "web.config", packageFolder + File.separator + "wwwroot", "web.config"));
        this.supportingFiles.add(new SupportingFile("wwwroot" + File.separator + "swagger-original.mustache", packageFolder + File.separator + "wwwroot", "swagger-original.json"));
    }

    @Override
    public void setSourceFolder(String sourceFolder) {
        if (sourceFolder == null) {
            this.LOGGER.warn("No sourceFolder specified, using default");
            this.sourceFolder = "src" + File.separator + this.packageName;
        } else if (!sourceFolder.equals("src") && !sourceFolder.startsWith("src")) {
            this.LOGGER.warn("ASP.NET Core requires source code exists under src. Adjusting.");
            this.sourceFolder = "src" + File.separator + sourceFolder;
        } else {
            this.sourceFolder = sourceFolder;
        }
    }

    public void setPackageGuid(String packageGuid) {
        this.packageGuid = packageGuid;
    }

    @Override
    public String apiFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Controllers";
    }

    @Override
    public String apiFilename(String templateName, String tag) {
        boolean isInterface = templateName.equalsIgnoreCase("icontroller.mustache");
        String suffix = this.apiTemplateFiles().get(templateName);
        if (isInterface) {
            return this.apiFileFolder() + "/I" + this.toApiFilename(tag) + suffix;
        }
        return this.apiFileFolder() + '/' + this.toApiFilename(tag) + suffix;
    }

    @Override
    public String modelFileFolder() {
        return this.outputFolder + File.separator + this.sourceFolder + File.separator + this.packageName + File.separator + "Models";
    }

    @Override
    public Map<String, Object> postProcessSupportingFileData(Map<String, Object> objs) {
        OpenAPI openAPI = (OpenAPI)objs.get("openAPI");
        if (openAPI != null) {
            try {
                objs.put("swagger-json", Json.pretty().writeValueAsString((Object)openAPI).replace("\r\n", "\n"));
            }
            catch (JsonProcessingException e) {
                this.LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return super.postProcessSupportingFileData(objs);
    }

    @Override
    protected void processOperation(CodegenOperation operation) {
        super.processOperation(operation);
        if (operation.path != null) {
            String original = operation.path;
            operation.path = operation.path.replace("?", "/");
            if (!original.equals(operation.path)) {
                this.LOGGER.warn("Normalized " + original + " to " + operation.path + ". Please verify generated source.");
            }
        }
        operation.httpMethod = "Http" + operation.httpMethod.substring(0, 1) + operation.httpMethod.substring(1).toLowerCase();
        if (operation.getContents() != null && !operation.getContents().isEmpty()) {
            List contents = operation.getContents().stream().filter(codegenContent -> !codegenContent.getIsForm()).collect(Collectors.toList());
            operation.getContents().clear();
            operation.getContents().addAll(contents);
        }
    }

    @Override
    public Mustache.Compiler processCompiler(Mustache.Compiler compiler) {
        return super.processCompiler(compiler).emptyStringIsFalse(true);
    }

    @Override
    public List<CodegenSecurity> fromSecurity(Map<String, SecurityScheme> securitySchemeMap) {
        List<CodegenSecurity> securities = super.fromSecurity(securitySchemeMap);
        if (securities == null || securities.isEmpty()) {
            return securities;
        }
        boolean hasBasic = false;
        boolean hasBearer = false;
        boolean hasApiKey = false;
        for (int index = 0; index < securities.size(); ++index) {
            CodegenSecurity codegenSecurity = securities.get(index);
            if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenSecurity, "x-is-basic")) {
                hasBasic = true;
            }
            if (ExtensionHelper.getBooleanValue((VendorExtendable)codegenSecurity, "x-is-bearer")) {
                hasBearer = true;
            }
            if (!ExtensionHelper.getBooleanValue((VendorExtendable)codegenSecurity, "x-is-api-key")) continue;
            hasApiKey = true;
        }
        String packageFolder = this.sourceFolder + File.separator + this.packageName;
        if (hasBasic) {
            this.supportingFiles.add(new SupportingFile("Security/BasicAuthenticationHandler.mustache", packageFolder + File.separator + "Security", "BasicAuthenticationHandler.cs"));
        }
        if (hasBearer) {
            this.supportingFiles.add(new SupportingFile("Security/BearerAuthenticationHandler.mustache", packageFolder + File.separator + "Security", "BearerAuthenticationHandler.cs"));
        }
        if (hasApiKey) {
            this.supportingFiles.add(new SupportingFile("Security/ApiKeyAuthenticationHandler.mustache", packageFolder + File.separator + "Security", "ApiKeyAuthenticationHandler.cs"));
        }
        return securities;
    }

    private void addInterfaceControllerTemplate() {
        String interfaceOnlyOption = this.getOptionValue(INTERFACE_ONLY_OPTION);
        boolean interfaceOnly = false;
        if (StringUtils.isNotBlank((CharSequence)interfaceOnlyOption)) {
            interfaceOnly = Boolean.valueOf(this.getOptionValue(INTERFACE_ONLY_OPTION));
        } else if (this.additionalProperties.get(INTERFACE_ONLY_OPTION.substring(2)) != null) {
            interfaceOnly = Boolean.valueOf(this.additionalProperties.get(INTERFACE_ONLY_OPTION.substring(2)).toString());
        }
        String interfaceControllerOption = this.getOptionValue(INTERFACE_CONTROLLER_OPTION);
        boolean interfaceController = false;
        if (StringUtils.isNotBlank((CharSequence)interfaceControllerOption)) {
            interfaceController = Boolean.valueOf(this.getOptionValue(INTERFACE_CONTROLLER_OPTION));
        } else if (this.additionalProperties.get(INTERFACE_CONTROLLER_OPTION.substring(2)) != null) {
            interfaceController = Boolean.valueOf(this.additionalProperties.get(INTERFACE_CONTROLLER_OPTION.substring(2)).toString());
        }
        if (interfaceController) {
            this.apiTemplateFiles.put("icontroller.mustache", ".cs");
            this.additionalProperties.put("interfaceController", Boolean.TRUE);
        }
        if (interfaceOnly) {
            this.apiTemplateFiles.clear();
            this.apiTemplateFiles.put("icontroller.mustache", ".cs");
        }
    }

    @Override
    public String getArgumentsLocation() {
        return "/arguments/aspnetcore.yaml";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setAspNetCoreVersion() {
        String optionValue = this.getOptionValue(ASP_NET_CORE_VERSION_OPTION);
        if (StringUtils.isBlank((CharSequence)optionValue)) {
            if (this.additionalProperties.get(ASP_NET_CORE_VERSION_OPTION.substring(2)) == null) return;
            this.aspNetCoreVersion = this.additionalProperties.get(ASP_NET_CORE_VERSION_OPTION.substring(2)).toString();
        } else {
            this.aspNetCoreVersion = optionValue;
        }
        SemVer semVer = new SemVer(this.aspNetCoreVersion);
        if (semVer.compareTo(new SemVer("2.0")) >= 0) return;
        this.LOGGER.error("version '" + this.aspNetCoreVersion + "' is not supported, switching to default version: '" + "7.0" + "'");
        this.aspNetCoreVersion = "7.0";
    }
}

