/*
 * Decompiled with CFR 0.152.
 */
package io.sundr.adapter.reflect;

import io.sundr.model.ClassRef;
import io.sundr.model.ClassRefBuilder;
import io.sundr.model.PrimitiveRefBuilder;
import io.sundr.model.TypeParamRefBuilder;
import io.sundr.model.TypeRef;
import io.sundr.model.VoidRefBuilder;
import io.sundr.model.WildcardRefBuilder;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class TypeToTypeRef
implements Function<Type, TypeRef> {
    private final Set<Class> references;

    public TypeToTypeRef(Set<Class> references) {
        this.references = references;
    }

    @Override
    public TypeRef apply(Type item) {
        if (item == null) {
            return new VoidRefBuilder().build();
        }
        if (item instanceof WildcardType) {
            return ((WildcardRefBuilder)new WildcardRefBuilder().withBounds(Arrays.asList(((WildcardType)item).getLowerBounds()).stream().map(t -> this.apply((Type)t)).collect(Collectors.toList()))).build();
        }
        if (item instanceof TypeVariable) {
            return ((TypeParamRefBuilder)new TypeParamRefBuilder().withName(((TypeVariable)item).getName())).build();
        }
        if (item instanceof GenericArrayType) {
            Type target = item;
            int dimensions = 0;
            while (target instanceof GenericArrayType) {
                target = ((GenericArrayType)target).getGenericComponentType();
                ++dimensions;
            }
            if (target instanceof Class) {
                this.references.add((Class)target);
            }
            TypeRef targetRef = this.apply(target);
            return targetRef.withDimensions(dimensions + targetRef.getDimensions());
        }
        if (item instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)item;
            Type rawType = parameterizedType.getRawType();
            ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
            for (Type arg : parameterizedType.getActualTypeArguments()) {
                arguments.add(this.apply(arg));
                if (!(arg instanceof Class)) continue;
                this.references.add((Class)arg);
            }
            if (rawType instanceof Class) {
                this.references.add((Class)rawType);
            }
            return ((ClassRefBuilder)new ClassRefBuilder((ClassRef)this.apply(rawType)).withArguments(arguments)).build();
        }
        if (Object.class.equals((Object)item)) {
            return ClassRef.OBJECT;
        }
        if (item instanceof Class) {
            Class<?> c = (Class<?>)item;
            if (c.isArray()) {
                Class<?> target = c;
                int dimensions = 0;
                while (target.isArray()) {
                    target = target.getComponentType();
                    ++dimensions;
                }
                TypeRef targetRef = this.apply(target);
                this.references.add(target);
                return targetRef.withDimensions(dimensions + targetRef.getDimensions());
            }
            if (c.isPrimitive()) {
                return ((PrimitiveRefBuilder)((PrimitiveRefBuilder)new PrimitiveRefBuilder().withName(c.getName())).withDimensions(0)).build();
            }
            ArrayList<TypeRef> arguments = new ArrayList<TypeRef>();
            for (TypeVariable v : c.getTypeParameters()) {
                arguments.add(this.apply(v));
            }
            this.references.add((Class)item);
            String fqcn = c.getName().replaceAll(Pattern.quote("$"), ".");
            return ((ClassRefBuilder)((ClassRefBuilder)new ClassRefBuilder().withFullyQualifiedName(fqcn)).withArguments(arguments)).build();
        }
        throw new IllegalArgumentException("Can't convert type:" + item + " to a TypeRef");
    }
}

