/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.fs.FileSystemMonitor;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.connector.ConnectorContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemMonitorThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(FileSystemMonitorThread.class);
    private final ConnectorContext context;
    private final CountDownLatch shutdownLatch;
    private final CountDownLatch waitingLatch;
    private final long scanIntervalMs;
    private final FileSystemMonitor monitor;

    FileSystemMonitorThread(ConnectorContext context, FileSystemMonitor monitor, long scanIntervalMs) {
        super(FileSystemMonitorThread.class.getSimpleName());
        Objects.requireNonNull(context, "context can't be null");
        Objects.requireNonNull(monitor, "monitor can't be null");
        if (scanIntervalMs < 0L) {
            throw new IllegalArgumentException("Invalid Argument - scanInternalMs cannot be inferior to 0");
        }
        this.context = context;
        this.monitor = monitor;
        this.scanIntervalMs = scanIntervalMs;
        this.shutdownLatch = new CountDownLatch(1);
        this.waitingLatch = new CountDownLatch(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            LOG.info("Starting filesystem monitoring thread (scanIntervalMs={}", (Object)this.scanIntervalMs);
            while (this.shutdownLatch.getCount() > 0L) {
                long started = Time.SYSTEM.milliseconds();
                try {
                    this.monitor.invoke(this.context);
                    LOG.info("Completed filesystem monitoring iteration in {} ms", (Object)(Time.SYSTEM.milliseconds() - started));
                }
                catch (Exception e) {
                    LOG.error("Unexpected error while monitoring filesystem.", (Throwable)e);
                    this.context.raiseError(e);
                    throw e;
                }
                long timeout = Math.max(0L, this.scanIntervalMs - (Time.SYSTEM.milliseconds() - started));
                if (timeout <= 0L) continue;
                LOG.debug("Waiting {} ms before next filesystem monitoring iteration.", (Object)timeout);
                boolean shuttingDown = this.shutdownLatch.await(timeout, TimeUnit.MILLISECONDS);
                if (!shuttingDown) continue;
                return;
            }
        }
        catch (InterruptedException e) {
            LOG.error("Unexpected InterruptedException, ignoring: ", (Throwable)e);
        }
        finally {
            this.monitor.close();
            LOG.info("Stopped filesystem monitoring thread.");
            this.waitingLatch.countDown();
        }
    }

    void shutdown(long timeoutMs) {
        LOG.info("Shutting down thread monitoring filesystem.");
        this.shutdownLatch.countDown();
        try {
            this.waitingLatch.await(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ignore) {
            LOG.error("Timeout : scan loop is not terminated yet.");
        }
    }
}

