/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.source;

import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.TaskPartitioner;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.kafka.connect.util.ConnectorUtils;

public class DefaultTaskPartitioner
implements TaskPartitioner {
    public List<List<URI>> partition(Collection<FileObjectMeta> files, int taskCount) {
        if (files.isEmpty()) {
            return Collections.emptyList();
        }
        int numGroups = Math.min(files.size(), taskCount);
        return ConnectorUtils.groupPartitions(new ArrayList<FileObjectMeta>(files), (int)numGroups).stream().map(this::toURIs).collect(Collectors.toList());
    }

    private List<URI> toURIs(List<FileObjectMeta> items) {
        return items.stream().map(FileObjectMeta::uri).collect(Collectors.toList());
    }
}

