/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.fs.filter;

import io.streamthoughts.kafka.connect.filepulse.fs.PredicateFileListFilter;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.kafka.common.config.AbstractConfig;
import org.apache.kafka.common.config.ConfigDef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastModifiedFileListFilter
extends PredicateFileListFilter {
    private static final String GROUP = "LastModifiedFileListFilter";
    private static final Logger LOG = LoggerFactory.getLogger(LastModifiedFileListFilter.class);
    public static final String FILE_MINIMUM_AGE_MS_CONFIG = "file.filter.minimum.age.ms";
    private static final String FILE_MINIMUM_AGE_MS_DOC = "The minimum age in milliseconds of a file to be eligible for processing.";
    private static final long FILE_MINIMUM_AGE_MS_DEFAULT = 0L;
    public static final String FILE_MAXIMUM_AGE_MS_CONFIG = "file.filter.maximum.age.ms";
    private static final String FILE_MAXIMUM_AGE_MS_DOC = "The maximum age in milliseconds of a file to be eligible for processing.";
    private static final long FILE_MAXIMUM_AGE_MS_DEFAULT = Long.MAX_VALUE;
    private Predicate<FileObjectMeta> minimumAgePredicate;
    private Predicate<FileObjectMeta> maximumAgePredicate;

    public void configure(Map<String, ?> props) {
        AbstractConfig abstractConfig = new AbstractConfig(LastModifiedFileListFilter.getConfigDef(), props);
        Long minimumAgeMs = abstractConfig.getLong(FILE_MINIMUM_AGE_MS_CONFIG);
        this.minimumAgePredicate = it -> Math.max(0L, System.currentTimeMillis() - it.lastModified()) > minimumAgeMs;
        Long maximumAgeMs = abstractConfig.getLong(FILE_MAXIMUM_AGE_MS_CONFIG);
        this.maximumAgePredicate = it -> Math.max(0L, System.currentTimeMillis() - it.lastModified()) < maximumAgeMs;
    }

    public boolean test(FileObjectMeta meta) {
        if (!this.minimumAgePredicate.test(meta)) {
            LOG.debug("Filtered '{}'. File do not match minimum age predicate.", (Object)meta);
            return false;
        }
        if (!this.maximumAgePredicate.test(meta)) {
            LOG.debug("Filtered '{}'. File do not match maximum age predicate.", (Object)meta);
            return false;
        }
        return true;
    }

    private static ConfigDef getConfigDef() {
        int groupCounter = 0;
        return new ConfigDef().define(FILE_MINIMUM_AGE_MS_CONFIG, ConfigDef.Type.LONG, (Object)0L, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, FILE_MINIMUM_AGE_MS_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, FILE_MINIMUM_AGE_MS_CONFIG).define(FILE_MAXIMUM_AGE_MS_CONFIG, ConfigDef.Type.LONG, (Object)Long.MAX_VALUE, (ConfigDef.Validator)ConfigDef.Range.atLeast((Number)0), ConfigDef.Importance.HIGH, FILE_MAXIMUM_AGE_MS_DOC, GROUP, groupCounter++, ConfigDef.Width.NONE, FILE_MAXIMUM_AGE_MS_CONFIG);
    }
}

