/*
 * Decompiled with CFR 0.152.
 */
package io.streamthoughts.kafka.connect.filepulse.fs;

import io.streamthoughts.kafka.connect.filepulse.internal.KeyValuePair;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectKey;
import io.streamthoughts.kafka.connect.filepulse.source.FileObjectMeta;
import io.streamthoughts.kafka.connect.filepulse.source.SourceOffsetPolicy;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileObjectCandidatesFilter {
    private static final Logger LOG = LoggerFactory.getLogger(FileObjectCandidatesFilter.class);
    private final SourceOffsetPolicy offsetPolicy;
    private final Predicate<FileObjectKey> predicate;

    public FileObjectCandidatesFilter(SourceOffsetPolicy offsetPolicy, Predicate<FileObjectKey> predicate) {
        this.offsetPolicy = Objects.requireNonNull(offsetPolicy, "'offsetPolicy' should not be null");
        this.predicate = Objects.requireNonNull(predicate, "'snapshot' should not be null");
    }

    public static Map<FileObjectKey, FileObjectMeta> filter(SourceOffsetPolicy offsetPolicy, Predicate<FileObjectKey> predicate, Collection<FileObjectMeta> candidates) {
        return new FileObjectCandidatesFilter(offsetPolicy, predicate).filter(candidates);
    }

    public Map<FileObjectKey, FileObjectMeta> filter(Collection<FileObjectMeta> candidates) {
        List toScheduled = candidates.stream().map(source -> KeyValuePair.of((Object)this.offsetPolicy.toPartitionJson(source), (Object)source)).filter((? super T kv) -> this.predicate.test(FileObjectKey.of((String)((String)kv.key)))).collect(Collectors.toList());
        Stream<Map.Entry> entryStream = toScheduled.stream().collect(Collectors.groupingBy(kv -> (String)kv.key)).entrySet().stream().filter((? super T entry) -> ((List)entry.getValue()).size() > 1);
        Map<String, List> duplicates = entryStream.collect(Collectors.toMap(Map.Entry::getKey, e -> ((List)e.getValue()).stream().map(m -> ((FileObjectMeta)m.value).stringURI()).collect(Collectors.toList())));
        if (!duplicates.isEmpty()) {
            String formatted = duplicates.entrySet().stream().map(e -> "partition_key=" + (String)e.getKey() + ", files=" + e.getValue()).collect(Collectors.joining("\n\t", "\n\t", "\n"));
            LOG.error("Duplicates object files detected. Consider changing the configuration for '{}'. Meanwhile all object files are ignored: {}", (Object)"offset.policy.class", (Object)formatted);
            return Collections.emptyMap();
        }
        return toScheduled.stream().collect(Collectors.toMap(kv -> FileObjectKey.of((String)((String)kv.key)), kv -> (FileObjectMeta)kv.value));
    }
}

