/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ShortBuffer;

public class BaseImageFilter {
    public static final int COORDS_PER_VERTEX = 2;
    public static final int TEXTURE_COORDS_PER_VERTEX = 2;
    private static final int BYTES_PER_SHORT = 2;
    private static final int BYTES_PER_FLOAT = 4;
    private static final short[] DRAW_ORDER = new short[]{0, 1, 2, 0, 2, 3};
    private static final float[] SHAPE_COORDINATE = new float[]{-1.0f, 1.0f, -1.0f, -1.0f, 1.0f, -1.0f, 1.0f, 1.0f};
    private static float[] TEXTURE_COORDINATE = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 1.0f, 1.0f};
    public int mWidth;
    public int mHeight;
    public ShortBuffer mIndicesOrder;
    public FloatBuffer mShapeCoordinate;
    public FloatBuffer mTextureCoordinate;

    private ShortBuffer getIndicesOrder() {
        Object object = DRAW_ORDER;
        ShortBuffer shortBuffer = ByteBuffer.allocateDirect(DRAW_ORDER.length * 2).order(ByteOrder.nativeOrder()).asShortBuffer();
        shortBuffer.put((short[])object);
        shortBuffer.position(0);
        return shortBuffer;
    }

    private FloatBuffer getShapeCoordinate() {
        Object object = SHAPE_COORDINATE;
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(SHAPE_COORDINATE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put((float[])object);
        floatBuffer.position(0);
        return floatBuffer;
    }

    private FloatBuffer getTextureCoordinate() {
        FloatBuffer floatBuffer = ByteBuffer.allocateDirect(TEXTURE_COORDINATE.length * 4).order(ByteOrder.nativeOrder()).asFloatBuffer();
        floatBuffer.put(TEXTURE_COORDINATE);
        floatBuffer.position(0);
        return floatBuffer;
    }

    /*
     * WARNING - void declaration
     */
    public void onInit(int width, int height) {
        void var2_2;
        void var1_1;
        BaseImageFilter baseImageFilter = this;
        this.mWidth = var1_1;
        baseImageFilter.mHeight = var2_2;
        baseImageFilter.mIndicesOrder = baseImageFilter.getIndicesOrder();
        baseImageFilter.mShapeCoordinate = baseImageFilter.getShapeCoordinate();
        baseImageFilter.mTextureCoordinate = baseImageFilter.getTextureCoordinate();
    }

    public void onDraw(int imageTexture, int targetFrameBuffer) {
    }

    public void onDestroy() {
    }
}

