/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming;

import io.straas.android.sdk.streaming.Resolution;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StreamConfig {
    public static final int CAMERA_FRONT = 1;
    public static final int CAMERA_BACK = 0;
    private int a;
    private int b;
    private int c;
    private int d;
    private boolean e = true;
    private boolean f;
    private int g;
    private Integer h;

    private StreamConfig(int videoWidth, int videoHeight, boolean fitAllCamera, int maxVideoHeight, int camera, boolean frontCameraFlipHorizontally, int fps, Integer maxBitrate) {
        this.a = videoWidth;
        this.b = videoHeight;
        this.e = fitAllCamera;
        this.d = maxVideoHeight;
        this.c = camera;
        this.f = frontCameraFlipHorizontally;
        this.g = fps;
        this.h = maxBitrate;
    }

    public int getOutputWidth() {
        return this.a;
    }

    public int getOutputHeight() {
        return this.b;
    }

    @CAMERA_TYPE
    public int getCamera() {
        return this.c;
    }

    public int getMaxVideoHeight() {
        return this.d;
    }

    public boolean getFitAllCamera() {
        return this.e;
    }

    public boolean getFrontCameraFlipHorizontally() {
        return this.f;
    }

    public int getFps() {
        return this.g;
    }

    public Integer getMaxBitrate() {
        return this.h;
    }

    public static class Builder {
        private int a;
        private int b;
        private boolean c = true;
        private int d = 720;
        private int e;
        private boolean f = true;
        private int g = 30;
        private Integer h;

        public Builder videoResolution(int width, int height) {
            this.a = width;
            this.b = height;
            return this;
        }

        public Builder fitAllCamera(boolean fitAllCamera) {
            this.c = fitAllCamera;
            return this;
        }

        @Deprecated
        public Builder highestResolution(Resolution resolution) {
            this.d = resolution.getSize().b();
            return this;
        }

        public Builder maxVideoHeight(int height) throws IllegalArgumentException {
            if (height < 240) {
                throw new IllegalArgumentException(String.format("the height: %d should be greater than or equal 240", height));
            }
            this.d = height;
            return this;
        }

        public Builder camera(@CAMERA_TYPE int camera) {
            this.e = camera;
            return this;
        }

        public Builder frontCameraFlipHorizontally(boolean flip) {
            this.f = flip;
            return this;
        }

        public Builder fps(int fps) throws IllegalArgumentException {
            if (fps != 30 && fps != 20) {
                throw new IllegalArgumentException("FPS is invalid, this value should be 20 or 30");
            }
            this.g = fps;
            return this;
        }

        public Builder maxBitrate(Integer maxBitrate) throws IllegalArgumentException {
            if (maxBitrate < 100000) {
                throw new IllegalArgumentException("max bitrate is invalid, should be >= 100000");
            }
            this.h = maxBitrate;
            return this;
        }

        public StreamConfig build() {
            return new StreamConfig(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface CAMERA_TYPE {
    }
}

