/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming;

import io.straas.android.sdk.streaming.Resolution;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;

public class StreamConfig {
    public static final int CAMERA_FRONT = 1;
    public static final int CAMERA_BACK = 0;
    private int a;
    private int b;
    private int c;
    private Resolution d = Resolution._720p;
    private boolean e = true;
    private boolean f;
    private int g;

    private StreamConfig(int videoWidth, int videoHeight, boolean fitAllCamera, Resolution highestResolution, int camera, boolean frontCameraFlipHorizontally, int fps) {
        this.a = videoWidth;
        this.b = videoHeight;
        this.e = fitAllCamera;
        this.d = highestResolution;
        this.c = camera;
        this.f = frontCameraFlipHorizontally;
        this.g = fps;
    }

    public int getOutputWidth() {
        return this.a;
    }

    public int getOutputHeight() {
        return this.b;
    }

    @CAMERA_TYPE
    public int getCamera() {
        return this.c;
    }

    public Resolution getHighestResolution() {
        return this.d;
    }

    public boolean getFitAllCamera() {
        return this.e;
    }

    public boolean getFrontCameraFlipHorizontally() {
        return this.f;
    }

    public int getFps() {
        return this.g;
    }

    public static class Builder {
        private int a;
        private int b;
        private boolean c = true;
        private Resolution d = Resolution._720p;
        private int e;
        private boolean f = true;
        private int g = 30;

        public Builder videoResolution(int width, int height) {
            this.a = width;
            this.b = height;
            return this;
        }

        public Builder fitAllCamera(boolean fitAllCamera) {
            this.c = fitAllCamera;
            return this;
        }

        public Builder highestResolution(Resolution resolution) {
            this.d = resolution;
            return this;
        }

        public Builder camera(@CAMERA_TYPE int camera) {
            this.e = camera;
            return this;
        }

        public Builder frontCameraFlipHorizontally(boolean flip) {
            this.f = flip;
            return this;
        }

        public Builder fps(int fps) throws IllegalArgumentException {
            if (fps != 30 && fps != 20) {
                throw new IllegalArgumentException("FPS is invalid, this value should be 20 or 30");
            }
            this.g = fps;
            return this;
        }

        public StreamConfig build() {
            return new StreamConfig(this.a, this.b, this.c, this.d, this.e, this.f, this.g);
        }
    }

    @Retention(value=RetentionPolicy.CLASS)
    public static @interface CAMERA_TYPE {
    }
}

