/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.streaming.proguard;

import android.content.Context;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import android.view.TextureView;
import android.view.WindowManager;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.streaming.BaseImageFilter;
import io.straas.android.sdk.streaming.CameraController;
import io.straas.android.sdk.streaming.LiveEventConfig;
import io.straas.android.sdk.streaming.ScreencastStreamConfig;
import io.straas.android.sdk.streaming.StreamConfig;
import io.straas.android.sdk.streaming.StreamManager;
import io.straas.android.sdk.streaming.StreamStatsReport;
import io.straas.android.sdk.streaming.error.PrepareException;
import io.straas.android.sdk.streaming.error.StreamException;
import io.straas.android.sdk.streaming.http.StreamEndPoint;
import io.straas.android.sdk.streaming.interfaces.EventListener;
import io.straas.android.sdk.streaming.internal.LiveEventStatus;
import io.straas.android.sdk.streaming.proguard.a;
import io.straas.android.sdk.streaming.proguard.af;
import io.straas.android.sdk.streaming.proguard.aj;
import io.straas.android.sdk.streaming.proguard.b;
import io.straas.android.sdk.streaming.proguard.h;
import io.straas.android.sdk.streaming.proguard.x;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSource;
import okio.ByteString;
import org.json.JSONException;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;

public class c {
    private static final String a = c.class.getSimpleName();
    private h b;
    private String c;
    private Identity d;
    private StreamEndPoint e;
    private Handler f = new Handler();
    private final CallManager g = new CallManager();
    @StreamManager.StreamState
    private int h;
    private List<EventListener> i;
    private RetryDelayController j;
    private TaskCompletionSource<String> k;
    private TaskCompletionSource<Void> l;
    private boolean m;
    private final Object n = new Object();
    private TextureView o;
    private int p = 1000;
    private Runnable q = new Runnable(){

        @Override
        public void run() {
            c.this.a(c.this.i);
            c.this.f.removeCallbacks((Runnable)this);
            if (c.this.h == 4 || c.this.h == 5) {
                c.this.f.postDelayed((Runnable)this, (long)c.this.p);
            }
        }
    };
    private TextureView.SurfaceTextureListener r = new TextureView.SurfaceTextureListener(){

        public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
            if (c.this.b != null) {
                c.this.b.a(surface, width, height);
            }
        }

        public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            if (c.this.b != null) {
                c.this.b.a(width, height);
            }
        }

        public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
            if (c.this.b != null) {
                c.this.b.a(true);
                return false;
            }
            return true;
        }

        public void onSurfaceTextureUpdated(SurfaceTexture surface) {
        }
    };
    private x s = new x(){

        @Override
        public void a(Exception exception, String string2) {
            if (exception == null && TextUtils.isEmpty((CharSequence)string2)) {
                c.this.h = 4;
                c.this.f.post(c.this.q);
                c.this.k.trySetResult((Object)c.this.c);
            } else {
                if (c.this.l != null) {
                    c.this.l.trySetResult(null);
                }
                if (c.this.m) {
                    c.this.k.trySetException((Exception)new StreamException.InterruptedException());
                } else {
                    Exception exception2;
                    if (string2 == null) {
                        exception2 = HttpTaskError.getThrowableMappingId(null, (Throwable)exception) == Integer.MIN_VALUE ? new StreamException.InternalException() : new StreamException.NetworkException(exception);
                    } else {
                        switch (Integer.parseInt(string2)) {
                            case 4008: {
                                exception2 = new StreamException.EventExpiredException();
                                break;
                            }
                            case 4004: {
                                exception2 = new StreamException.StreamOccupiedException();
                                break;
                            }
                            default: {
                                exception2 = new StreamException.ServerException(string2);
                            }
                        }
                    }
                    c.this.k.trySetException(exception2);
                }
            }
        }

        @Override
        public void a(final Exception exception) {
            if (c.this.h != 4) {
                return;
            }
            c.this.m = true;
            c.this.h = 5;
            c.this.b(false).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                public void a(Void void_) {
                    c.this.h = 2;
                    String string2 = c.this.c;
                    c.this.c = null;
                    c.this.a(c.this.i, (Exception)new StreamException.NetworkException(exception), string2);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((Void)object);
                }
            });
        }

        @Override
        public void a(int n2) {
            if (c.this.l != null) {
                c.this.l.trySetResult(null);
            }
        }
    };

    public c(Identity identity) {
        if (identity == null) {
            throw new IllegalArgumentException("Identity shouldn't be null.");
        }
        this.h = 0;
        this.d = identity;
        this.e = this.a(identity);
        this.e();
    }

    @StreamManager.StreamState
    public int a() {
        return this.h;
    }

    public Task<CameraController> a(StreamConfig streamConfig, final @NonNull TextureView textureView) {
        af af2;
        if (this.h != 0 && this.h != 2) {
            return Tasks.forException((Exception)new PrepareException.RequestRejectedException(new IllegalStateException("This method should only be called when the StreamManager status is STATE_IDLE or STATE_PREPARED.")));
        }
        if (textureView == null) {
            return Tasks.forException((Exception)new PrepareException.RequestRejectedException(new IllegalArgumentException("preview shouldn't be null")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.h = 1;
        if (this.b == null) {
            this.b = new h();
        } else {
            this.o.setSurfaceTextureListener(null);
            this.b.a(false);
            this.b.c();
        }
        this.o = textureView;
        try {
            af2 = this.a(Credential.getContext(), streamConfig);
        }
        catch (Exception exception) {
            this.h = 0;
            return Tasks.forException((Exception)new PrepareException.CameraInitFailException(exception));
        }
        if (streamConfig.getOutputWidth() <= 0 || streamConfig.getOutputHeight() <= 0) {
            af2.c(streamConfig.getFitAllCamera());
            this.b(textureView).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                public void a(Void void_) {
                    af2.a((float)textureView.getWidth() / (float)textureView.getHeight());
                    c.this.a(af2, textureView, (TaskCompletionSource<CameraController>)taskCompletionSource);
                }

                public /* synthetic */ void onSuccess(Object object) {
                    this.a((Void)object);
                }
            });
        } else {
            af2.a(new aj(streamConfig.getOutputWidth(), streamConfig.getOutputHeight()));
            this.a(af2, textureView, (TaskCompletionSource<CameraController>)taskCompletionSource);
        }
        return taskCompletionSource.getTask().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<CameraController>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(@NonNull Task<CameraController> task) {
                Object object = c.this.n;
                synchronized (object) {
                    c.this.n.notify();
                }
            }
        });
    }

    public Task<Void> a(ScreencastStreamConfig screencastStreamConfig) {
        af af2;
        if (this.h != 0 && this.h != 2) {
            return Tasks.forException((Exception)new PrepareException.RequestRejectedException(new IllegalStateException("This method should only be called when the StreamManager status is STATE_IDLE or STATE_PREPARED.")));
        }
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.h = 1;
        if (this.b == null) {
            this.b = new h();
        } else {
            this.b.c();
        }
        try {
            af2 = this.b(screencastStreamConfig);
        }
        catch (Exception exception) {
            this.h = 0;
            return Tasks.forException((Exception)new PrepareException.ScreenCaptureInitFailException(exception));
        }
        this.a(af2, (TaskCompletionSource<Void>)taskCompletionSource);
        return taskCompletionSource.getTask().addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onComplete(@NonNull Task<Void> task) {
                Object object = c.this.n;
                synchronized (object) {
                    c.this.n.notify();
                }
            }
        });
    }

    private void a(af af2, TextureView textureView, TaskCompletionSource<CameraController> taskCompletionSource) {
        try {
            this.b.a(af2);
            this.b.a(this.s);
            this.a(textureView);
            this.h = 2;
            taskCompletionSource.setResult((Object)this.a(this.b));
        }
        catch (Exception exception) {
            this.h = 0;
            taskCompletionSource.setException(exception);
        }
    }

    private void a(af af2, TaskCompletionSource<Void> taskCompletionSource) {
        try {
            this.b.a(af2);
            this.b.a(this.s);
            this.h = 2;
            taskCompletionSource.setResult(null);
        }
        catch (Exception exception) {
            this.h = 0;
            taskCompletionSource.setException(exception);
        }
    }

    private CameraController a(final h h2) {
        return new CameraController(new a(){

            @Override
            public int a() {
                return h2.e();
            }

            @Override
            public boolean b() {
                return h2.k();
            }

            @Override
            public boolean c() {
                int n2 = this.a();
                while (!h2.d()) {
                    if (this.a() != n2) continue;
                    return false;
                }
                return n2 != this.a();
            }

            @Override
            public boolean d() {
                return h2.j();
            }
        });
    }

    private void a(TextureView textureView) {
        textureView.setSurfaceTextureListener(this.r);
        if (textureView.getSurfaceTexture() != null && textureView.getWidth() > 0 && textureView.getHeight() > 0) {
            this.b.a(textureView.getSurfaceTexture(), textureView.getWidth(), textureView.getHeight());
        }
    }

    private Task<Void> b(final TextureView textureView) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        textureView.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                textureView.setSurfaceTextureListener(null);
                taskCompletionSource.trySetResult(null);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        if (textureView.getWidth() > 0 && textureView.getHeight() > 0) {
            textureView.setSurfaceTextureListener(null);
            taskCompletionSource.trySetResult(null);
        }
        return taskCompletionSource.getTask();
    }

    public boolean a(BaseImageFilter baseImageFilter) {
        if (this.h == 0 || this.h == 1 || this.b == null) {
            return false;
        }
        this.b.a(baseImageFilter != null ? new b<BaseImageFilter>(baseImageFilter) : null);
        return true;
    }

    public Task<String> a(@NonNull LiveEventConfig liveEventConfig) {
        if (this.h != 0 && this.h != 1 && this.h != 2) {
            StreamException.RequestRejectedException requestRejectedException = new StreamException.RequestRejectedException(new IllegalStateException("State must be STATE_IDLE, STATE_PREPARING, or STATE_PREPARED"));
            return Tasks.forException((Exception)requestRejectedException);
        }
        if (this.d.isGuest()) {
            return Tasks.forException((Exception)new StreamException.UnauthorizedException());
        }
        if (liveEventConfig == null) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException()));
        }
        StreamEndPoint.b b2 = new StreamEndPoint.b(liveEventConfig);
        return this.a(b2);
    }

    private Task<String> a(StreamEndPoint.b b2) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<StreamEndPoint.c> call = this.e.createLive(b2);
        call.enqueue((Callback)new CallManager.Callback<StreamEndPoint.c>(this.g, call, null){

            public void onResponse(Call<StreamEndPoint.c> call, retrofit2.Response<StreamEndPoint.c> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult((Object)((StreamEndPoint.c)response.body()).id);
                } else {
                    taskCompletionSource.setException(c.this.a(response));
                }
            }

            public void onFailure(Call<StreamEndPoint.c> call, Throwable t2) {
                super.onFailure(call, t2);
                switch (HttpTaskError.getThrowableMappingId(call, (Throwable)t2)) {
                    case 6: {
                        taskCompletionSource.setException((Exception)new StreamException.InterruptedException());
                        break;
                    }
                    case 7: {
                        taskCompletionSource.setException((Exception)new StreamException.InternalException(t2));
                        break;
                    }
                    default: {
                        taskCompletionSource.setException((Exception)new StreamException.NetworkException(t2));
                    }
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    private Task<StreamEndPoint.c> a(StreamEndPoint streamEndPoint, String string2) {
        Call<StreamEndPoint.c> call = streamEndPoint.getLiveWithOwner(string2, Credential.getKey());
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        call.enqueue((Callback)new CallManager.Callback<StreamEndPoint.c>(this.g, call, null){

            public void onResponse(Call<StreamEndPoint.c> call, retrofit2.Response<StreamEndPoint.c> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult(response.body());
                } else {
                    taskCompletionSource.setException(c.this.a(response));
                }
            }

            public void onFailure(Call<StreamEndPoint.c> call, Throwable t2) {
                super.onFailure(call, t2);
                switch (HttpTaskError.getThrowableMappingId(call, (Throwable)t2)) {
                    case 6: {
                        taskCompletionSource.setException((Exception)new StreamException.InterruptedException());
                        break;
                    }
                    case 7: {
                        taskCompletionSource.setException((Exception)new StreamException.InternalException(t2));
                        break;
                    }
                    default: {
                        taskCompletionSource.setException((Exception)new StreamException.NetworkException(t2));
                    }
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<Void> a(String string2) {
        if (this.d.isGuest()) {
            return Tasks.forException((Exception)new StreamException.UnauthorizedException());
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException("Live event id shouldn't be empty")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<StreamEndPoint.c> call = this.e.updateLive(string2, new StreamEndPoint.g(LiveEventStatus.ended));
        call.enqueue((Callback)new CallManager.Callback<StreamEndPoint.c>(null, call, null){

            public void onResponse(Call<StreamEndPoint.c> call, retrofit2.Response<StreamEndPoint.c> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                } else {
                    taskCompletionSource.setException(c.this.a(response));
                }
            }

            public void onFailure(Call<StreamEndPoint.c> call, Throwable t2) {
                super.onFailure(call, t2);
                switch (HttpTaskError.getThrowableMappingId(call, (Throwable)t2)) {
                    case 6: {
                        taskCompletionSource.setException((Exception)new StreamException.InterruptedException());
                        break;
                    }
                    case 7: {
                        taskCompletionSource.setResult(null);
                        break;
                    }
                    default: {
                        taskCompletionSource.setException((Exception)new StreamException.NetworkException(t2));
                    }
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    public Task<String> b(@NonNull String string2) {
        if (this.h != 2) {
            StreamException.RequestRejectedException requestRejectedException = new StreamException.RequestRejectedException(new IllegalStateException("State must be STATE_PREPARED."));
            return Tasks.forException((Exception)requestRejectedException);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException()));
        }
        this.h = 3;
        return this.a(this.e, string2).continueWithTask((Continuation)new Continuation<StreamEndPoint.c, Task<String>>(){

            public Task<String> a(@NonNull Task<StreamEndPoint.c> task) throws Exception {
                if (task.isSuccessful()) {
                    StreamEndPoint.c c2 = (StreamEndPoint.c)task.getResult();
                    String string2 = c.this.e(c.this.d.getToken());
                    if (TextUtils.isEmpty((CharSequence)string2)) {
                        c.this.h = 2;
                        throw new StreamException.UnauthorizedException();
                    }
                    if (c2 == null || c2.owner == null || !string2.equals(c2.owner.id) || c2.status == LiveEventStatus.ended) {
                        c.this.h = 2;
                        throw new StreamException.NotFoundException();
                    }
                    return c.this.a(c2);
                }
                c.this.h = 2;
                throw task.getException();
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<StreamEndPoint.c>)task);
            }
        });
    }

    public Task<String> a(StreamEndPoint.c c2) {
        String string2 = io.straas.android.sdk.streaming.proguard.c.a(c2.stream_server_url, c2.stream_key);
        this.c = c2.id;
        return this.d(string2);
    }

    public Task<Void> c(String string2) {
        if (this.h != 2) {
            StreamException.RequestRejectedException requestRejectedException = new StreamException.RequestRejectedException(new IllegalStateException("State must be STATE_PREPARED."));
            return Tasks.forException((Exception)requestRejectedException);
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalArgumentException()));
        }
        this.h = 3;
        String string3 = io.straas.android.sdk.streaming.proguard.c.a("rtmp://live-ea.straas.net/app", string2);
        return this.d(string3).continueWith((Continuation)new Continuation<String, Void>(){

            public Void a(@NonNull Task<String> task) throws Exception {
                if (task.isSuccessful()) {
                    return null;
                }
                throw task.getException();
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<String>)task);
            }
        });
    }

    private Task<String> d(String string2) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        this.b.a(string2);
        this.m = false;
        this.j.stop();
        this.a((TaskCompletionSource<String>)taskCompletionSource, null, true);
        return taskCompletionSource.getTask();
    }

    private void a(final TaskCompletionSource<String> taskCompletionSource, Exception exception, boolean bl) {
        if (!this.j.canRetry()) {
            this.a(taskCompletionSource, exception);
            return;
        }
        this.k = new TaskCompletionSource();
        this.k.getTask().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<String>(){

            public void a(String string2) {
                taskCompletionSource.setResult((Object)string2);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((String)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (c.this.a(e2)) {
                    c.this.a((TaskCompletionSource<String>)taskCompletionSource, e2, false);
                } else {
                    c.this.a(taskCompletionSource, e2);
                }
            }
        });
        if (bl) {
            this.j.retryImmediately();
        } else {
            this.j.retry();
        }
    }

    private void e() {
        this.j = new RetryDelayController(new Retriable(){

            public void retry() {
                if (c.this.m) {
                    c.this.k.trySetException((Exception)new StreamException.InterruptedException());
                } else {
                    c.this.h = 3;
                    c.this.b(false).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

                        public void a(Void void_) {
                            c.this.b.a();
                        }

                        public /* synthetic */ void onSuccess(Object object) {
                            this.a((Void)object);
                        }
                    });
                }
            }
        });
        this.j.enableExponentialBackoff(true);
        this.j.setMaxCount(2);
    }

    public Task<Void> a(boolean bl) {
        if (!bl && this.h != 3 && this.h != 4) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalStateException("State should be STATE_CONNECTING or STATE_STREAMING.")));
        }
        this.m = true;
        this.h = 5;
        this.g.cancelAllCalls();
        return this.b(bl).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> a(@NonNull Task<Void> task) throws Exception {
                c.this.h = 2;
                return task;
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<Void>)task);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Task<Void> b() {
        if (this.h == 0) {
            return Tasks.forException((Exception)new StreamException.RequestRejectedException(new IllegalStateException("State should be STATE_IDLE.")));
        }
        if (this.h == 1) {
            Object object = this.n;
            synchronized (object) {
                try {
                    this.n.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        return this.a(true).continueWithTask((Continuation)new Continuation<Void, Task<Void>>(){

            public Task<Void> a(@NonNull Task<Void> task) throws Exception {
                c.this.f.removeCallbacks(c.this.q);
                if (task.isSuccessful()) {
                    c.this.b.a(false);
                    c.this.b.c();
                    c.this.b = null;
                    if (c.this.o != null) {
                        c.this.o.setSurfaceTextureListener(null);
                        c.this.o = null;
                    }
                    c.this.h = 0;
                    return task;
                }
                return task;
            }

            public /* synthetic */ Object then(@NonNull Task task) throws Exception {
                return this.a((Task<Void>)task);
            }
        });
    }

    private Task<Void> b(boolean bl) {
        if (this.l != null && !this.l.getTask().isComplete()) {
            if (bl) {
                this.l.trySetException((Exception)new StreamException.InterruptedException());
            } else {
                return Tasks.forException((Exception)new IllegalStateException());
            }
        }
        this.l = new TaskCompletionSource();
        if (this.b != null && !this.b.b()) {
            this.l.setResult(null);
        }
        return this.l.getTask();
    }

    public boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        if (this.i == null) {
            this.i = new ArrayList<EventListener>();
        }
        if (this.i.size() > 1 && this.i.contains(eventListener)) {
            return false;
        }
        return this.i.add(eventListener);
    }

    public void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    public boolean b(EventListener eventListener) {
        return eventListener != null && this.i != null && this.i.remove(eventListener);
    }

    public void c() {
        if (this.i == null) {
            return;
        }
        this.i.clear();
    }

    public StreamStatsReport d() {
        if (this.h == 0 || this.b == null) {
            return null;
        }
        return new StreamStatsReport(this.b.h() * 8, this.b.f());
    }

    public void a(int n2) {
        this.p = n2;
    }

    private void a(final List<EventListener> list) {
        if (list == null) {
            return;
        }
        this.f.post(new Runnable(){

            @Override
            public void run() {
                if (!list.isEmpty()) {
                    StreamStatsReport streamStatsReport = c.this.d();
                    if (streamStatsReport == null) {
                        return;
                    }
                    for (EventListener eventListener : list) {
                        eventListener.onStreamStatsReportUpdate(streamStatsReport);
                    }
                }
            }
        });
    }

    private void a(final TaskCompletionSource taskCompletionSource, final Exception exception) {
        this.b(false).addOnCompleteListener((OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                c.this.h = 2;
                taskCompletionSource.setException(exception);
            }
        });
    }

    private void a(final List<EventListener> list, final Exception exception, final String string2) {
        if (list == null) {
            return;
        }
        this.f.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(exception, string2);
                }
            }
        });
    }

    private StreamEndPoint a(Identity identity) {
        return (StreamEndPoint)Utils.createMemberRetrofit((String)"https://app.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                return chain.proceed(chain.request().newBuilder().addHeader("X-App-Token", Credential.getKey()).build());
            }
        }}).create(StreamEndPoint.class);
    }

    private af a(Context context, StreamConfig streamConfig) throws Exception {
        af af2;
        block5: {
            Camera.CameraInfo cameraInfo;
            block4: {
                af2 = af.a();
                af2.b(streamConfig.getCamera());
                af2.b(streamConfig.getHighestResolution().getSize());
                af2.b(streamConfig.getFrontCameraFlipHorizontally());
                try {
                    cameraInfo = this.b(1);
                    af2.c(this.a(context, cameraInfo));
                }
                catch (Exception exception) {
                    if (streamConfig.getCamera() != 1) break block4;
                    throw exception;
                }
            }
            try {
                cameraInfo = this.b(0);
                af2.d(this.a(context, cameraInfo));
            }
            catch (Exception exception) {
                if (streamConfig.getCamera() != 0) break block5;
                throw exception;
            }
        }
        return af2;
    }

    private af b(ScreencastStreamConfig screencastStreamConfig) throws Exception {
        if (screencastStreamConfig.getMediaProjection() == null) {
            throw new RuntimeException("Invalid media projection for screencast");
        }
        af af2 = af.a();
        af2.a(new aj(screencastStreamConfig.getOutputWidth(), screencastStreamConfig.getOutputHeight()));
        af2.a(screencastStreamConfig.getMediaProjection());
        af2.i(screencastStreamConfig.getDensityDpi());
        return af2;
    }

    private Camera.CameraInfo b(int n2) throws Exception {
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n2, (Camera.CameraInfo)cameraInfo);
        return cameraInfo;
    }

    private int a(Context context, Camera.CameraInfo cameraInfo) {
        int n2;
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        int n3 = windowManager.getDefaultDisplay().getRotation();
        int n4 = 0;
        switch (n3) {
            case 0: {
                n4 = 0;
                break;
            }
            case 1: {
                n4 = 90;
                break;
            }
            case 2: {
                n4 = 180;
                break;
            }
            case 3: {
                n4 = 270;
            }
        }
        if (cameraInfo.facing == 1) {
            n2 = (cameraInfo.orientation + n4) % 360;
            n2 = (360 - n2) % 360;
        } else {
            n2 = (cameraInfo.orientation - n4 + 360) % 360;
        }
        return this.c(n2);
    }

    private int c(int n2) {
        switch (n2) {
            case 0: {
                return 16;
            }
            case 90: {
                return 32;
            }
            case 180: {
                return 64;
            }
            case 270: {
                return 128;
            }
        }
        return 16;
    }

    private Exception a(retrofit2.Response response) {
        int n2 = response.code();
        switch (n2) {
            case 400: {
                return new StreamException.RequestRejectedException(new IllegalArgumentException());
            }
            case 401: {
                return new StreamException.UnauthorizedException();
            }
            case 403: 
            case 409: {
                return new StreamException.InternalException(this.a((ResponseBody)response.errorBody()).error);
            }
            case 423: {
                return new StreamException.UnavailableException();
            }
            case 404: {
                return new StreamException.NotFoundException();
            }
            case 422: {
                StreamEndPoint.f f2 = this.a(response.errorBody());
                if (f2 != null && !TextUtils.isEmpty((CharSequence)f2.parseLiveId())) {
                    return new StreamException.LiveCountLimitException(f2.parseLiveId());
                }
                return new StreamException.RequestRejectedException(new IllegalArgumentException());
            }
        }
        if (n2 >= 500 && n2 < 600) {
            return new StreamException.ServerException(response.code());
        }
        return new StreamException.InternalException();
    }

    private StreamEndPoint.f a(ResponseBody responseBody) {
        StreamEndPoint.f f2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            f2 = (StreamEndPoint.f)moshi.adapter(StreamEndPoint.f.class).fromJson((BufferedSource)responseBody.source().buffer().clone());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            f2 = new StreamEndPoint.f();
        }
        return f2;
    }

    private boolean a(Exception exception) {
        return !(exception instanceof StreamException.InterruptedException) && !(exception instanceof StreamException.EventExpiredException);
    }

    private String e(String string2) {
        String string3 = null;
        String string4 = string2.split("\\.")[1];
        try {
            String string5 = ByteString.decodeBase64((String)string4).utf8();
            JSONObject jSONObject = new JSONObject(string5);
            string3 = jSONObject.getString("member_id");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return string3;
    }

    private static String a(String string2, String string3) {
        return String.format("%s/%s", string2, string3);
    }
}

