/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging.http;

import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import okhttp3.ResponseBody;
import proguard.annotation.KeepClassMembers;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.DELETE;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface MessagingEndpoint {
    @GET(value="/get-chat-profile-by-channel/{apiToken}?return_sticker=true")
    public Call<h> getChatProfileByChannel(@Path(value="apiToken") String var1, @Query(value="channelCode") String var2, @Query(value="platform") String var3);

    @POST(value="/add-users-to-chat/{apiToken}")
    public Call<c> addUsersToChat(@Path(value="apiToken") String var1, @Body b var2);

    @GET(value="/get-users-by-chat/{apiToken}")
    public Call<k> getUsersByChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="statuses[]") List<String> var4, @Query(value="roles[]") List<Role> var5, @Query(value="count") Integer var6, @Query(value="offset") Integer var7);

    @GET(value="/get-messages-by-chat/{apiToken}?categories[]=USER&populateCreator=true")
    public Call<i> getMessagesByChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="offset") Integer var4, @Query(value="count") Integer var5, @Query(value="oldestDate") Long var6, @Query(value="latestDate") Long var7, @Query(value="order") String var8, @Query(value="msgType") String var9);

    @GET(value="/get-messages-by-chat/{apiToken}?categories[]=USER&msgType=aggregate")
    public Call<g> getAggregatedDataByChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="offset") Integer var4, @Query(value="count") Integer var5, @Query(value="oldestDate") Long var6, @Query(value="latestDate") Long var7, @Query(value="order") String var8);

    @POST(value="/add-user-message-to-chat/{apiToken}")
    public Call<ResponseBody> addUserMessageToChat(@Path(value="apiToken") String var1, @Body a var2);

    @PUT(value="/update-users-in-chat/{apiToken}")
    public Call<ResponseBody> updateUser(@Path(value="apiToken") String var1, @Body s var2);

    @PUT(value="/block-users-in-chat/{apiToken}")
    public Call<ResponseBody> blockUsersInChat(@Path(value="apiToken") String var1, @Body e var2);

    @PUT(value="/revive-users-in-chat/{apiToken}")
    public Call<ResponseBody> reviveUsersInChat(@Path(value="apiToken") String var1, @Body e var2);

    @DELETE(value="/remove-users-from-chat/{apiToken}")
    public Call<ResponseBody> removeUsersFromChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="targetUserLabels[]") List<Integer> var4);

    @DELETE(value="/remove-message-from-chat/{apiToken}")
    public Call<ResponseBody> removeMessageFromChat(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="messageId") String var4);

    @POST(value="/v2/chat/{apiToken}")
    public Call<ResponseBody> createPersonalChat(@Path(value="apiToken") String var1, @Body f var2);

    @POST(value="/pinned-msg/{apiToken}")
    public Call<ResponseBody> pinMessage(@Path(value="apiToken") String var1, @Body o var2);

    @DELETE(value="/pinned-msg/{apiToken}")
    public Call<ResponseBody> unpinMessage(@Path(value="apiToken") String var1, @Query(value="chatId") String var2, @Query(value="userToken") String var3);

    @POST(value="/chat-meta/{apiToken}")
    public Call<ResponseBody> setMetadata(@Path(value="apiToken") String var1, @Body p var2);

    @GET(value="/chat-meta/{apiToken}")
    public Call<j> getMetadata(@Path(value="apiToken") String var1, @Query(value="userToken") String var2, @Query(value="chatId") String var3, @Query(value="keys[]") List<String> var4);

    @KeepClassMembers
    public static class t {
        public String userId;
        public String name;
        public String avatar;
        public int label = -1;
        public String status;
        public boolean isAdmin;
        public String role;
    }

    @KeepClassMembers
    public static class d {
        public List<Map> aggregated;
        public String createdDate;
    }

    @KeepClassMembers
    public static class l {
        public String id;
        public String category;
        public String type;
        public String status;
        public String text;
        public String link;
        public String createdDate;
        public Object value;
        public t creator;
    }

    @KeepClassMembers
    public static class f {
        private final String channel_code;
        private final String platform;
        private final boolean is_personal_chat = true;

        public f(String string, String string2) {
            this.channel_code = string;
            this.platform = string2;
        }
    }

    @KeepClassMembers
    public static class e
    extends m {
        private List<Integer> targetUserLabels;

        public e(String string, String string2, List<Integer> list) {
            super(string, string2);
            this.targetUserLabels = list;
        }
    }

    @KeepClassMembers
    public static class s
    extends m {
        private List<r> targetUsers;

        public s(String string, String string2, List<r> list) {
            super(string, string2);
            this.targetUsers = list;
        }
    }

    @KeepClassMembers
    public static class a
    extends m {
        private final String text;
        private final String link;
        private final Object value;
        private final String sourceType = "ANDROID";
        private final String msgType;

        public a(String string, String string2, @NonNull String string3, @NonNull Object object) {
            super(string, string2);
            this.link = null;
            switch (this.msgType = string3) {
                case "aggregate": 
                case "raw": {
                    this.value = object;
                    this.text = null;
                    break;
                }
                default: {
                    this.text = (String)object;
                    this.value = null;
                }
            }
        }
    }

    @KeepClassMembers
    public static class g {
        public d[] messages;
    }

    @KeepClassMembers
    public static class i {
        public l[] messages;
    }

    @KeepClassMembers
    public static class k {
        public t[] users;
    }

    @KeepClassMembers
    public static class r {
        private Role role;
        private String name;
        private Integer label = null;
        private String platform;
        private String memberId;

        public r(Role role) {
            this.role = role;
        }

        public r(String string) {
            this.name = string;
        }

        public r(int n2, String string) {
            this(string);
            this.label = n2;
        }

        public r(int n2, Role role) {
            this(role);
            this.label = n2;
        }

        public r(String string, String string2, Role role) {
            this(role);
            this.platform = string;
            this.memberId = string2;
        }
    }

    @KeepClassMembers
    public static class n {
        public String message;
        public String code;

        public String toString() {
            return (!TextUtils.isEmpty((CharSequence)this.code) ? this.code : "null") + ": " + (!TextUtils.isEmpty((CharSequence)this.message) ? this.message : "null");
        }
    }

    @KeepClassMembers
    public static class q {
        public String host;
        public String path;
        public String query;
    }

    @KeepClassMembers
    public static class c {
        public a[] userMetas;
        public t userModel;
        public q socket;

        @KeepClassMembers
        public static class a {
            public int label = -1;
            public String userToken;
            public String role;
        }
    }

    @KeepClassMembers
    public static class b
    extends m {
        private final List<r> targetUsers;
        public boolean newSocket = true;

        public b(String string, String string2, String string3) {
            super(string, string2);
            this.targetUsers = TextUtils.isEmpty((CharSequence)string3) ? null : Collections.singletonList(new r(string3));
        }
    }

    @KeepClassMembers
    public static class o
    extends m {
        private String messageId;

        public o(String string, String string2, String string3) {
            super(string, string2);
            this.messageId = string3;
        }
    }

    @KeepClassMembers
    public static class m {
        private final String chatId;
        private final String userToken;

        public m(String string, String string2) {
            this.chatId = string;
            this.userToken = string2;
        }
    }

    @KeepClassMembers
    public static class h {
        public String chatWriteMode;
        public String channelCode;
        public int guestCount;
        public String id;
        public int inputInterval;
        public int memberCount;
        public List<a> sticker;
        public List<Map> aggregated;
        public String arcMsgURL;
        public l pinnedMsg;

        public SimpleArrayMap<String, String> getStickerMap() {
            SimpleArrayMap simpleArrayMap = new SimpleArrayMap();
            if (this.sticker != null) {
                for (a a2 : this.sticker) {
                    for (Map.Entry<String, String> entry : a2.stickers.entrySet()) {
                        simpleArrayMap.put((Object)entry.getKey(), (Object)entry.getValue());
                    }
                }
            }
            return simpleArrayMap;
        }

        public List<Sticker> getStickerSuite() {
            ArrayList<Sticker> arrayList = new ArrayList<Sticker>();
            if (this.sticker != null) {
                for (a a2 : this.sticker) {
                    Sticker sticker = new Sticker();
                    sticker.mMainImage = a2.mainImage;
                    sticker.mName = a2.name;
                    sticker.mStickers = a2.stickers;
                    arrayList.add(sticker);
                }
            }
            return arrayList;
        }

        public ChatroomInfo toChatroomInfo() {
            return new ChatroomInfo(ChatMode.a(this.chatWriteMode), this.channelCode, this.guestCount, this.memberCount, this.inputInterval, this.getStickerSuite());
        }

        @KeepClassMembers
        public static class a {
            public String mainImage;
            public String name;
            public Map<String, String> stickers;
        }
    }

    @KeepClassMembers
    public static class j {
        public a[] meta;

        @KeepClassMembers
        public static class a {
            public String scope;
            public String key;
            public Object value;
            public boolean reserved;

            public boolean isPublicMeta() {
                return !this.reserved && TextUtils.equals((CharSequence)this.scope, (CharSequence)"chat");
            }
        }
    }

    @KeepClassMembers
    public static class p
    extends m {
        public String key;
        public Object value;
        public boolean broadcast;

        public p(String string, String string2, String string3, Object object, boolean bl) {
            super(string, string2);
            this.key = string3;
            this.value = object;
            this.broadcast = bl;
        }
    }
}

