/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.iKalaHttpUtils;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonAdapter;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.client.SocketIOException;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.internal.Configuration;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.AggregatedData;
import io.straas.android.sdk.messaging.ChatMetadata;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.http.MessagingEndpoint;
import io.straas.android.sdk.messaging.http.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import io.straas.android.sdk.messaging.user.UserType;
import java.io.InterruptedIOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

final class a {
    private static final String[] a = new String[]{"websocket"};
    private static final Pattern b = Pattern.compile("^[A-Za-z0-9][A-Za-z0-9_\\-@#]{0,29}$");
    private ChatroomState c = ChatroomState.IDLE;
    private int d;
    private String e;
    private Identity f;
    private boolean g;
    private List<EventListener> h;
    private int i;
    private SimpleArrayMap<String, String> j;
    private SimpleArrayMap<String, Integer> k;
    private List<Sticker> l;
    private String m;
    private String n;
    private Integer o;
    private User p;
    private MessagingEndpoint.q q;
    private boolean r;
    private MessagingEndpoint s;
    private MessagingEndpoint t;
    private final CallManager u = new CallManager();
    private RetryDelayController v;
    private String w;
    private SharedPreferences x;
    private Handler y = new Handler();
    private c z;
    private TaskCompletionSource<Void> A;
    private io.straas.android.sdk.messaging.b B;
    private Message C;
    private ChatMode D = ChatMode.ALL;
    private a.a E = new a.a(){

        @Override
        public void a(String string) {
            a.this.w = string;
            if (a.this.x != null) {
                a.this.x.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer F = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(new MessagingException.InternalException("timeout"));
        }
    };

    a(Context context) {
        this.m();
        this.x = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void m() {
        this.v = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.c = ChatroomState.CONNECTING;
                if (a.this.q != null) {
                    a.this.a(a.this.q);
                } else {
                    a.this.a(true);
                }
            }
        });
        this.v.setMaxCount(7);
        this.v.enableExponentialBackoff(true);
        this.v.setBaseRetryInterval(500L);
        this.k = new SimpleArrayMap();
        this.h = new ArrayList<EventListener>();
    }

    private void b(Identity identity) {
        this.s = (MessagingEndpoint)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (boolean)false, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.http.a.a("https://mgr.straas.net", this.E)}).create(MessagingEndpoint.class);
        this.t = (MessagingEndpoint)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (boolean)true, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.http.a.a("https://mgr.straas.net", this.E)}).create(MessagingEndpoint.class);
    }

    Task<Void> a(@NonNull String string, @NonNull Identity identity) {
        MessagingException.RequestRejectedException requestRejectedException = null;
        if (this.c != ChatroomState.IDLE) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalStateException("State must be IDLE."));
        }
        if (TextUtils.isEmpty((CharSequence)string) || identity == null) {
            requestRejectedException = new MessagingException.RequestRejectedException(new IllegalArgumentException("Check chatroom name or Identity."));
        }
        if (requestRejectedException != null) {
            return Tasks.forException((Exception)requestRejectedException);
        }
        this.A = new TaskCompletionSource();
        this.c = ChatroomState.CONNECTING;
        this.f = identity;
        this.e = string;
        this.g = string.startsWith("p#");
        this.b(identity);
        this.B = new io.straas.android.sdk.messaging.b(this.s);
        this.v.stop();
        this.r = false;
        this.o();
        return this.A.getTask();
    }

    boolean a(Identity identity) {
        if (this.c.equals((Object)ChatroomState.CONNECTED)) {
            this.f = identity;
            this.b(identity);
            return true;
        }
        return false;
    }

    private void n() {
        if (!TextUtils.isEmpty((CharSequence)this.w)) {
            return;
        }
        String string = null;
        if (this.x != null) {
            string = this.x.getString("KEY_API_TOKEN", null);
        }
        this.w = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(int n2) {
        switch (n2) {
            case 0: {
                this.p();
                break;
            }
            case 1: {
                this.q();
                break;
            }
            case 2: {
                this.r();
            }
        }
    }

    private void o() {
        this.c = ChatroomState.CONNECTING;
        this.n();
        this.a(0);
    }

    private void p() {
        final String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(new MessagingException.InternalException("check your sdk account_id"));
            this.l();
        }
        Call<MessagingEndpoint.h> call = this.s.getChatProfileByChannel(this.w, this.e, string);
        call.enqueue((Callback)new a<MessagingEndpoint.h>(this.u, call, null){

            @Override
            public void onResponse(Call<MessagingEndpoint.h> call, Response<MessagingEndpoint.h> response) {
                super.onResponse(call, response);
                if (!a.this.v()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.m = ((MessagingEndpoint.h)response.body()).id;
                    a.this.d = ((MessagingEndpoint.h)response.body()).inputInterval;
                    a.this.D = ChatMode.a(((MessagingEndpoint.h)response.body()).chatWriteMode);
                    a.this.i = ((MessagingEndpoint.h)response.body()).guestCount + ((MessagingEndpoint.h)response.body()).memberCount;
                    a.this.j = ((MessagingEndpoint.h)response.body()).getStickerMap();
                    a.this.l = ((MessagingEndpoint.h)response.body()).getStickerSuite();
                    if (((MessagingEndpoint.h)response.body()).pinnedMsg != null && !TextUtils.isEmpty((CharSequence)((MessagingEndpoint.h)response.body()).pinnedMsg.text)) {
                        a.this.C = new Message.Builder(((MessagingEndpoint.h)response.body()).pinnedMsg).build();
                    }
                    if (a.this.k.size() == 0) {
                        for (Map map : ((MessagingEndpoint.h)response.body()).aggregated) {
                            a.this.k.put((Object)((String)map.get("key")), (Object)((Double)map.get("n")).intValue());
                        }
                    } else {
                        SimpleArrayMap simpleArrayMap = new SimpleArrayMap();
                        for (Map object : ((MessagingEndpoint.h)response.body()).aggregated) {
                            String string2 = (String)object.get("key");
                            int n2 = ((Double)object.get("n")).intValue();
                            if (a.this.k.containsKey((Object)string2)) {
                                if ((Integer)a.this.k.get((Object)string2) == n2) continue;
                                int n3 = n2 - (Integer)a.this.k.get((Object)string2);
                                a.this.k.put((Object)string2, (Object)n2);
                                simpleArrayMap.put((Object)string2, (Object)n3);
                                continue;
                            }
                            a.this.k.put((Object)string2, (Object)n2);
                            simpleArrayMap.put((Object)string2, (Object)n2);
                        }
                        if (simpleArrayMap.size() > 0) {
                            for (EventListener eventListener : a.this.h) {
                                eventListener.onAggregatedDataAdded((SimpleArrayMap<String, Integer>)simpleArrayMap);
                            }
                        }
                    }
                    a.this.a(1);
                }
            }

            @Override
            protected void a(Exception exception) {
                if (exception instanceof MessagingException.NotFoundException) {
                    exception = new MessagingException.ChatroomNameNotFoundException(exception.getMessage());
                }
                if (exception instanceof MessagingException.ChatroomNameNotFoundException && a.this.g && !a.this.f.isGuest()) {
                    a.this.a(a.this.e, string);
                } else {
                    super.a(exception);
                }
            }
        });
    }

    private void a(String string, String string2) {
        Call<ResponseBody> call = this.s.createPersonalChat(this.w, new MessagingEndpoint.f(ChatroomInfo.a(string), string2));
        call.enqueue((Callback)new a<ResponseBody>(this.u, call, null){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (!a.this.v()) {
                    return;
                }
                if (response.isSuccessful()) {
                    a.this.a(0);
                }
            }

            @Override
            protected void a(Exception exception) {
                if (exception instanceof MessagingException.UnauthorizedException) {
                    exception = new MessagingException.ChatroomNameNotFoundException();
                }
                super.a(exception);
            }
        });
    }

    private void q() {
        String string = this.f == Identity.GUEST ? "Guest" : null;
        Call<MessagingEndpoint.c> call = this.s.addUsersToChat(this.w, new MessagingEndpoint.b(this.m, this.n, string));
        call.enqueue((Callback)new a<MessagingEndpoint.c>(this.u, call, null){

            @Override
            public void onResponse(Call<MessagingEndpoint.c> call, Response<MessagingEndpoint.c> response) {
                super.onResponse(call, response);
                if (!a.this.v()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    MessagingEndpoint.c.a a2 = ((MessagingEndpoint.c)response.body()).userMetas[0];
                    a.this.n = a2.userToken;
                    a.this.o = (Integer)a2.label;
                    a.this.p = new User.a(((MessagingEndpoint.c)response.body()).userModel).a();
                    a.this.q = ((MessagingEndpoint.c)response.body()).socket;
                    a.this.a(a.this.q);
                }
            }
        });
    }

    private void r() {
        this.v.stop();
        this.c = ChatroomState.CONNECTED;
        if (!this.r) {
            this.r = true;
            if (this.A != null) {
                this.A.trySetResult(null);
                this.A = null;
            }
            this.c(this.h);
        }
        this.B.a(this.w, this.n, this.m, this.i);
    }

    private void a(MessagingEndpoint.q q2) {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.path = q2.path;
        options.query = (!TextUtils.isEmpty((CharSequence)q2.query) ? q2.query + "&" : "") + "userAgent=" + Configuration.USER_AGENT;
        options.transports = a;
        options.timeout = 30000L;
        options.callFactory = iKalaHttpUtils.getOkHttpClient();
        options.webSocketFactory = iKalaHttpUtils.getOkHttpClient();
        try {
            socket = IO.socket((String)q2.host, (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            this.q = null;
            this.a(new MessagingException.InternalException(uRISyntaxException.getMessage()));
            return;
        }
        this.z = new c(socket);
        this.a(this.z);
        this.b(this.z);
        socket.connect();
    }

    private void a(final c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("connect", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.F.start();
                c2.a("subscribe", a.this.n, a.this.m);
            }
        });
        c2.a("connect_error", new Emitter.Listener(){

            public void call(Object ... args) {
                Object object = args.length > 0 ? args[0] : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException("Connection error", (Throwable)(object instanceof Exception ? (Exception)object : null))));
            }
        });
        c2.a("disconnect", new Emitter.Listener(){

            public void call(Object ... args) {
                if (!a.this.v()) {
                    return;
                }
                Object object = args.length > 0 ? args[0] : null;
                String string = object instanceof String ? (String)object : null;
                a.this.a(new MessagingException.NetworkException((Throwable)new SocketIOException(string)));
            }
        });
    }

    private void b(c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("subscribed", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.F.cancel();
                a.this.p.a("ACTIVE");
                a.this.i++;
                a.this.a(2);
            }
        });
        c2.a("message", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(a.this.h, Message.a(jSONObject, (SimpleArrayMap<String, String>)a.this.j), 0L);
            }
        });
        c2.a("raw_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.b((List<EventListener>)a.this.h, Message.a(jSONObject, null));
            }
        });
        c2.a("agg_data", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.a(iKalaJSONUtil.getJSONArray((JSONObject)jSONObject, (String)"aggregated"));
            }
        });
        c2.a("message_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof String)) {
                    return;
                }
                String string = (String)args[0];
                a.this.a((List<EventListener>)a.this.h, string);
            }
        });
        c2.a("message_flush", new Emitter.Listener(){

            public void call(Object ... args) {
                a.this.e(a.this.h);
            }
        });
        c2.a("user_add", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.o != null && a.this.o.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                    a.this.i++;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(new User[0]);
                    a.this.a((List<EventListener>)a.this.h, userArray);
                    a.this.a((List<EventListener>)a.this.h, a.this.i);
                    a.this.B.a(userArray);
                }
            }
        });
        c2.a("user_update", new Emitter.Listener(){

            public void call(Object ... args) {
                int n2 = 0;
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.o == null || a.this.o.intValue() != user.getLabel().intValue()) continue;
                    a.this.p = user;
                }
                if (arrayList.size() != 0) {
                    User[] userArray = arrayList.toArray(arrayList.toArray(new User[0]));
                    a.this.b((List<EventListener>)a.this.h, userArray);
                    a.this.B.b(userArray);
                }
            }
        });
        c2.a("user_remove", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                int n2 = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n3) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.o != null && n3 == a.this.o) {
                        switch (string) {
                            case "DELETED": {
                                if (!a.this.v()) break;
                                break;
                            }
                        }
                    } else {
                        Object object = new User.a();
                        ((User.a)object).a(n3).a(string);
                        arrayList.add(n3);
                    }
                    a.this.i--;
                    a.this.i = a.this.i >= 1 ? a.this.i : 1;
                }
                if (arrayList.size() != 0) {
                    Integer[] integerArray = arrayList.toArray(new Integer[0]);
                    a.this.a((List<EventListener>)a.this.h, integerArray);
                    a.this.a((List<EventListener>)a.this.h, a.this.i);
                    a.this.B.a(integerArray);
                }
            }
        });
        c2.a("user_count", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                a.this.i = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount") + iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a((List<EventListener>)a.this.h, a.this.i);
                a.this.B.a(a.this.i);
            }
        });
        c2.a("error", new Emitter.Listener(){

            public void call(Object ... args) {
            }
        });
        c2.a("chat_write_mode", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.D = ChatMode.a(string);
                a.this.a((List<EventListener>)a.this.h, a.this.h());
            }
        });
        c2.a("message_input_interval", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.m)) {
                    return;
                }
                a.this.d = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.b((List<EventListener>)a.this.h, a.this.i());
            }
        });
        c2.a("pinned_message", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)args[0];
                JSONObject jSONObject2 = iKalaJSONUtil.getJSONObject((JSONObject)jSONObject, (String)"pinnedMsg");
                if (jSONObject2 == null || jSONObject2.length() == 0) {
                    a.this.C = null;
                } else {
                    a.this.C = Message.a(jSONObject2, null);
                }
                a.this.a((List<EventListener>)a.this.h, a.this.C);
            }
        });
        c2.a("meta", new Emitter.Listener(){

            public void call(Object ... args) {
                if (args == null || args.length <= 0) {
                    return;
                }
                if (!(args[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)args[0];
                Moshi moshi = new Moshi.Builder().build();
                JsonAdapter jsonAdapter = moshi.adapter(MessagingEndpoint.j.a[].class);
                try {
                    SimpleArrayMap simpleArrayMap = a.this.a((MessagingEndpoint.j.a[])jsonAdapter.fromJson(jSONArray.toString()));
                    if (simpleArrayMap.size() != 0) {
                        a.this.a((List<EventListener>)a.this.h, (SimpleArrayMap<String, ChatMetadata>)simpleArrayMap);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        return !this.h.contains(eventListener) && this.h.add(eventListener);
    }

    void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    boolean b(EventListener eventListener) {
        return eventListener != null && !this.h.isEmpty() && this.h.remove(eventListener);
    }

    void a() {
        if (this.h.isEmpty()) {
            return;
        }
        this.h.clear();
    }

    private void c(final List<EventListener> list) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Exception exception) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnectFailed(exception);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final Exception exception) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(exception);
                }
            }
        });
    }

    private void d(final List<EventListener> list) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onDisconnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message, long l2) {
        this.y.postDelayed(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageAdded(message);
                }
            }
        }, l2);
    }

    private void a(final List<EventListener> list, final String string) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageRemoved(string);
                }
            }
        });
    }

    private void e(final List<EventListener> list) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageFlushed();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final User[] userArray) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserJoined(userArray);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final User[] userArray) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserUpdated(userArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Integer[] integerArray) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserLeft(integerArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final int n2) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.userCount(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final ChatMode chatMode) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onChatWriteModeChanged(chatMode);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final int n2) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onInputIntervalChanged(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onPinnedMessageUpdated(message);
                }
            }
        });
    }

    private void a(JSONArray jSONArray) {
        if (jSONArray == null || this.h.isEmpty()) {
            return;
        }
        final SimpleArrayMap simpleArrayMap = new SimpleArrayMap(jSONArray.length());
        int n2 = jSONArray.length();
        for (int i2 = 0; i2 < n2; ++i2) {
            JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
            if (jSONObject == null || !jSONObject.has("key")) continue;
            String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"key", (String)"", (boolean)false);
            int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"n", (int)0);
            if (TextUtils.isEmpty((CharSequence)string) || n3 == 0) continue;
            simpleArrayMap.put((Object)string, (Object)n3);
            Integer n4 = (Integer)this.k.get((Object)string);
            this.k.put((Object)string, (Object)(n4 == null ? n3 : n4 + n3));
        }
        if (simpleArrayMap.size() == 0) {
            return;
        }
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : a.this.h) {
                    eventListener.onAggregatedDataAdded((SimpleArrayMap<String, Integer>)simpleArrayMap);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final Message message) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onRawDataAdded(message);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final SimpleArrayMap<String, ChatMetadata> simpleArrayMap) {
        this.y.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMetadataUpdated((SimpleArrayMap<String, ChatMetadata>)simpleArrayMap);
                }
            }
        });
    }

    Task<Message[]> a(MessageRequest messageRequest, String string) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (TextUtils.equals((CharSequence)string, (CharSequence)"aggregate")) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Please use getAggregatedDataHistory")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<MessagingEndpoint.i> call = this.s.getMessagesByChat(this.w, this.n, this.m, n4, n2, messageRequest.getOldestDate(), messageRequest.getLatestDate(), messageRequest.getOrder(), string);
        call.enqueue((Callback)new b<MessagingEndpoint.i>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<MessagingEndpoint.i> call, Response<MessagingEndpoint.i> response) {
                super.onResponse(call, response);
                MessagingEndpoint.i i2 = (MessagingEndpoint.i)response.body();
                if (!response.isSuccessful() || i2 == null || i2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = i2.messages.length;
                Message[] messageArray = new Message[n2];
                for (int i3 = 0; i3 < n2; ++i3) {
                    Message message;
                    messageArray[i3] = message = new Message.Builder(i2.messages[i3], (SimpleArrayMap<String, String>)a.this.j).build();
                }
                taskCompletionSource.trySetResult((Object)messageArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    @NonNull
    SimpleArrayMap<String, Integer> b() {
        return this.k;
    }

    Task<User[]> a(UserType userType) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        return this.B.a(userType);
    }

    Task<ChatroomInfo> c() {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            MessagingException.InternalException internalException = new MessagingException.InternalException("check your sdk account_id");
            return Tasks.forException((Exception)internalException);
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<MessagingEndpoint.h> call = this.s.getChatProfileByChannel(this.w, this.e, string);
        call.enqueue((Callback)new b<MessagingEndpoint.h>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<MessagingEndpoint.h> call, Response<MessagingEndpoint.h> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    taskCompletionSource.setResult((Object)((MessagingEndpoint.h)response.body()).toChatroomInfo());
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(String string, Object object) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string.equals("text") && object instanceof CharSequence) {
            if (TextUtils.isEmpty((CharSequence)((CharSequence)object))) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message is empty, say something please.")));
            }
            if (((CharSequence)object).length() > 300) {
                return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Message should be within 300 characters.")));
            }
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.s.addUserMessageToChat(this.w, new MessagingEndpoint.a(this.m, this.n, string, object));
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(@NonNull Message message) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (message == null || TextUtils.isEmpty((CharSequence)message.getId())) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("Invalid Message")));
        }
        if (!this.s()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be a GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.s.pinMessage(this.w, new MessagingEndpoint.o(this.m, this.n, message.getId()));
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> d() {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (!this.s()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be a GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.s.unpinMessage(this.w, this.m, this.n);
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    void b(Message message) {
        this.a(this.h, message, 100L);
    }

    Task<Void> a(final String string) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new IllegalStateException("State must be CONNECTED."));
        }
        if (this.f != Identity.GUEST) {
            return Tasks.forException((Exception)new IllegalStateException("Identity must be Identity.GUEST."));
        }
        return this.b(new MessagingEndpoint.r((int)this.o, string)).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                a.this.p.setName(string);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        });
    }

    Task<Void> a(MessagingEndpoint.r r2) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        Role role = this.p.getRole();
        if (role != Role.GLOBAL_MANAGER && role != Role.LOCAL_MANAGER && role != Role.MASTER) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be a GLOBAL_MANAGER, LOCAL_MANAGER, or MASTER."));
        }
        return this.b(r2);
    }

    Task<Void> b(MessagingEndpoint.r r2) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.s.updateUser(this.w, new MessagingEndpoint.s(this.m, this.n, Collections.singletonList(r2)));
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }

            @Override
            protected void a(Call<ResponseBody> call, Exception exception) {
                if (exception instanceof MessagingException.NotFoundException) {
                    exception = new MessagingException.UserNotFoundException(exception.getMessage());
                }
                super.a(call, exception);
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(List<User> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are empty")));
        }
        if (!this.s()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be a GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.s.blockUsersInChat(this.w, new MessagingEndpoint.e(this.m, this.n, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> b(List<User> list) {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (arrayList.size() == 0) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Users are empty")));
        }
        if (!this.s()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be a GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.s.reviveUsersInChat(this.w, new MessagingEndpoint.e(this.m, this.n, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> c(Message message) {
        String string = message.getId();
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (string == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check message ID.")));
        }
        if (!this.s()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be a GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.s.removeMessageFromChat(this.w, this.n, this.m, string);
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    private boolean s() {
        Role role = this.p.getRole();
        return role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER || role == Role.MASTER || role == Role.MODERATOR;
    }

    Task<AggregatedData[]> a(MessageRequest messageRequest) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        int n2 = messageRequest.getPerPage();
        int n3 = messageRequest.getPage();
        if (!this.a(n3, n2, 100)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check page format is valid or not.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        int n4 = (n3 - 1) * n2;
        Call<MessagingEndpoint.g> call = this.s.getAggregatedDataByChat(this.w, this.n, this.m, n4, n2, messageRequest.getOldestDate(), messageRequest.getLatestDate(), messageRequest.getOrder());
        call.enqueue((Callback)new b<MessagingEndpoint.g>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<MessagingEndpoint.g> call, Response<MessagingEndpoint.g> response) {
                super.onResponse(call, response);
                MessagingEndpoint.g g2 = (MessagingEndpoint.g)response.body();
                if (!response.isSuccessful() || g2 == null || g2.messages == null) {
                    taskCompletionSource.trySetException((Exception)new MessagingException.InternalException());
                    return;
                }
                int n2 = g2.messages.length;
                AggregatedData[] aggregatedDataArray = new AggregatedData[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    aggregatedDataArray[i2] = new AggregatedData();
                    aggregatedDataArray[i2].b = io.straas.android.sdk.messaging.c.a(g2.messages[i2].createdDate);
                    for (Map map : g2.messages[i2].aggregated) {
                        aggregatedDataArray[i2].a.put((Object)((String)map.get("key")), (Object)((Double)map.get("n")).intValue());
                    }
                }
                taskCompletionSource.setResult((Object)aggregatedDataArray);
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<Void> a(String string, @Nullable Object object, boolean bl) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        if (!this.s()) {
            return Tasks.forException((Exception)new MessagingException.PermissionException("User role must be a GLOBAL_MANAGER, LOCAL_MANAGER, MASTER, or MODERATOR."));
        }
        if (TextUtils.isEmpty((CharSequence)string) || !b.matcher(string).matches()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("ChatMetadata key is illegal")));
        }
        if (object != null && (bl && io.straas.android.sdk.messaging.c.a(object) > 1024 || !bl && io.straas.android.sdk.messaging.c.a(object) > 4096)) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("ChatMetadata value reaches the upper bound of size")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<ResponseBody> call = this.t.setMetadata(this.w, new MessagingEndpoint.p(this.m, this.n, string, object, bl));
        call.enqueue((Callback)new b<ResponseBody>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    taskCompletionSource.setResult(null);
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    Task<SimpleArrayMap<String, ChatMetadata>> a(@Nullable String[] stringArray) {
        if (this.c != ChatroomState.CONNECTED) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("State must be CONNECTED.")));
        }
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Call<MessagingEndpoint.j> call = this.s.getMetadata(this.w, this.n, this.m, stringArray != null ? Arrays.asList(stringArray) : null);
        call.enqueue((Callback)new b<MessagingEndpoint.j>(this.u, call, taskCompletionSource){

            @Override
            public void onResponse(Call<MessagingEndpoint.j> call, Response<MessagingEndpoint.j> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    MessagingEndpoint.j.a[] aArray = ((MessagingEndpoint.j)response.body()).meta;
                    taskCompletionSource.setResult((Object)a.this.a(aArray));
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    List<Sticker> e() {
        return this.l;
    }

    User f() {
        return this.p;
    }

    int g() {
        return this.i;
    }

    ChatMode h() {
        return this.D;
    }

    int i() {
        return this.d;
    }

    ChatroomState j() {
        return this.c;
    }

    Message k() {
        return this.C;
    }

    Task<Void> l() {
        if (!this.v()) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException()));
        }
        return this.a(false);
    }

    private Task<Void> a(boolean bl) {
        if (bl) {
            this.c = ChatroomState.CONNECTING;
            this.B.a();
        } else {
            this.c = ChatroomState.DISCONNECTING;
            this.v.stop();
            this.B.b();
            this.k.clear();
        }
        this.u.cancelAllCalls();
        this.u();
        if (iKalaUtils.isEmptyString((CharSequence)this.n) || iKalaUtils.isEmptyString((CharSequence)this.m) || this.o == null) {
            if (bl) {
                this.o();
            }
        } else {
            this.b(bl);
            this.t();
        }
        if (!bl) {
            this.c = ChatroomState.IDLE;
            if (this.r) {
                this.d(this.h);
                return Tasks.forResult(null);
            }
        }
        return Tasks.forException((Exception)new Exception());
    }

    private void t() {
        this.m = null;
        this.n = null;
        this.o = null;
    }

    private synchronized void u() {
        if (this.z == null) {
            return;
        }
        this.z.a.off();
        this.z.a.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.s.removeUsersFromChat(this.w, this.n, this.m, Collections.singletonList(this.o));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.u, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.o();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable t2) {
                super.onFailure(call, t2);
                Exception exception = io.straas.android.sdk.messaging.c.a(call, t2);
                if (bl && !(exception instanceof InterruptedIOException)) {
                    a.this.o();
                }
            }
        });
    }

    private void a(Exception exception) {
        if (!this.v()) {
            this.b(exception);
            return;
        }
        if (!this.c(exception) || !this.v.retry()) {
            this.l();
            this.b(exception);
        }
    }

    private void b(Exception exception) {
        if (!this.r) {
            this.a(this.h, exception);
            if (this.A != null) {
                this.A.trySetException(exception);
            }
        } else if (!(exception instanceof InterruptedIOException)) {
            this.b(this.h, exception);
        }
    }

    private boolean c(Exception exception) {
        if (exception instanceof MessagingException.NetworkException || exception instanceof MessagingException.InternalException || exception instanceof MessagingException.ServerException) {
            return true;
        }
        if (exception instanceof MessagingException.UnauthorizedException || exception instanceof MessagingException.PermissionException || exception instanceof MessagingException.ChatroomNameNotFoundException || exception instanceof MessagingException.RequestRejectedException || exception instanceof InterruptedIOException) {
            return false;
        }
        return false;
    }

    private boolean v() {
        return this.c == ChatroomState.CONNECTING || this.c == ChatroomState.CONNECTED;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 > 0 && n3 > 0 && n3 <= n4;
    }

    private SimpleArrayMap<String, ChatMetadata> a(MessagingEndpoint.j.a[] aArray) {
        SimpleArrayMap simpleArrayMap = new SimpleArrayMap();
        for (MessagingEndpoint.j.a a2 : aArray) {
            if (!a2.isPublicMeta()) continue;
            simpleArrayMap.put((Object)a2.key, (Object)new ChatMetadata(a2));
        }
        return simpleArrayMap;
    }

    private static final class c {
        Socket a;

        c(Socket socket) {
            this.a = socket;
        }

        Emitter a(String string, Object ... objectArray) {
            return this.a.emit(string, objectArray);
        }

        Emitter a(String string, Emitter.Listener listener) {
            return this.a.on(string, listener);
        }
    }

    private class b<T>
    extends CallManager.Callback<T> {
        private int a;
        private final TaskCompletionSource b;

        b(@Nullable CallManager callManager, @Nullable Call call, TaskCompletionSource taskCompletionSource) {
            super(callManager, call, null);
            this.a = 0;
            this.b = taskCompletionSource;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                this.a(call, io.straas.android.sdk.messaging.c.a(response));
            }
        }

        public void onFailure(Call<T> call, Throwable t2) {
            super.onFailure(call, t2);
            this.a(call, io.straas.android.sdk.messaging.c.a(call, t2));
        }

        protected void a(final Call<T> call, Exception exception) {
            if (++this.a <= 3 && a.this.v() && a.this.c(exception)) {
                a.this.y.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)b.this);
                    }
                }, 1000L);
            } else if (this.b != null && !(exception instanceof InterruptedIOException)) {
                this.b.trySetException(exception);
            }
        }
    }

    private class a<T>
    extends CallManager.Callback<T> {
        a(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                this.a(io.straas.android.sdk.messaging.c.a(response));
            }
        }

        public void onFailure(Call<T> call, Throwable t2) {
            super.onFailure(call, t2);
            this.a(io.straas.android.sdk.messaging.c.a(call, t2));
        }

        protected void a(Exception exception) {
            a.this.a(exception);
        }
    }
}

