/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.google.android.gms.tasks.Tasks;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.credential.CredentialFailException;
import io.straas.android.sdk.base.credential.CredentialFailReason;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.MessagingException;
import io.straas.android.sdk.messaging.RawData;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.b;
import io.straas.android.sdk.messaging.c;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import io.straas.android.sdk.messaging.message.MessageRequest;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.ArrayList;
import java.util.List;

public class ChatroomManager {
    public static final int IS_PERSONAL_CHAT = 1;
    public static final int WITH_DATA_CHANNEL = 2;
    private b a;
    private c b;
    private List<EventListener> c;
    private Context d;
    private EventListener e = new EventListener(){

        @Override
        public void onConnected() {
        }

        @Override
        public void onConnectFailed(MessagingError error) {
        }

        @Override
        public void onConnectFailed(Exception error) {
        }

        @Override
        public void onError(MessagingError error) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onError(error);
            }
        }

        @Override
        public void onError(Exception error) {
            ChatroomManager.this.a.b();
            if (ChatroomManager.this.b != null) {
                ChatroomManager.this.b.b();
            }
            if (ChatroomManager.this.a.h() != ChatroomState.IDLE) {
                ChatroomManager.this.a.i();
            }
            if (ChatroomManager.this.b != null && ChatroomManager.this.b.h() != ChatroomState.IDLE) {
                ChatroomManager.this.b.i();
            }
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onError(error);
            }
        }

        @Override
        public void onDisconnected() {
        }

        @Override
        public void onMessageAdded(Message message) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onMessageAdded(message);
            }
        }

        @Override
        public void onMessageRemoved(String messageId) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onMessageRemoved(messageId);
            }
        }

        @Override
        public void onMessageFlushed() {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onMessageFlushed();
            }
        }

        @Override
        public void onAggregatedDataAdded(SimpleArrayMap<String, Integer> map) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onAggregatedDataAdded(map);
            }
        }

        @Override
        public void onRawDataAdded(RawData rawData) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onRawDataAdded(rawData);
            }
        }

        @Override
        public void onUserJoined(User ... users) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onUserJoined(users);
            }
        }

        @Override
        public void onUserUpdated(User ... users) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onUserUpdated(users);
            }
        }

        @Override
        public void onUserLeft(Integer ... userLabels) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onUserLeft(userLabels);
            }
        }

        @Override
        public void userCount(int userCount) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.userCount(userCount);
            }
        }

        @Override
        public void onChatWriteModeChanged(ChatMode chatMode) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onChatWriteModeChanged(chatMode);
            }
        }

        @Override
        public void onInputIntervalChanged(int inputInterval) {
            if (ChatroomManager.this.c == null) {
                return;
            }
            for (EventListener eventListener : ChatroomManager.this.c) {
                eventListener.onInputIntervalChanged(inputInterval);
            }
        }
    };

    public static void initialize(final OnResultListener<ChatroomManager, CredentialFailReason> callback) {
        ChatroomManager.initialize().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<ChatroomManager>(){

            public void a(ChatroomManager chatroomManager) {
                if (callback == null) {
                    return;
                }
                callback.onSuccess((Object)chatroomManager);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((ChatroomManager)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (callback == null) {
                    return;
                }
                if (e2 instanceof MessagingException.NetworkException) {
                    callback.onFailure((Object)CredentialFailReason.NETWORK_ERROR);
                } else if (e2 instanceof MessagingException.ServerException) {
                    callback.onFailure((Object)CredentialFailReason.SERVER_ERROR);
                } else if (e2 instanceof CredentialFailException.WrongInformationException) {
                    callback.onFailure((Object)CredentialFailReason.WRONG_INFORMATION);
                }
            }
        });
    }

    public static MessagingError exceptionToMessagingError(@NonNull Exception e2) {
        if (e2 instanceof MessagingException.RequestRejectedException) {
            return MessagingError.REQUEST_REJECTED;
        }
        if (e2 instanceof MessagingException.NetworkException) {
            return MessagingError.NETWORK_ERROR;
        }
        if (e2 instanceof MessagingException.InternalException) {
            return MessagingError.INTERNAL_ERROR;
        }
        if (e2 instanceof MessagingException.UnauthorizedException) {
            return MessagingError.UNAUTHORIZED_ERROR;
        }
        if (e2 instanceof MessagingException.PermissionException) {
            return MessagingError.PERMISSION_ERROR;
        }
        if (e2 instanceof MessagingException.ChatroomNameNotFoundException) {
            return MessagingError.UNKNOWN_CHATROOM;
        }
        if (e2 instanceof MessagingException.ServerException) {
            return MessagingError.SERVER_ERROR;
        }
        return MessagingError.INTERNAL_ERROR;
    }

    public static Task<ChatroomManager> initialize() {
        return Credential.validate().continueWith((Continuation)new a());
    }

    private ChatroomManager(Context context) {
        this.d = context;
        this.a = new b(context);
    }

    public Task<Void> connect(@NonNull String chatroomName, @NonNull Identity identity, int flag) {
        boolean bl;
        boolean bl2 = (flag & 2) != 0;
        boolean bl3 = bl = (flag & 1) != 0;
        if (bl2) {
            this.b = new c(this.d);
            if (!bl) {
                return this.a(this.a.a(chatroomName, identity, this.e), this.b.a("d#" + chatroomName, identity, this.e));
            }
            return this.a(this.a.a("p#" + chatroomName, identity, this.e), this.b.a("dp#" + chatroomName, identity, this.e));
        }
        this.b = null;
        Task<Void> task = !bl ? this.a.a(chatroomName, identity, this.e) : this.a.a("p#" + chatroomName, identity, this.e);
        return task.addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                if (ChatroomManager.this.c != null) {
                    for (EventListener eventListener : ChatroomManager.this.c) {
                        eventListener.onConnected();
                    }
                }
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                if (ChatroomManager.this.c != null) {
                    for (EventListener eventListener : ChatroomManager.this.c) {
                        eventListener.onConnectFailed(e2);
                    }
                }
            }
        });
    }

    private <T> Task<Void> a(final Task<T> task, final Task<T> task2) {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        Tasks.whenAll((Task[])new Task[]{task, task2}).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                taskCompletionSource.setResult(null);
                if (ChatroomManager.this.c != null) {
                    for (EventListener eventListener : ChatroomManager.this.c) {
                        eventListener.onConnected();
                    }
                }
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                block4: {
                    block3: {
                        Exception exception;
                        Exception exception2 = exception = task.getException() != null ? task.getException() : task2.getException();
                        if (exception == null) break block3;
                        taskCompletionSource.setException(exception);
                        if (ChatroomManager.this.c == null) break block4;
                        for (EventListener eventListener : ChatroomManager.this.c) {
                            eventListener.onConnectFailed(exception);
                        }
                        break block4;
                    }
                    taskCompletionSource.setException(e2);
                    if (ChatroomManager.this.c != null) {
                        for (EventListener eventListener : ChatroomManager.this.c) {
                            eventListener.onConnectFailed(e2);
                        }
                    }
                }
            }
        });
        return taskCompletionSource.getTask();
    }

    public boolean resetIdentity(Identity identity) {
        boolean bl = this.a.a(identity);
        if (this.b != null) {
            bl &= this.b.a(identity);
        }
        return bl;
    }

    @Deprecated
    public void getMessages(int page, int perPage, final @NonNull OnResultListener<Message[], MessagingError> listener) {
        this.getMessages(new MessageRequest.Builder().page(page).perPage(perPage).build()).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Message[]>(){

            public void a(Message[] messageArray) {
                listener.onSuccess((Object)messageArray);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Message[])object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Message[]> getMessages(MessageRequest request) {
        return this.a.a(request);
    }

    @Deprecated
    public void getUsers(int page, int perPage, final @NonNull OnResultListener<User[], MessagingError> listener) {
        this.getUsers(page, perPage).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<User[]>(){

            public void a(User[] userArray) {
                listener.onSuccess((Object)userArray);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((User[])object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<User[]> getUsers(int page, int perPage) {
        return this.a.a(page, perPage);
    }

    @Deprecated
    public void getChatroomInfo(final @NonNull OnResultListener<ChatroomInfo, MessagingError> listener) {
        this.getChatroomInfo().addOnSuccessListener((OnSuccessListener)new OnSuccessListener<ChatroomInfo>(){

            public void a(ChatroomInfo chatroomInfo) {
                listener.onSuccess((Object)chatroomInfo);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((ChatroomInfo)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<ChatroomInfo> getChatroomInfo() {
        return this.a.c();
    }

    @Deprecated
    public void updateNickname(String name, final OnResultListener<Void, MessagingError> listener) {
        this.updateNickname(name).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> updateNickname(String name) {
        return this.a.b(name);
    }

    @Deprecated
    public void blockUsers(List<User> users, final OnResultListener<Void, MessagingError> listener) {
        this.blockUsers(users).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> blockUsers(List<User> users) {
        return this.a.a(users);
    }

    @Deprecated
    public void reviveUsers(List<User> users, final OnResultListener<Void, MessagingError> listener) {
        this.reviveUsers(users).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> reviveUsers(List<User> users) {
        return this.a.b(users);
    }

    @Deprecated
    public void removeMessage(Message message, final OnResultListener<Void, MessagingError> listener) {
        this.removeMessage(message).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> removeMessage(Message message) {
        return this.a.b(message);
    }

    @Deprecated
    public void sendMessage(String message, final OnResultListener<Void, MessagingError> listener) {
        this.sendMessage(message).addOnSuccessListener((OnSuccessListener)new OnSuccessListener<Void>(){

            public void a(Void void_) {
                listener.onSuccess((Object)void_);
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        }).addOnFailureListener(ChatroomManager.a(listener));
    }

    public Task<Void> sendMessage(String message) {
        return this.a.a(message);
    }

    public Task<Void> sendAggregatedDataTypeMessage(String message) {
        if (this.b == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("Did you enable WITH_DATA_CHANNEL flag?")));
        }
        if (TextUtils.isEmpty((CharSequence)message) || message.length() > 50) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Aggregate data must be between 1~50 characters.")));
        }
        return this.b.a(String.format("{\"key\":\"%s\"}", message));
    }

    public Task<Void> sendRawData(@NonNull RawData rawData) {
        if (this.b == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalStateException("Did you enable WITH_DATA_CHANNEL flag?")));
        }
        if (rawData == null) {
            return Tasks.forException((Exception)new MessagingException.RequestRejectedException(new IllegalArgumentException("Check your raw data.")));
        }
        return this.b.a(String.format("{\"payload\":%s}", rawData.getJsonText()));
    }

    public void addFakeMessage(Message message) {
        this.a.a(message);
    }

    public User getCurrentUser() {
        return this.a.d();
    }

    public List<Sticker> getSticker() {
        return this.a.k();
    }

    public int getUserCount() {
        return this.a.e();
    }

    public ChatMode getChatMode() {
        return this.a.f();
    }

    public int getSendMessageInterval() {
        return this.a.g();
    }

    public ChatroomState getChatroomState() {
        return this.a.h();
    }

    public Task<Void> disconnect() {
        final TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        OnSuccessListener<Void> onSuccessListener = new OnSuccessListener<Void>(){

            public void a(Void void_) {
                taskCompletionSource.setResult(null);
                if (ChatroomManager.this.c == null) {
                    return;
                }
                for (EventListener eventListener : ChatroomManager.this.c) {
                    eventListener.onDisconnected();
                }
            }

            public /* synthetic */ void onSuccess(Object object) {
                this.a((Void)object);
            }
        };
        this.a.a();
        if (this.b != null) {
            this.b.a();
            final Task<Void> task = this.a.i();
            final Task<Void> task2 = this.b.i();
            Tasks.whenAll((Task[])new Task[]{task, task2}).addOnSuccessListener((OnSuccessListener)onSuccessListener).addOnFailureListener(new OnFailureListener(){

                public void onFailure(@NonNull Exception e2) {
                    Exception exception;
                    Exception exception2 = exception = task.getException() != null ? task.getException() : task2.getException();
                    if (exception != null) {
                        taskCompletionSource.setException(exception);
                    } else {
                        taskCompletionSource.setException(e2);
                    }
                }
            });
            return taskCompletionSource.getTask();
        }
        return this.a.i().addOnSuccessListener((OnSuccessListener)onSuccessListener);
    }

    public boolean addEventListener(EventListener listener) {
        if (listener == null) {
            return false;
        }
        if (this.c == null) {
            this.c = new ArrayList<EventListener>();
        }
        return !this.c.contains(listener) && this.c.add(listener);
    }

    public void addAllEventListener(EventListener ... listeners) {
        if (listeners == null) {
            return;
        }
        for (EventListener eventListener : listeners) {
            this.addEventListener(eventListener);
        }
    }

    public boolean removeEventListener(EventListener listener) {
        return listener != null && this.c != null && this.c.remove(listener);
    }

    public void removeAllEventListener() {
        if (this.c == null) {
            return;
        }
        this.c.clear();
    }

    @NonNull
    private static <T> OnFailureListener a(final OnResultListener<T, MessagingError> onResultListener) {
        return new OnFailureListener(){

            public void onFailure(@NonNull Exception e2) {
                onResultListener.onFailure((Object)ChatroomManager.exceptionToMessagingError(e2));
            }
        };
    }

    private static class a
    implements Continuation<Void, ChatroomManager> {
        private a() {
        }

        public ChatroomManager a(@NonNull Task<Void> task) throws Exception {
            if (task.isSuccessful()) {
                return new ChatroomManager(Credential.getContext());
            }
            if (task.getException() != null) {
                throw task.getException();
            }
            return null;
        }

        public /* synthetic */ Object then(@NonNull Task task) throws Exception {
            return this.a((Task<Void>)task);
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface ConnectFlag {
    }
}

