/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.messaging;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.CountDownTimer;
import android.os.Handler;
import android.preference.PreferenceManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.util.SimpleArrayMap;
import android.text.TextUtils;
import com.ikala.android.controller.Retriable;
import com.ikala.android.controller.RetryDelayController;
import com.ikala.android.httptask.CallManager;
import com.ikala.android.httptask.error.HttpTaskError;
import com.ikala.android.utils.iKalaJSONUtil;
import com.ikala.android.utils.iKalaUtils;
import com.squareup.moshi.JsonDataException;
import com.squareup.moshi.Moshi;
import io.socket.client.IO;
import io.socket.client.Socket;
import io.socket.emitter.Emitter;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.interfaces.OnResultListener;
import io.straas.android.sdk.base.internal.Utils;
import io.straas.android.sdk.messaging.ChatMode;
import io.straas.android.sdk.messaging.ChatroomInfo;
import io.straas.android.sdk.messaging.ChatroomState;
import io.straas.android.sdk.messaging.Message;
import io.straas.android.sdk.messaging.MessagingError;
import io.straas.android.sdk.messaging.Role;
import io.straas.android.sdk.messaging.Sticker;
import io.straas.android.sdk.messaging.User;
import io.straas.android.sdk.messaging.a.a;
import io.straas.android.sdk.messaging.a.a.a;
import io.straas.android.sdk.messaging.interfaces.EventListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.SSLContext;
import okhttp3.Interceptor;
import okhttp3.ResponseBody;
import org.json.JSONArray;
import org.json.JSONObject;
import retrofit2.Call;
import retrofit2.Callback;
import retrofit2.Response;

class a {
    private static final String[] a = new String[]{"websocket"};
    private ChatroomState b = ChatroomState.IDLE;
    private int c;
    private String d;
    private Identity e;
    private boolean f;
    private List<EventListener> g;
    private String h;
    private int i;
    private SimpleArrayMap<String, String> j;
    private List<Sticker> k;
    private String l;
    private String m;
    private Integer n;
    private User o;
    private boolean p;
    private io.straas.android.sdk.messaging.a.a q;
    private final CallManager r = new CallManager();
    private RetryDelayController s;
    private String t;
    private SharedPreferences u;
    private Handler v = new Handler();
    private c w;
    private ChatMode x = ChatMode.ALL;
    private a.a$a y = new a.a$a(){

        @Override
        public void a(String string) {
            a.this.t = string;
            if (a.this.u != null) {
                a.this.u.edit().putString("KEY_API_TOKEN", string).apply();
            }
        }
    };
    private CountDownTimer z = new CountDownTimer(5000L, 5000L){

        public void onTick(long l2) {
        }

        public void onFinish() {
            a.this.a(MessagingError.INTERNAL_ERROR);
        }
    };

    a(Context context) {
        this.i();
        this.u = PreferenceManager.getDefaultSharedPreferences((Context)context);
    }

    private void i() {
        this.s = new RetryDelayController(new Retriable(){

            public void retry() {
                a.this.q();
            }
        });
        this.s.setMaxCount(7);
        this.s.enableExponentialBackoff(true);
        this.s.setBaseRetryInterval(500L);
    }

    private io.straas.android.sdk.messaging.a.a b(Identity identity) {
        return (io.straas.android.sdk.messaging.a.a)Utils.createMemberRetrofit((String)"https://mgr.straas.net", (Identity)identity, (Interceptor[])new Interceptor[]{new io.straas.android.sdk.messaging.a.a.a("https://mgr.straas.net", this.y)}).create(io.straas.android.sdk.messaging.a.a.class);
    }

    void a(@NonNull String string, @NonNull Identity identity, boolean bl, EventListener ... eventListenerArray) {
        if (this.b != ChatroomState.IDLE || TextUtils.isEmpty((CharSequence)string) || identity == null) {
            this.a(new ArrayList<EventListener>(Arrays.asList(eventListenerArray)), MessagingError.REQUEST_REJECTED);
            return;
        }
        this.b = ChatroomState.CONNECTING;
        this.e = identity;
        this.d = string;
        this.f = bl;
        if (eventListenerArray != null) {
            this.g = new ArrayList<EventListener>(Arrays.asList(eventListenerArray));
        }
        this.q = this.b(identity);
        this.s.stop();
        this.p = false;
        this.k();
    }

    boolean a(Identity identity) {
        if (this.b.equals((Object)ChatroomState.CONNECTED)) {
            this.e = identity;
            this.q = this.b(identity);
            return true;
        }
        return false;
    }

    private void j() {
        if (!TextUtils.isEmpty((CharSequence)this.t)) {
            return;
        }
        String string = null;
        if (this.u != null) {
            string = this.u.getString("KEY_API_TOKEN", null);
        }
        this.t = !TextUtils.isEmpty(string) ? string : "unknownApiToken";
    }

    private void a(int n2) {
        switch (n2) {
            case 0: {
                this.l();
                break;
            }
            case 1: {
                this.m();
                break;
            }
            case 2: {
                this.n();
                break;
            }
            case 3: {
                this.o();
            }
        }
    }

    private void k() {
        this.b = ChatroomState.CONNECTING;
        this.j();
        this.a(0);
    }

    private void l() {
        final String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            this.b(MessagingError.INTERNAL_ERROR);
            this.h();
        }
        Call<a$f> call = this.q.a(this.t, this.d, string);
        call.enqueue((Callback)new a<a$f>(this.r, call, null){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a.this.l = ((a$f)response.body()).id;
                    a.this.c = ((a$f)response.body()).inputInterval;
                    a.this.x = ChatMode.a(((a$f)response.body()).chatWriteMode);
                    a.this.i = ((a$f)response.body()).guestCount + ((a$f)response.body()).memberCount;
                    a.this.j = ((a$f)response.body()).getStickerMap();
                    a.this.k = ((a$f)response.body()).getStickerSuite();
                    a.this.a(1);
                }
            }

            @Override
            protected void a(MessagingError messagingError) {
                if (messagingError == MessagingError.UNKNOWN_CHATROOM && a.this.f && !a.this.e.isGuest()) {
                    a.this.a(a.this.d, string);
                } else {
                    super.a(messagingError);
                }
            }
        });
    }

    private void a(String string, String string2) {
        Call<ResponseBody> call = this.q.a(this.t, new a$e(string, string2));
        call.enqueue((Callback)new a<ResponseBody>(this.r, call, null){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful()) {
                    a.this.a(0);
                }
            }
        });
    }

    private void m() {
        this.h = this.e == Identity.GUEST ? "Guest" : null;
        Call<a$c> call = this.q.a(this.t, new a$b(this.l, this.m, this.h));
        call.enqueue((Callback)new a<a$c>(this.r, call, null){

            @Override
            public void onResponse(Call<a$c> call, Response<a$c> response) {
                super.onResponse(call, response);
                if (!a.this.t()) {
                    return;
                }
                if (response.isSuccessful() && response.body() != null) {
                    a$c$a a2 = ((a$c)response.body()).userMetas[0];
                    a.this.m = a2.userToken;
                    a.this.n = (Integer)a2.label;
                    a.this.a(2);
                }
            }
        });
    }

    private void n() {
        this.p();
    }

    private void o() {
        this.s.stop();
        this.b = ChatroomState.CONNECTED;
        if (!this.p) {
            this.p = true;
            this.a(this.g);
        }
    }

    private void p() {
        Socket socket;
        IO.Options options = new IO.Options();
        options.reconnection = false;
        options.rememberUpgrade = true;
        options.forceNew = true;
        options.transports = a;
        options.timeout = 30000L;
        try {
            options.sslContext = SSLContext.getDefault();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
        }
        try {
            socket = IO.socket((String)"https://mgs.straas.net", (IO.Options)options);
        }
        catch (URISyntaxException uRISyntaxException) {
            uRISyntaxException.printStackTrace();
            this.a(MessagingError.INTERNAL_ERROR);
            return;
        }
        this.w = new c(socket);
        this.a(this.w);
        this.b(this.w);
        socket.connect();
    }

    private void a(final c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("connect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                JSONArray jSONArray = new JSONArray();
                jSONArray.put((Object)a.this.m);
                jSONArray.put((Object)a.this.l);
                a.this.z.start();
                c2.a("subscribe", a.this.m, a.this.l);
            }
        });
        c2.a("connect_error", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                a.this.a(MessagingError.NETWORK_ERROR);
            }
        });
        c2.a("disconnect", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (!a.this.t()) {
                    return;
                }
                a.this.a(MessagingError.NETWORK_ERROR);
            }
        });
    }

    private void b(c c2) {
        if (c2 == null) {
            return;
        }
        c2.a("subscribed", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                a.this.z.cancel();
                a.this.o = User.a((JSONObject)objectArray[0]);
                a.this.i++;
                a.this.a(3);
            }
        });
        c2.a("message", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                Message message = Message.a(jSONObject, (SimpleArrayMap<String, String>)a.this.j);
                a.this.a(a.this.g, message, 0L);
            }
        });
        c2.a("message_remove", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof String)) {
                    return;
                }
                String string = (String)objectArray[0];
                a.this.a((List<EventListener>)a.this.g, string);
            }
        });
        c2.a("message_flush", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                a.this.c(a.this.g);
            }
        });
        c2.a("user_add", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                int n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = iKalaJSONUtil.getJSONObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    if (jSONObject == null) continue;
                    User user = User.a(jSONObject);
                    if (a.this.n != null && a.this.n.intValue() == user.getLabel().intValue()) continue;
                    arrayList.add(user);
                    a.this.i++;
                }
                if (arrayList.size() != 0) {
                    a.this.a((List<EventListener>)a.this.g, arrayList.toArray(new User[0]));
                    a.this.a((List<EventListener>)a.this.g, a.this.i);
                }
            }
        });
        c2.a("user_update", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                int n2 = 0;
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                n2 = jSONArray.length();
                ArrayList<User> arrayList = new ArrayList<User>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    User user = User.a(jSONObject);
                    arrayList.add(user);
                    if (a.this.n == null || a.this.n.intValue() != user.getLabel().intValue()) continue;
                    a.this.o = user;
                }
                if (arrayList.size() != 0) {
                    a.this.b((List<EventListener>)a.this.g, arrayList.toArray(new User[0]));
                }
            }
        });
        c2.a("user_remove", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONArray)) {
                    return;
                }
                JSONArray jSONArray = (JSONArray)objectArray[0];
                int n2 = jSONArray.length();
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int i2 = 0; i2 < n2; ++i2) {
                    JSONObject jSONObject = (JSONObject)iKalaJSONUtil.getObjectFromJSONArray((JSONArray)jSONArray, (int)i2);
                    int n3 = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"label", (int)-1);
                    if (-1 == n3) continue;
                    String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"status");
                    if (a.this.n != null && n3 == a.this.n) {
                        switch (string) {
                            case "DELETED": {
                                if (!a.this.t()) break;
                                break;
                            }
                        }
                    } else {
                        Object object = new User.a();
                        ((User.a)object).a(n3).a(string);
                        arrayList.add(n3);
                    }
                    a.this.i--;
                    a.this.i = a.this.i >= 1 ? a.this.i : 1;
                }
                if (arrayList.size() != 0) {
                    a.this.a((List<EventListener>)a.this.g, arrayList.toArray(new Integer[0]));
                    a.this.a((List<EventListener>)a.this.g, a.this.i);
                }
            }
        });
        c2.a("user_count", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                a.this.i = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"guestCount") + iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"memberCount");
                a.this.a((List<EventListener>)a.this.g, a.this.i);
            }
        });
        c2.a("error", new Emitter.Listener(){

            public void call(Object ... objectArray) {
            }
        });
        c2.a("chat_write_mode", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatWriteMode", (String)"ALL");
                a.this.x = ChatMode.a(string);
                a.this.a((List<EventListener>)a.this.g, a.this.x);
            }
        });
        c2.a("message_input_interval", new Emitter.Listener(){

            public void call(Object ... objectArray) {
                if (objectArray == null || objectArray.length <= 0) {
                    return;
                }
                if (!(objectArray[0] instanceof JSONObject)) {
                    return;
                }
                JSONObject jSONObject = (JSONObject)objectArray[0];
                String string = iKalaJSONUtil.getJSONString((JSONObject)jSONObject, (String)"chatId");
                if (!string.equals(a.this.l)) {
                    return;
                }
                a.this.c = iKalaJSONUtil.getJSONInt((JSONObject)jSONObject, (String)"inputInterval");
                a.this.b((List<EventListener>)a.this.g, a.this.c);
            }
        });
    }

    boolean a(EventListener eventListener) {
        if (eventListener == null) {
            return false;
        }
        if (this.g == null) {
            this.g = new ArrayList<EventListener>();
        }
        return !this.g.contains(eventListener) && this.g.add(eventListener);
    }

    void a(EventListener ... eventListenerArray) {
        if (eventListenerArray == null) {
            return;
        }
        for (EventListener eventListener : eventListenerArray) {
            this.a(eventListener);
        }
    }

    boolean b(EventListener eventListener) {
        return eventListener != null && this.g != null && this.g.remove(eventListener);
    }

    void a() {
        if (this.g == null) {
            return;
        }
        this.g.clear();
    }

    private void a(final List<EventListener> list) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final MessagingError messagingError) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onConnectFailed(messagingError);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final MessagingError messagingError) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onError(messagingError);
                }
            }
        });
    }

    private void b(final List<EventListener> list) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onDisconnected();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Message message, long l2) {
        this.v.postDelayed(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageAdded(message);
                }
            }
        }, l2);
    }

    private void a(final List<EventListener> list, final String string) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageRemoved(string);
                }
            }
        });
    }

    private void c(final List<EventListener> list) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onMessageFlushed();
                }
            }
        });
    }

    private void a(final List<EventListener> list, final User[] userArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserJoined(userArray);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final User[] userArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserUpdated(userArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final Integer[] integerArray) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onUserLeft(integerArray);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final int n2) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.userCount(n2);
                }
            }
        });
    }

    private void a(final List<EventListener> list, final ChatMode chatMode) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onChatWriteModeChanged(chatMode);
                }
            }
        });
    }

    private void b(final List<EventListener> list, final int n2) {
        this.v.post(new Runnable(){

            @Override
            public void run() {
                for (EventListener eventListener : list) {
                    eventListener.onInputIntervalChanged(n2);
                }
            }
        });
    }

    void a(int n2, int n3, final @NonNull OnResultListener<Message[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.b != ChatroomState.CONNECTED || !this.a(n2, n3, 100)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n4 = (n2 - 1) * n3;
        Call<a$g> call = this.q.a(this.t, this.m, this.l, Collections.singletonList("USER"), true, n3, n4);
        call.enqueue((Callback)new b<a$g>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<a$g> call, Response<a$g> response) {
                super.onResponse(call, response);
                a$g g2 = (a$g)response.body();
                if (!response.isSuccessful() || g2 == null || g2.messages == null) {
                    return;
                }
                int n2 = g2.messages.length;
                Message[] messageArray = new Message[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    Message message;
                    messageArray[i2] = message = new Message.Builder(g2.messages[i2], (SimpleArrayMap<String, String>)a.this.j).build();
                }
                onResultListener.onSuccess((Object)messageArray);
            }
        });
    }

    void b(int n2, int n3, final @NonNull OnResultListener<User[], MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.b != ChatroomState.CONNECTED || !this.a(n2, n3, 200)) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        int n4 = (n2 - 1) * n3;
        Call<a$h> call = this.q.a(this.t, this.m, this.l, Collections.singletonList("ACTIVE"), null, null, n3, n4);
        call.enqueue((Callback)new b<a$h>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<a$h> call, Response<a$h> response) {
                super.onResponse(call, response);
                a$h h2 = (a$h)response.body();
                if (!response.isSuccessful() || h2 == null || h2.users == null) {
                    return;
                }
                int n2 = h2.users.length;
                User[] userArray = new User[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    User user;
                    userArray[i2] = user = new User.a(h2.users[i2]).a();
                }
                onResultListener.onSuccess((Object)userArray);
            }
        });
    }

    void a(final @NonNull OnResultListener<ChatroomInfo, MessagingError> onResultListener) {
        if (onResultListener == null) {
            return;
        }
        if (this.b != ChatroomState.CONNECTED) {
            onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            return;
        }
        String string = Credential.getAccountId();
        if (TextUtils.isEmpty((CharSequence)string)) {
            onResultListener.onFailure((Object)MessagingError.INTERNAL_ERROR);
            return;
        }
        Call<a$f> call = this.q.a(this.t, this.d, string);
        call.enqueue((Callback)new b<a$f>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<a$f> call, Response<a$f> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && response.body() != null) {
                    onResultListener.onSuccess((Object)((a$f)response.body()).toChatroomInfo());
                }
            }
        });
    }

    void a(String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.b != ChatroomState.CONNECTED || TextUtils.isEmpty((CharSequence)string)) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        Call<ResponseBody> call = this.q.a(this.t, new a$a(this.l, this.m, string, null));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }

            @Override
            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
            }
        });
    }

    void a(Message message) {
        this.a(this.g, message, 100L);
    }

    void b(final String string, final OnResultListener<Void, MessagingError> onResultListener) {
        if (this.b != ChatroomState.CONNECTED || this.e != Identity.GUEST) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        this.h = string;
        Call<ResponseBody> call = this.q.a(this.t, new a$n(this.l, this.m, Collections.singletonList(new a$i(this.n, this.h, null))));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful()) {
                    a.this.o.setName(string);
                    if (onResultListener != null) {
                        onResultListener.onSuccess(null);
                    }
                }
            }
        });
    }

    void a(List<User> list, final OnResultListener<Void, MessagingError> onResultListener) {
        boolean bl;
        Role role = this.o.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED || arrayList.size() == 0) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        if (!bl) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.PERMISSION_ERROR);
            }
            return;
        }
        Call<ResponseBody> call = this.q.a(this.t, new a$d(this.l, this.m, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }
        });
    }

    void b(List<User> list, final OnResultListener<Void, MessagingError> onResultListener) {
        boolean bl;
        Role role = this.o.getRole();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        for (User call2 : list) {
            arrayList.add(call2.getLabel());
        }
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED || arrayList.size() == 0) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        if (!bl) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.PERMISSION_ERROR);
            }
            return;
        }
        Call<ResponseBody> call = this.q.b(this.t, new a$d(this.l, this.m, arrayList));
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }
        });
    }

    void a(Message message, final OnResultListener<Void, MessagingError> onResultListener) {
        boolean bl;
        Role role = this.o.getRole();
        String string = message.getId();
        boolean bl2 = bl = role == Role.MASTER || role == Role.GLOBAL_MANAGER || role == Role.LOCAL_MANAGER;
        if (this.b != ChatroomState.CONNECTED || string == null) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.REQUEST_REJECTED);
            }
            return;
        }
        if (!bl) {
            if (onResultListener != null) {
                onResultListener.onFailure((Object)MessagingError.PERMISSION_ERROR);
            }
            return;
        }
        Call<ResponseBody> call = this.q.a(this.t, this.m, this.l, string);
        call.enqueue((Callback)new b<ResponseBody>(this.r, call, onResultListener){

            @Override
            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (response.isSuccessful() && onResultListener != null) {
                    onResultListener.onSuccess(null);
                }
            }
        });
    }

    List<Sticker> b() {
        return this.k;
    }

    User c() {
        return this.o;
    }

    int d() {
        return this.i;
    }

    ChatMode e() {
        return this.x;
    }

    int f() {
        return this.c;
    }

    ChatroomState g() {
        return this.b;
    }

    void h() {
        if (!this.t()) {
            return;
        }
        this.a(false);
    }

    private void q() {
        this.a(true);
    }

    private void a(boolean bl) {
        if (bl) {
            this.b = ChatroomState.CONNECTING;
        } else {
            this.b = ChatroomState.DISCONNECTING;
            this.s.stop();
        }
        this.r.cancelAllCalls();
        this.s();
        if (iKalaUtils.isEmptyString((CharSequence)this.m) || iKalaUtils.isEmptyString((CharSequence)this.l) || this.n == null) {
            if (bl) {
                this.k();
            }
        } else {
            this.b(bl);
            this.r();
        }
        if (!bl) {
            this.b = ChatroomState.IDLE;
            if (this.p) {
                this.b(this.g);
            }
        }
    }

    private void r() {
        this.l = null;
        this.m = null;
        this.n = null;
        this.o = null;
    }

    private synchronized void s() {
        if (this.w == null) {
            return;
        }
        this.w.a.off();
        this.w.a.disconnect();
    }

    private void b(final boolean bl) {
        Call<ResponseBody> call = this.q.a(this.t, this.m, this.l, Collections.singletonList(this.n));
        call.enqueue((Callback)new CallManager.Callback<ResponseBody>(this.r, call, null){

            public void onResponse(Call<ResponseBody> call, Response<ResponseBody> response) {
                super.onResponse(call, response);
                if (bl) {
                    a.this.k();
                }
            }

            public void onFailure(Call<ResponseBody> call, Throwable throwable) {
                super.onFailure(call, throwable);
                MessagingError messagingError = a.this.a(call, throwable);
                if (bl && messagingError != MessagingError.TASK_CANCELED) {
                    a.this.k();
                }
            }
        });
    }

    private void a(MessagingError messagingError) {
        if (!this.t()) {
            this.b(messagingError);
            return;
        }
        if (!this.c(messagingError) || !this.s.retry()) {
            this.b(messagingError);
            this.h();
        }
    }

    private void b(MessagingError messagingError) {
        if (!this.p) {
            this.a(this.g, messagingError);
        } else if (messagingError != MessagingError.TASK_CANCELED) {
            this.b(this.g, messagingError);
        }
    }

    private boolean c(MessagingError messagingError) {
        switch (messagingError) {
            case NETWORK_ERROR: 
            case INTERNAL_ERROR: 
            case SERVER_ERROR: {
                return true;
            }
        }
        return false;
    }

    private MessagingError a(Response response) {
        int n2 = response.code();
        a$l l2 = this.a(response.errorBody());
        if (l2 == null || l2.code == null) {
            return MessagingError.INTERNAL_ERROR;
        }
        switch (n2) {
            case 401: {
                if (!l2.code.equals("UnauthorizedError")) break;
                return MessagingError.UNAUTHORIZED_ERROR;
            }
            case 403: {
                if (!l2.code.equals("PermissionViolationError")) break;
                return MessagingError.PERMISSION_ERROR;
            }
            case 404: {
                if (!l2.code.equals("EntityNotFoundError")) break;
                return MessagingError.UNKNOWN_CHATROOM;
            }
            case 409: {
                if (!l2.code.equals("DuplicateEntityError") && !l2.code.equals("InvalidRequestError")) break;
                return MessagingError.INTERNAL_ERROR;
            }
            case 500: {
                return MessagingError.SERVER_ERROR;
            }
            default: {
                return MessagingError.INTERNAL_ERROR;
            }
        }
        return MessagingError.INTERNAL_ERROR;
    }

    private MessagingError a(Call call, Throwable throwable) {
        int n2 = HttpTaskError.getThrowableMappingId((Call)call, (Throwable)throwable);
        switch (n2) {
            case 6: {
                return MessagingError.TASK_CANCELED;
            }
        }
        return MessagingError.NETWORK_ERROR;
    }

    private boolean t() {
        return this.b == ChatroomState.CONNECTING || this.b == ChatroomState.CONNECTED;
    }

    private a$l a(ResponseBody responseBody) {
        a$l l2;
        Moshi moshi = new Moshi.Builder().build();
        try {
            l2 = (a$l)moshi.adapter(a$l.class).fromJson(responseBody.source());
        }
        catch (JsonDataException | IOException throwable) {
            throwable.printStackTrace();
            l2 = new a$l();
        }
        return l2;
    }

    private boolean a(int n2, int n3, int n4) {
        return n2 > 0 && n3 > 0 && n3 <= n4;
    }

    private static final class c {
        Socket a;

        c(Socket socket) {
            this.a = socket;
        }

        Emitter a(String string, Object ... objectArray) {
            return this.a.emit(string, objectArray);
        }

        Emitter a(String string, Emitter.Listener listener) {
            return this.a.on(string, listener);
        }
    }

    private class b<T>
    extends CallManager.Callback<T> {
        private int b;
        private OnResultListener c;

        public b(@Nullable CallManager callManager, @Nullable Call call, OnResultListener onResultListener) {
            super(callManager, call, null);
            this.b = 0;
            this.c = onResultListener;
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(call, messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(call, messagingError);
        }

        private void a(final Call<T> call, MessagingError messagingError) {
            if (++this.b <= 3 && a.this.t() && a.this.c(messagingError)) {
                a.this.v.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        Call call2 = call.clone();
                        call2.enqueue((Callback)b.this);
                    }
                }, 1000L);
            } else if (this.c != null && messagingError != MessagingError.TASK_CANCELED) {
                this.c.onFailure((Object)messagingError);
            }
        }
    }

    private class a<T>
    extends CallManager.Callback<T> {
        public a(@Nullable CallManager callManager, @Nullable Call call, @Nullable CallManager.OnHttpTaskLoadingCallback onHttpTaskLoadingCallback) {
            super(callManager, call, onHttpTaskLoadingCallback);
        }

        public void onResponse(Call<T> call, Response<T> response) {
            super.onResponse(call, response);
            if (!response.isSuccessful()) {
                MessagingError messagingError = a.this.a(response);
                this.a(messagingError);
            }
        }

        public void onFailure(Call<T> call, Throwable throwable) {
            super.onFailure(call, throwable);
            MessagingError messagingError = a.this.a(call, throwable);
            this.a(messagingError);
        }

        protected void a(MessagingError messagingError) {
            a.this.a(messagingError);
        }
    }
}

