/*
 * Decompiled with CFR 0.152.
 */
package io.straas.android.sdk.base.internal;

import android.content.Context;
import android.os.Handler;
import android.support.annotation.NonNull;
import android.text.TextUtils;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.model.ModelLoaderFactory;
import com.ikala.android.httptask.auth.HttpDefaultAuth;
import com.ikala.android.httptask.auth.TokenContainer;
import com.ikala.android.httptask.iKalaHttpUtils;
import com.ikala.android.httptask.interceptor.AuthInterceptor;
import com.ikala.android.httptask.interceptor.CommonHeaderInterceptor;
import io.straas.android.sdk.base.credential.Credential;
import io.straas.android.sdk.base.identity.Identity;
import io.straas.android.sdk.base.identity.a;
import io.straas.android.sdk.base.internal.a.b;
import io.straas.android.sdk.base.internal.a.c;
import java.io.InputStream;
import java.util.Collections;
import java.util.concurrent.Executor;
import okhttp3.Authenticator;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.moshi.MoshiConverterFactory;

public class Utils {
    public static Retrofit createAppRetrofit() {
        OkHttpClient.Builder builder = iKalaHttpUtils.getOkHttpClient().newBuilder();
        final String string = Credential.getKey();
        if (!TextUtils.isEmpty((CharSequence)string)) {
            builder.addInterceptor((Interceptor)new AuthInterceptor(new HttpDefaultAuth(new TokenContainer(){

                @Override
                public String getToken() {
                    return string;
                }
            })));
        }
        return new Retrofit.Builder().baseUrl("https://app.straas.net").addConverterFactory((Converter.Factory)MoshiConverterFactory.create()).client(builder.build()).build();
    }

    public static Retrofit createMemberRetrofit(String baseUrl, Identity identity, Interceptor ... interceptors) {
        return Utils.createMemberRetrofit(baseUrl, identity, false, interceptors);
    }

    public static Retrofit createMemberRetrofit(String baseUrl, Identity identity, boolean withNullSerialization, Interceptor ... interceptors) {
        OkHttpClient.Builder builder = iKalaHttpUtils.getOkHttpClient().newBuilder().addInterceptor((Interceptor)new AuthInterceptor(new HttpDefaultAuth(identity))).authenticator((Authenticator)new a(identity));
        if (interceptors != null) {
            for (Interceptor interceptor : interceptors) {
                builder.addInterceptor(interceptor);
            }
        }
        return new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)(withNullSerialization ? MoshiConverterFactory.create().withNullSerialization() : MoshiConverterFactory.create())).client(builder.build()).build();
    }

    public static void configGlide() {
        Glide.get((Context)Credential.getContext()).getRegistry().replace(c.class, InputStream.class, (ModelLoaderFactory)new b.a());
    }

    public static Object getGlideUrl(String url) {
        return new c(url);
    }

    static {
        iKalaHttpUtils.initOkHttpClient(iKalaHttpUtils.getOkHttpClient().newBuilder().addInterceptor((Interceptor)new CommonHeaderInterceptor.Builder().setHeader("X-SDK-Version", "Android v0.9.7").setUserAgent(System.getProperty("http.agent")).build()).protocols(Collections.singletonList(Protocol.HTTP_1_1)));
    }

    public static class HandlerThreadExecutor
    implements Executor {
        private final Handler a;

        public HandlerThreadExecutor(@NonNull Handler handler) {
            this.a = handler;
        }

        @Override
        public void execute(@NonNull Runnable command) {
            this.a.post(command);
        }
    }
}

