/*
 * Decompiled with CFR 0.152.
 */
package com.ikala.android.ubt;

import android.content.Context;
import com.ikala.android.ubt.UBTEventBroadcastReciever;
import com.ikala.android.ubt.UBT_Event;
import com.ikala.android.ubt.UBT_Instance;
import com.ikala.android.ubt.UBT_Observer;
import com.ikala.android.ubt.UBT_UserInfo;
import java.lang.ref.WeakReference;
import java.util.Vector;

public class UBT_Observable {
    protected WeakReference<Context> a = null;
    public Vector<UBT_Observer> mObservers = new Vector();

    public UBT_Observable() {
    }

    public UBT_Observable(Context context) {
        this();
        if (null != context) {
            this.a = new WeakReference<Context>(context);
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (null != this.mObservers) {
            this.mObservers.clear();
            this.mObservers = null;
        }
    }

    public void registerObserver(UBT_Observer p_Observer) {
        this.mObservers.add(p_Observer);
    }

    public void removeObserver(UBT_Observer p_Observer) {
        this.mObservers.remove(p_Observer);
    }

    public void preProc() {
        Context context = (Context)this.a.get();
        for (int i = 0; i < this.mObservers.size(); ++i) {
            UBT_Observer uBT_Observer = this.mObservers.get(i);
            uBT_Observer.preProc(context);
        }
    }

    public void postProc() {
        for (int i = 0; i < this.mObservers.size(); ++i) {
            UBT_Observer uBT_Observer = this.mObservers.get(i);
            uBT_Observer.postProc();
        }
    }

    public void sessionBegin(Context context, int iSessionType) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.sessionBegin(context, iSessionType);
            }
        } else if (context != null) {
            UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.StartSession, null);
        }
    }

    public void sessionEnd(Context context, int iSessionType) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.sessionEnd(context, iSessionType);
            }
        } else if (context != null) {
            UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.EndSession, null);
        }
    }

    public void eventBegin(UBT_Event e, int iSessionType) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.eventBegin(e, iSessionType);
            }
        } else {
            Context context = (Context)this.a.get();
            if (null != context) {
                UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.BeginEvent, e);
            }
        }
    }

    public void eventEnd(UBT_Event e, int iSessionType) {
        if (UBT_Instance.getInstance().isTrackedProcess()) {
            for (int i = 0; i < this.mObservers.size(); ++i) {
                UBT_Observer uBT_Observer = this.mObservers.get(i);
                uBT_Observer.eventEnd(e, iSessionType);
            }
        } else {
            Context context = (Context)this.a.get();
            if (null != context) {
                UBTEventBroadcastReciever.broadcastEventToMainProcess(context, UBTEventBroadcastReciever.EventType.EndEvent, e);
            }
        }
    }

    public void userInfo(UBT_UserInfo u) {
        for (int i = 0; i < this.mObservers.size(); ++i) {
            UBT_Observer uBT_Observer = this.mObservers.get(i);
            uBT_Observer.userInfo(u);
        }
    }
}

