/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector.primitive;

import java.sql.Timestamp;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.format.DateTimeParseException;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.regex.Pattern;

public final class ParsePrimitiveUtils {
    private static final DateTimeFormatter NO_COLON_OFFSET_FORMAT;
    private static final DateTimeFormatter LOCAL_PRINT_FORMATTER;
    private static final DateTimeFormatter UTC_PRINT_FORMATTER;
    static Pattern hasTZOffset;

    private ParsePrimitiveUtils() {
        throw new InstantiationError("This class must not be instantiated.");
    }

    public static boolean isHex(String s) {
        return s.startsWith("0x") || s.startsWith("0X");
    }

    public static byte parseByte(String s) {
        if (ParsePrimitiveUtils.isHex(s)) {
            return Byte.parseByte(s.substring(2), 16);
        }
        return Byte.parseByte(s);
    }

    public static int parseInt(String s) {
        if (ParsePrimitiveUtils.isHex(s)) {
            return Integer.parseInt(s.substring(2), 16);
        }
        return Integer.parseInt(s);
    }

    public static short parseShort(String s) {
        if (ParsePrimitiveUtils.isHex(s)) {
            return Short.parseShort(s.substring(2), 16);
        }
        return Short.parseShort(s);
    }

    public static long parseLong(String s) {
        if (ParsePrimitiveUtils.isHex(s)) {
            return Long.parseLong(s.substring(2), 16);
        }
        return Long.parseLong(s);
    }

    public static String serializeAsUTC(Timestamp ts) {
        return UTC_PRINT_FORMATTER.format(ts.toInstant());
    }

    public static String serializeAsUTC(org.apache.hadoop.hive.common.type.Timestamp ts) {
        return ts.format(UTC_PRINT_FORMATTER);
    }

    public static org.apache.hadoop.hive.common.type.Timestamp parseTimestamp(String s, List<DateTimeFormatter> timestampFormaters) {
        if (timestampFormaters == null) {
            org.apache.hadoop.hive.common.type.Timestamp value;
            String sampleUnixTimestampInMs = "1454612111000";
            if (s.indexOf(58) > 0) {
                value = org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)ParsePrimitiveUtils.nonUTCFormat(s));
            } else if (s.indexOf(46) >= 0) {
                double secondsFromEpoch = Double.parseDouble(s);
                value = org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)((long)(secondsFromEpoch * 1000.0)));
            } else {
                long timestampValue = Long.parseLong(s);
                boolean isTimestampInMs = s.length() >= "1454612111000".length();
                value = isTimestampInMs ? org.apache.hadoop.hive.common.type.Timestamp.ofEpochMilli((long)timestampValue) : org.apache.hadoop.hive.common.type.Timestamp.ofEpochSecond((long)timestampValue);
            }
            return value;
        }
        DateTimeParseException lastException = null;
        for (DateTimeFormatter formatter : timestampFormaters) {
            try {
                ZonedDateTime zonedDateTime = formatter.parse((CharSequence)s, ZonedDateTime::from);
                return org.apache.hadoop.hive.common.type.Timestamp.ofEpochSecond((long)zonedDateTime.toEpochSecond(), (int)zonedDateTime.getNano());
            }
            catch (DateTimeParseException ex) {
                lastException = ex;
            }
        }
        throw lastException;
    }

    public static String nonUTCFormat(String s) {
        ZonedDateTime parsed;
        block4: {
            parsed = null;
            try {
                if (s.endsWith("Z") || hasTZOffset.matcher(s).matches()) {
                    parsed = s.charAt(s.length() - 3) == ':' ? ZonedDateTime.parse(s, DateTimeFormatter.ISO_OFFSET_DATE_TIME) : ZonedDateTime.parse(s, NO_COLON_OFFSET_FORMAT);
                    break block4;
                }
                return s;
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        if (parsed != null) {
            return LOCAL_PRINT_FORMATTER.format(parsed.withZoneSameInstant(ZoneId.of("UTC")));
        }
        return s;
    }

    static {
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        builder.appendOffset("+HHMM", "Z");
        NO_COLON_OFFSET_FORMAT = builder.toFormatter();
        builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        builder.optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd();
        LOCAL_PRINT_FORMATTER = builder.toFormatter();
        builder = new DateTimeFormatterBuilder();
        builder.append(DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss"));
        builder.optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 0, 9, true).optionalEnd();
        builder.appendLiteral('Z');
        UTC_PRINT_FORMATTER = builder.toFormatter();
        hasTZOffset = Pattern.compile(".+(\\+|-)\\d{2}:?\\d{2}$");
    }
}

