/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector.primitive;

import java.sql.Timestamp;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hive.serde2.io.TimestampWritableV2;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableTimestampObjectInspector;
import org.openx.data.jsonserde.objectinspector.primitive.ParsePrimitiveUtils;
import org.openx.data.jsonserde.objectinspector.primitive.TypeEntryShim;

public class JavaStringTimestampObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableTimestampObjectInspector {
    private List<DateTimeFormatter> timestampFormatters;

    public JavaStringTimestampObjectInspector(String timestampFormats) {
        super(TypeEntryShim.timestampType);
        this.timestampFormatters = JavaStringTimestampObjectInspector.generateFormatters(timestampFormats);
    }

    private static List<DateTimeFormatter> generateFormatters(String timestampFormats) {
        if (timestampFormats == null) {
            return null;
        }
        return Arrays.stream(timestampFormats.split(",")).map(DateTimeFormatter::ofPattern).map(formatter -> formatter.withZone(ZoneOffset.UTC)).collect(Collectors.toList());
    }

    public Object set(Object o, byte[] bytes, int offset) {
        return this.create(bytes, offset);
    }

    @Deprecated
    public Object set(Object o, Timestamp tmstmp) {
        return ParsePrimitiveUtils.serializeAsUTC(tmstmp);
    }

    public Object set(Object o, org.apache.hadoop.hive.common.type.Timestamp timestamp) {
        return ParsePrimitiveUtils.serializeAsUTC(timestamp);
    }

    public Object set(Object o, TimestampWritableV2 tw) {
        return this.create(tw.getTimestamp());
    }

    public Object create(byte[] bytes, int offset) {
        return new TimestampWritableV2(bytes, offset).toString();
    }

    @Deprecated
    public Object create(Timestamp tmstmp) {
        return ParsePrimitiveUtils.serializeAsUTC(tmstmp);
    }

    public Object create(org.apache.hadoop.hive.common.type.Timestamp timestamp) {
        return ParsePrimitiveUtils.serializeAsUTC(timestamp);
    }

    public TimestampWritableV2 getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return new TimestampWritableV2(org.apache.hadoop.hive.common.type.Timestamp.valueOf((String)((String)o)));
        }
        if (o instanceof org.apache.hadoop.hive.common.type.Timestamp) {
            return new TimestampWritableV2((org.apache.hadoop.hive.common.type.Timestamp)o);
        }
        return (TimestampWritableV2)o;
    }

    public org.apache.hadoop.hive.common.type.Timestamp getPrimitiveJavaObject(Object o) {
        if (o instanceof String) {
            return ParsePrimitiveUtils.parseTimestamp((String)o, this.timestampFormatters);
        }
        if (o instanceof Number) {
            return ParsePrimitiveUtils.parseTimestamp(o.toString(), this.timestampFormatters);
        }
        return (org.apache.hadoop.hive.common.type.Timestamp)o;
    }
}

