/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde.objectinspector;

import io.starburst.openjson.JSONException;
import io.starburst.openjson.JSONObject;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class JSONObjectMapAdapter
implements Map {
    HashMap<String, Object> cache;
    JSONObject jsonObject;

    public JSONObjectMapAdapter(JSONObject obj) {
        this.jsonObject = obj;
        this.initialize();
    }

    public JSONObjectMapAdapter() {
    }

    public JSONObject getJSONObject() {
        return this.jsonObject;
    }

    public void setJSONObject(JSONObject jsonObject) {
        this.jsonObject = jsonObject;
        this.initialize();
    }

    @Override
    public int size() {
        return this.jsonObject.length();
    }

    @Override
    public boolean isEmpty() {
        return this.cache.isEmpty();
    }

    protected final void initialize() {
        if (this.cache == null) {
            this.cache = new HashMap();
        }
        Iterator i = this.jsonObject.keys();
        while (i.hasNext()) {
            String o = (String)i.next();
            try {
                this.cache.put(o, this.safeGet(o));
            }
            catch (JSONException ex) {
                throw new RuntimeException("Non existent key - should never happen!");
            }
        }
    }

    private Object safeGet(String s) throws JSONException {
        if (s == null) {
            return null;
        }
        Object obj = this.jsonObject.get(s);
        if (JSONObject.NULL.equals(obj)) {
            return null;
        }
        return obj;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.cache.containsValue(value);
    }

    public Object get(Object key) {
        return this.cache.get(key);
    }

    public Object put(Object key, Object value) {
        return this.cache.put(key.toString(), value);
    }

    public Object remove(Object key) {
        return this.cache.remove(key);
    }

    public void putAll(Map m) {
        this.cache.putAll(m);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    public Set keySet() {
        return this.cache.keySet();
    }

    public Collection values() {
        return this.cache.values();
    }

    public Set entrySet() {
        return this.cache.entrySet();
    }

    public Map<?, ?> getMap() {
        return this.cache;
    }
}

