/*
 * Decompiled with CFR 0.152.
 */
package org.openx.data.jsonserde;

import io.starburst.openjson.JSONArray;
import io.starburst.openjson.JSONException;
import io.starburst.openjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.AbstractSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.UnionObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.BooleanObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ByteObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.DoubleObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.FloatObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.LongObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.ShortObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.StringObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.TimestampObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.StructTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.openx.data.jsonserde.objectinspector.JsonObjectInspectorFactory;
import org.openx.data.jsonserde.objectinspector.JsonStructOIOptions;
import org.openx.data.jsonserde.objectinspector.primitive.ParsePrimitiveUtils;

public class JsonSerDe
extends AbstractSerDe {
    public static final Log LOG = LogFactory.getLog(JsonSerDe.class);
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private StructTypeInfo rowTypeInfo;
    private StructObjectInspector rowObjectInspector;
    private boolean[] columnSortOrderIsDesc;
    private SerDeStats stats;
    private boolean lastOperationSerialize;
    private long deserializedDataSize;
    private long serializedDataSize;
    private boolean ignoreMalformedJson = false;
    private boolean explicitNull = false;
    private boolean isCaseInsensitive = true;
    public static final String PROP_IGNORE_MALFORMED_JSON = "ignore.malformed.json";
    public static final String PROP_DOTS_IN_KEYS = "dots.in.keys";
    public static final String PROP_CASE_INSENSITIVE = "case.insensitive";
    public static final String PROP_EXPLICIT_NULL = "explicit.null";
    public static final String PROP_TIMESTAMP_FORMATS = "timestamp.formats";
    JsonStructOIOptions options;
    public static final String PFX = "mapping.";

    public void initialize(Configuration conf, Properties tbl) throws SerDeException {
        LOG.debug((Object)"Initializing SerDe");
        String columnNameProperty = tbl.getProperty("columns");
        String columnTypeProperty = tbl.getProperty("columns.types");
        LOG.debug((Object)("columns " + columnNameProperty + " types " + columnTypeProperty));
        this.columnNames = columnNameProperty.length() == 0 ? new ArrayList<String>() : Arrays.asList(columnNameProperty.split(","));
        this.columnTypes = columnTypeProperty.length() == 0 ? new ArrayList<TypeInfo>() : TypeInfoUtils.getTypeInfosFromTypeString((String)columnTypeProperty);
        assert (this.columnNames.size() == this.columnTypes.size());
        this.stats = new SerDeStats();
        this.rowTypeInfo = (StructTypeInfo)TypeInfoFactory.getStructTypeInfo(this.columnNames, this.columnTypes);
        this.isCaseInsensitive = Boolean.parseBoolean(tbl.getProperty(PROP_CASE_INSENSITIVE, "true"));
        this.options = new JsonStructOIOptions(this.getMappings(tbl, this.isCaseInsensitive));
        this.options.setCaseInsensitive(this.isCaseInsensitive);
        String columnSortOrder = tbl.getProperty("serialization.sort.order");
        this.columnSortOrderIsDesc = new boolean[this.columnNames.size()];
        for (int i = 0; i < this.columnSortOrderIsDesc.length; ++i) {
            this.columnSortOrderIsDesc[i] = columnSortOrder != null && columnSortOrder.charAt(i) == '-';
        }
        this.options.setDotsInKeyNames(Boolean.parseBoolean(tbl.getProperty(PROP_DOTS_IN_KEYS, "false")));
        this.options.setTimestampFormats(tbl.getProperty(PROP_TIMESTAMP_FORMATS));
        this.rowObjectInspector = (StructObjectInspector)JsonObjectInspectorFactory.getJsonObjectInspectorFromTypeInfo((TypeInfo)this.rowTypeInfo, this.options);
        this.ignoreMalformedJson = Boolean.parseBoolean(tbl.getProperty(PROP_IGNORE_MALFORMED_JSON, "false"));
        this.explicitNull = Boolean.parseBoolean(tbl.getProperty(PROP_EXPLICIT_NULL, "false"));
    }

    public Object deserialize(Writable w) throws SerDeException {
        Text rowText = (Text)w;
        this.deserializedDataSize = rowText.getBytes().length;
        JSONObject jObj = null;
        try {
            String txt = rowText.toString().trim();
            if (txt.startsWith("{")) {
                jObj = new JSONObject(this.isCaseInsensitive, txt);
            } else if (txt.startsWith("[")) {
                jObj = new JSONArray(this.isCaseInsensitive, txt);
            }
        }
        catch (JSONException e) {
            this.onMalformedJson("Row is not a valid JSON Object - JSONException: " + e.getMessage());
            try {
                jObj = new JSONObject(this.isCaseInsensitive, "{}");
            }
            catch (JSONException ex) {
                this.onMalformedJson("Error parsing empty row. This should never happen.");
            }
        }
        return jObj;
    }

    public ObjectInspector getObjectInspector() throws SerDeException {
        return this.rowObjectInspector;
    }

    public Class<? extends Writable> getSerializedClass() {
        return Text.class;
    }

    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        if (objInspector.getCategory() != ObjectInspector.Category.STRUCT) {
            throw new SerDeException(((Object)((Object)this)).getClass().toString() + " can only serialize struct types, but we got: " + objInspector.getTypeName());
        }
        JSONObject serializer = this.serializeStruct(obj, (StructObjectInspector)objInspector, this.columnNames);
        Text t = new Text(serializer.toString());
        this.serializedDataSize = t.getBytes().length;
        return t;
    }

    private String getSerializedFieldName(List<String> columnNames, int pos, StructField sf) {
        String n;
        String string = n = columnNames == null ? sf.getFieldName() : columnNames.get(pos);
        if (this.options.getMappings().containsKey(n)) {
            return this.options.getMappings().get(n);
        }
        return n;
    }

    private JSONObject serializeStruct(Object obj, StructObjectInspector soi, List<String> columnNames) {
        if (null == obj) {
            return null;
        }
        JSONObject result = new JSONObject(this.isCaseInsensitive);
        List fields = soi.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            StructField sf = (StructField)fields.get(i);
            Object data = soi.getStructFieldData(obj, sf);
            try {
                if (null != data) {
                    result.put(this.getSerializedFieldName(columnNames, i, sf), this.serializeField(data, sf.getFieldObjectInspector()));
                    continue;
                }
                if (!this.explicitNull) continue;
                result.putNull(this.getSerializedFieldName(columnNames, i, sf));
                continue;
            }
            catch (JSONException ex) {
                LOG.warn((Object)"Problem serializing", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    public Object serializeField(Object obj, ObjectInspector oi) {
        if (obj == null) {
            return null;
        }
        Object result = null;
        block0 : switch (oi.getCategory()) {
            case PRIMITIVE: {
                PrimitiveObjectInspector poi = (PrimitiveObjectInspector)oi;
                switch (poi.getPrimitiveCategory()) {
                    case VOID: {
                        result = null;
                        break block0;
                    }
                    case BOOLEAN: {
                        result = ((BooleanObjectInspector)poi).get(obj) ? Boolean.TRUE : Boolean.FALSE;
                        break block0;
                    }
                    case BYTE: {
                        result = ((ByteObjectInspector)poi).get(obj);
                        break block0;
                    }
                    case DOUBLE: {
                        result = ((DoubleObjectInspector)poi).get(obj);
                        break block0;
                    }
                    case FLOAT: {
                        result = Float.valueOf(((FloatObjectInspector)poi).get(obj));
                        break block0;
                    }
                    case INT: {
                        result = ((IntObjectInspector)poi).get(obj);
                        break block0;
                    }
                    case LONG: {
                        result = ((LongObjectInspector)poi).get(obj);
                        break block0;
                    }
                    case SHORT: {
                        result = ((ShortObjectInspector)poi).get(obj);
                        break block0;
                    }
                    case STRING: {
                        result = ((StringObjectInspector)poi).getPrimitiveJavaObject(obj);
                        break block0;
                    }
                    case TIMESTAMP: {
                        result = ParsePrimitiveUtils.serializeAsUTC(((TimestampObjectInspector)poi).getPrimitiveJavaObject(obj));
                        break block0;
                    }
                    case UNKNOWN: {
                        throw new RuntimeException("Unknown primitive");
                    }
                }
                break;
            }
            case MAP: {
                result = this.serializeMap(obj, (MapObjectInspector)oi);
                break;
            }
            case LIST: {
                result = this.serializeList(obj, (ListObjectInspector)oi);
                break;
            }
            case STRUCT: {
                result = this.serializeStruct(obj, (StructObjectInspector)oi, null);
                break;
            }
            case UNION: {
                result = this.serializeUnion(obj, (UnionObjectInspector)oi);
            }
        }
        return result;
    }

    private JSONArray serializeList(Object obj, ListObjectInspector loi) {
        if (obj == null) {
            return null;
        }
        JSONArray ar = new JSONArray(this.isCaseInsensitive);
        for (int i = loi.getListLength(obj) - 1; i >= 0; --i) {
            Object element = loi.getListElement(obj, i);
            try {
                ar.put(i, this.serializeField(element, loi.getListElementObjectInspector()));
                continue;
            }
            catch (JSONException ex) {
                LOG.warn((Object)"Problem serializing array", (Throwable)ex);
                throw new RuntimeException(ex);
            }
        }
        return ar;
    }

    private Object serializeUnion(Object obj, UnionObjectInspector oi) {
        if (obj == null) {
            return null;
        }
        return this.serializeField(obj, (ObjectInspector)oi.getObjectInspectors().get(oi.getTag(obj)));
    }

    private JSONObject serializeMap(Object obj, MapObjectInspector moi) {
        if (obj == null) {
            return null;
        }
        JSONObject jo = new JSONObject(this.isCaseInsensitive);
        Map m = moi.getMap(obj);
        for (Object k : m.keySet()) {
            try {
                jo.put(this.serializeField(k, moi.getMapKeyObjectInspector()).toString(), this.serializeField(m.get(k), moi.getMapValueObjectInspector()));
            }
            catch (JSONException ex) {
                LOG.warn((Object)"Problem serializing map");
            }
        }
        return jo;
    }

    public void onMalformedJson(String msg) throws SerDeException {
        if (!this.ignoreMalformedJson) {
            throw new SerDeException(msg);
        }
        LOG.warn((Object)("Ignoring malformed JSON: " + msg));
    }

    public SerDeStats getSerDeStats() {
        if (this.lastOperationSerialize) {
            this.stats.setRawDataSize(this.serializedDataSize);
        } else {
            this.stats.setRawDataSize(this.deserializedDataSize);
        }
        return this.stats;
    }

    private Map<String, String> getMappings(Properties tbl, boolean isCaseInsensitive) {
        int n = PFX.length();
        HashMap<String, String> mps = new HashMap<String, String>();
        for (Object o : tbl.keySet()) {
            String s;
            if (!(o instanceof String) || !(s = (String)o).startsWith(PFX)) continue;
            String fieldTo = tbl.getProperty(s);
            mps.put(s.substring(n), isCaseInsensitive ? fieldTo.toLowerCase() : fieldTo);
        }
        return mps;
    }
}

